/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.views.magicindicator.buildins.commonnavigator;

import android.content.Context;
import android.database.DataSetObserver;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import com.moments.filepicker.R;
import com.moments.filepicker.views.magicindicator.NavigatorHelper;
import com.moments.filepicker.views.magicindicator.abs.IPagerNavigator;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.CommonNavigatorAdapter;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IMeasurablePagerTitleView;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IPagerTitleView;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.model.PositionData;
import java.util.ArrayList;
import java.util.List;

public class CommonNavigator
extends FrameLayout
implements IPagerNavigator,
NavigatorHelper.OnNavigatorScrollListener {
    private HorizontalScrollView mScrollView;
    private LinearLayout mTitleContainer;
    private LinearLayout mIndicatorContainer;
    private IPagerIndicator mIndicator;
    private CommonNavigatorAdapter mAdapter;
    private NavigatorHelper mNavigatorHelper;
    private boolean mAdjustMode;
    private boolean mEnablePivotScroll;
    private float mScrollPivotX = 0.5f;
    private boolean mSmoothScroll = true;
    private boolean mFollowTouch = true;
    private int mRightPadding;
    private int mLeftPadding;
    private boolean mIndicatorOnTop;
    private boolean mSkimOver;
    private boolean mReselectWhenLayout = true;
    private List<PositionData> mPositionDataList = new ArrayList<PositionData>();
    private DataSetObserver mObserver = new DataSetObserver(){

        public void onChanged() {
            CommonNavigator.this.mNavigatorHelper.setTotalCount(CommonNavigator.this.mAdapter.getCount());
            CommonNavigator.this.init();
        }

        public void onInvalidated() {
        }
    };

    public CommonNavigator(Context context) {
        super(context);
        this.mNavigatorHelper = new NavigatorHelper();
        this.mNavigatorHelper.setNavigatorScrollListener(this);
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public boolean isAdjustMode() {
        return this.mAdjustMode;
    }

    public void setAdjustMode(boolean is) {
        this.mAdjustMode = is;
    }

    public CommonNavigatorAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(CommonNavigatorAdapter adapter) {
        if (this.mAdapter == adapter) {
            return;
        }
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            this.mAdapter.registerDataSetObserver(this.mObserver);
            this.mNavigatorHelper.setTotalCount(this.mAdapter.getCount());
            if (this.mTitleContainer != null) {
                this.mAdapter.notifyDataSetChanged();
            }
        } else {
            this.mNavigatorHelper.setTotalCount(0);
            this.init();
        }
    }

    private void init() {
        this.removeAllViews();
        View root = this.mAdjustMode ? LayoutInflater.from((Context)this.getContext()).inflate(R.layout.moments_filepicker_pager_navigator_layout_no_scroll, (ViewGroup)this) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.moments_filepicker_pager_navigator_layout, (ViewGroup)this);
        this.mScrollView = (HorizontalScrollView)root.findViewById(R.id.scroll_view);
        this.mTitleContainer = (LinearLayout)root.findViewById(R.id.title_container);
        this.mTitleContainer.setPadding(this.mLeftPadding, 0, this.mRightPadding, 0);
        this.mIndicatorContainer = (LinearLayout)root.findViewById(R.id.indicator_container);
        if (this.mIndicatorOnTop) {
            this.mIndicatorContainer.getParent().bringChildToFront((View)this.mIndicatorContainer);
        }
        this.initTitlesAndIndicator();
    }

    private void initTitlesAndIndicator() {
        int j = this.mNavigatorHelper.getTotalCount();
        for (int i = 0; i < j; ++i) {
            LinearLayout.LayoutParams lp;
            IPagerTitleView v = this.mAdapter.getTitleView(this.getContext(), i);
            if (!(v instanceof View)) continue;
            View view = (View)v;
            if (this.mAdjustMode) {
                lp = new LinearLayout.LayoutParams(0, -1);
                lp.weight = this.mAdapter.getTitleWeight(this.getContext(), i);
            } else {
                lp = new LinearLayout.LayoutParams(-2, -1);
            }
            this.mTitleContainer.addView(view, (ViewGroup.LayoutParams)lp);
        }
        if (this.mAdapter != null) {
            this.mIndicator = this.mAdapter.getIndicator(this.getContext());
            if (this.mIndicator instanceof View) {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
                this.mIndicatorContainer.addView((View)this.mIndicator, (ViewGroup.LayoutParams)lp);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter != null) {
            this.preparePositionData();
            if (this.mIndicator != null) {
                this.mIndicator.onPositionDataProvide(this.mPositionDataList);
            }
            if (this.mReselectWhenLayout && this.mNavigatorHelper.getScrollState() == 0) {
                this.onPageSelected(this.mNavigatorHelper.getCurrentIndex());
                this.onPageScrolled(this.mNavigatorHelper.getCurrentIndex(), 0.0f, 0);
            }
        }
    }

    private void preparePositionData() {
        this.mPositionDataList.clear();
        int j = this.mNavigatorHelper.getTotalCount();
        for (int i = 0; i < j; ++i) {
            PositionData data = new PositionData();
            View v = this.mTitleContainer.getChildAt(i);
            if (v != null) {
                data.mLeft = v.getLeft();
                data.mTop = v.getTop();
                data.mRight = v.getRight();
                data.mBottom = v.getBottom();
                if (v instanceof IMeasurablePagerTitleView) {
                    IMeasurablePagerTitleView view = (IMeasurablePagerTitleView)v;
                    data.mContentLeft = view.getContentLeft();
                    data.mContentTop = view.getContentTop();
                    data.mContentRight = view.getContentRight();
                    data.mContentBottom = view.getContentBottom();
                } else {
                    data.mContentLeft = data.mLeft;
                    data.mContentTop = data.mTop;
                    data.mContentRight = data.mRight;
                    data.mContentBottom = data.mBottom;
                }
            }
            this.mPositionDataList.add(data);
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mAdapter != null) {
            this.mNavigatorHelper.onPageScrolled(position, positionOffset, positionOffsetPixels);
            if (this.mIndicator != null) {
                this.mIndicator.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
            if (this.mScrollView != null && this.mPositionDataList.size() > 0 && position >= 0 && position < this.mPositionDataList.size()) {
                if (this.mFollowTouch) {
                    int currentPosition = Math.min(this.mPositionDataList.size() - 1, position);
                    int nextPosition = Math.min(this.mPositionDataList.size() - 1, position + 1);
                    PositionData current = this.mPositionDataList.get(currentPosition);
                    PositionData next = this.mPositionDataList.get(nextPosition);
                    float scrollTo = (float)current.horizontalCenter() - (float)this.mScrollView.getWidth() * this.mScrollPivotX;
                    float nextScrollTo = (float)next.horizontalCenter() - (float)this.mScrollView.getWidth() * this.mScrollPivotX;
                    this.mScrollView.scrollTo((int)(scrollTo + (nextScrollTo - scrollTo) * positionOffset), 0);
                } else if (!this.mEnablePivotScroll) {
                    // empty if block
                }
            }
        }
    }

    public float getScrollPivotX() {
        return this.mScrollPivotX;
    }

    public void setScrollPivotX(float scrollPivotX) {
        this.mScrollPivotX = scrollPivotX;
    }

    @Override
    public void onPageSelected(int position) {
        if (this.mAdapter != null) {
            this.mNavigatorHelper.onPageSelected(position);
            if (this.mIndicator != null) {
                this.mIndicator.onPageSelected(position);
            }
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        if (this.mAdapter != null) {
            this.mNavigatorHelper.onPageScrollStateChanged(state);
            if (this.mIndicator != null) {
                this.mIndicator.onPageScrollStateChanged(state);
            }
        }
    }

    @Override
    public void onAttachToMagicIndicator() {
        this.init();
    }

    @Override
    public void onDetachFromMagicIndicator() {
    }

    public IPagerIndicator getPagerIndicator() {
        return this.mIndicator;
    }

    public boolean isEnablePivotScroll() {
        return this.mEnablePivotScroll;
    }

    public void setEnablePivotScroll(boolean is) {
        this.mEnablePivotScroll = is;
    }

    @Override
    public void onEnter(int index, int totalCount, float enterPercent, boolean leftToRight) {
        if (this.mTitleContainer == null) {
            return;
        }
        View v = this.mTitleContainer.getChildAt(index);
        if (v instanceof IPagerTitleView) {
            ((IPagerTitleView)v).onEnter(index, totalCount, enterPercent, leftToRight);
        }
    }

    @Override
    public void onLeave(int index, int totalCount, float leavePercent, boolean leftToRight) {
        if (this.mTitleContainer == null) {
            return;
        }
        View v = this.mTitleContainer.getChildAt(index);
        if (v instanceof IPagerTitleView) {
            ((IPagerTitleView)v).onLeave(index, totalCount, leavePercent, leftToRight);
        }
    }

    public boolean isSmoothScroll() {
        return this.mSmoothScroll;
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.mSmoothScroll = smoothScroll;
    }

    public boolean isFollowTouch() {
        return this.mFollowTouch;
    }

    public void setFollowTouch(boolean followTouch) {
        this.mFollowTouch = followTouch;
    }

    public boolean isSkimOver() {
        return this.mSkimOver;
    }

    public void setSkimOver(boolean skimOver) {
        this.mSkimOver = skimOver;
        this.mNavigatorHelper.setSkimOver(skimOver);
    }

    @Override
    public void onSelected(int index, int totalCount) {
        if (this.mTitleContainer == null) {
            return;
        }
        View v = this.mTitleContainer.getChildAt(index);
        if (v instanceof IPagerTitleView) {
            ((IPagerTitleView)v).onSelected(index, totalCount);
        }
        if (!this.mAdjustMode && !this.mFollowTouch && this.mScrollView != null && this.mPositionDataList.size() > 0) {
            int currentIndex = Math.min(this.mPositionDataList.size() - 1, index);
            PositionData current = this.mPositionDataList.get(currentIndex);
            if (this.mEnablePivotScroll) {
                float scrollTo = (float)current.horizontalCenter() - (float)this.mScrollView.getWidth() * this.mScrollPivotX;
                if (this.mSmoothScroll) {
                    this.mScrollView.smoothScrollTo((int)scrollTo, 0);
                } else {
                    this.mScrollView.scrollTo((int)scrollTo, 0);
                }
            } else if (this.mScrollView.getScrollX() > current.mLeft) {
                if (this.mSmoothScroll) {
                    this.mScrollView.smoothScrollTo(current.mLeft, 0);
                } else {
                    this.mScrollView.scrollTo(current.mLeft, 0);
                }
            } else if (this.mScrollView.getScrollX() + this.getWidth() < current.mRight) {
                if (this.mSmoothScroll) {
                    this.mScrollView.smoothScrollTo(current.mRight - this.getWidth(), 0);
                } else {
                    this.mScrollView.scrollTo(current.mRight - this.getWidth(), 0);
                }
            }
        }
    }

    @Override
    public void onDeselected(int index, int totalCount) {
        if (this.mTitleContainer == null) {
            return;
        }
        View v = this.mTitleContainer.getChildAt(index);
        if (v instanceof IPagerTitleView) {
            ((IPagerTitleView)v).onDeselected(index, totalCount);
        }
    }

    public IPagerTitleView getPagerTitleView(int index) {
        if (this.mTitleContainer == null) {
            return null;
        }
        return (IPagerTitleView)this.mTitleContainer.getChildAt(index);
    }

    public LinearLayout getTitleContainer() {
        return this.mTitleContainer;
    }

    public int getRightPadding() {
        return this.mRightPadding;
    }

    public void setRightPadding(int rightPadding) {
        this.mRightPadding = rightPadding;
    }

    public int getLeftPadding() {
        return this.mLeftPadding;
    }

    public void setLeftPadding(int leftPadding) {
        this.mLeftPadding = leftPadding;
    }

    public boolean isIndicatorOnTop() {
        return this.mIndicatorOnTop;
    }

    public void setIndicatorOnTop(boolean indicatorOnTop) {
        this.mIndicatorOnTop = indicatorOnTop;
    }

    public boolean isReselectWhenLayout() {
        return this.mReselectWhenLayout;
    }

    public void setReselectWhenLayout(boolean reselectWhenLayout) {
        this.mReselectWhenLayout = reselectWhenLayout;
    }
}

