/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.database.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.xdja.moments.sdk.database.dao.DownInfoDao;
import com.xdja.moments.sdk.database.domain.DownInfo;
import java.util.List;

public class DownInfoDao_Impl
implements DownInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfDownInfo;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfDownInfo;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfDownInfo;

    public DownInfoDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfDownInfo = new EntityInsertionAdapter<DownInfo>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `download_info`(`id`,`save_path`,`file_length`,`read_length`,`connection_time`,`state`,`url`,`update_progress`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, DownInfo value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
                if (value.getSavePath() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSavePath());
                }
                stmt.bindLong(3, value.getCountLength());
                stmt.bindLong(4, value.getReadLength());
                stmt.bindLong(5, (long)value.getConnectionTime());
                stmt.bindLong(6, (long)value.getStateInte());
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                int _tmp = value.isUpdateProgress() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
            }
        };
        this.__deletionAdapterOfDownInfo = new EntityDeletionOrUpdateAdapter<DownInfo>(__db){

            public String createQuery() {
                return "DELETE FROM `download_info` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DownInfo value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
            }
        };
        this.__updateAdapterOfDownInfo = new EntityDeletionOrUpdateAdapter<DownInfo>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `download_info` SET `id` = ?,`save_path` = ?,`file_length` = ?,`read_length` = ?,`connection_time` = ?,`state` = ?,`url` = ?,`update_progress` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DownInfo value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
                if (value.getSavePath() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSavePath());
                }
                stmt.bindLong(3, value.getCountLength());
                stmt.bindLong(4, value.getReadLength());
                stmt.bindLong(5, (long)value.getConnectionTime());
                stmt.bindLong(6, (long)value.getStateInte());
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                int _tmp = value.isUpdateProgress() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
                if (value.getFileId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getFileId());
                }
            }
        };
    }

    @Override
    public void insertItem(DownInfo item) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfDownInfo.insert((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertItems(List<DownInfo> items) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfDownInfo.insert(items);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteItem(DownInfo item) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfDownInfo.handle((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateItem(DownInfo item) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDownInfo.handle((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownInfo getDownInfo(String fileId) {
        String _sql = "SELECT * FROM download_info where id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM download_info where id = ?", (int)1);
        int _argIndex = 1;
        if (fileId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fileId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            DownInfo _result;
            int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfSavePath = _cursor.getColumnIndexOrThrow("save_path");
            int _cursorIndexOfCountLength = _cursor.getColumnIndexOrThrow("file_length");
            int _cursorIndexOfReadLength = _cursor.getColumnIndexOrThrow("read_length");
            int _cursorIndexOfConnectionTime = _cursor.getColumnIndexOrThrow("connection_time");
            int _cursorIndexOfStateInte = _cursor.getColumnIndexOrThrow("state");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("url");
            int _cursorIndexOfUpdateProgress = _cursor.getColumnIndexOrThrow("update_progress");
            if (_cursor.moveToFirst()) {
                _result = new DownInfo();
                String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                _result.setFileId(_tmpFileId);
                String _tmpSavePath = _cursor.getString(_cursorIndexOfSavePath);
                _result.setSavePath(_tmpSavePath);
                long _tmpCountLength = _cursor.getLong(_cursorIndexOfCountLength);
                _result.setCountLength(_tmpCountLength);
                long _tmpReadLength = _cursor.getLong(_cursorIndexOfReadLength);
                _result.setReadLength(_tmpReadLength);
                int _tmpConnectionTime = _cursor.getInt(_cursorIndexOfConnectionTime);
                _result.setConnectionTime(_tmpConnectionTime);
                int _tmpStateInte = _cursor.getInt(_cursorIndexOfStateInte);
                _result.setStateInte(_tmpStateInte);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                int _tmp = _cursor.getInt(_cursorIndexOfUpdateProgress);
                boolean _tmpUpdateProgress = _tmp != 0;
                _result.setUpdateProgress(_tmpUpdateProgress);
            } else {
                _result = null;
            }
            DownInfo downInfo = _result;
            return downInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

