/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.database.domain;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.moments.sdk.http.download.DownLoadListener.HttpDownOnNextListener;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownApi;

@Entity(tableName="download_info")
public class DownInfo {
    @NonNull
    @PrimaryKey
    @ColumnInfo(name="id")
    private String fileId;
    @ColumnInfo(name="save_path")
    private String savePath;
    @ColumnInfo(name="file_length")
    private long countLength;
    @ColumnInfo(name="read_length")
    private long readLength;
    @Ignore
    private HttpDownApi service;
    @Ignore
    private HttpDownOnNextListener listener;
    @ColumnInfo(name="connection_time")
    private int connectionTime = 10;
    @ColumnInfo(name="state")
    private int stateInte;
    @ColumnInfo(name="url")
    private String url;
    @ColumnInfo(name="update_progress")
    private boolean updateProgress;

    @Ignore
    public DownInfo(String url, HttpDownOnNextListener listener) {
        this.setUrl(url);
        this.setListener(listener);
    }

    @Ignore
    public DownInfo(String url) {
        this.setUrl(url);
    }

    @Ignore
    public DownInfo(String fileId, String savePath, long countLength, long readLength, int connectionTime, int stateInte, String url) {
        this.fileId = fileId;
        this.savePath = savePath;
        this.countLength = countLength;
        this.readLength = readLength;
        this.connectionTime = connectionTime;
        this.stateInte = stateInte;
        this.url = url;
    }

    public DownInfo() {
        this.readLength = 0L;
        this.countLength = 0L;
        this.stateInte = DownState.START.getState();
    }

    public DownInfo(String id, String savePath, long countLength, long readLength, int connectionTime, int stateInte, String url, boolean updateProgress) {
        this.fileId = this.fileId;
        this.savePath = savePath;
        this.countLength = countLength;
        this.readLength = readLength;
        this.connectionTime = connectionTime;
        this.stateInte = stateInte;
        this.url = url;
        this.updateProgress = updateProgress;
    }

    public DownState getState() {
        switch (this.getStateInte()) {
            case 0: {
                return DownState.START;
            }
            case 1: {
                return DownState.DOWN;
            }
            case 2: {
                return DownState.PAUSE;
            }
            case 3: {
                return DownState.STOP;
            }
            case 4: {
                return DownState.ERROR;
            }
        }
        return DownState.FINISH;
    }

    public void setState(DownState state) {
        this.setStateInte(state.getState());
    }

    public int getStateInte() {
        return this.stateInte;
    }

    public void setStateInte(int stateInte) {
        this.stateInte = stateInte;
    }

    public HttpDownOnNextListener getListener() {
        return this.listener;
    }

    public void setListener(HttpDownOnNextListener listener) {
        this.listener = listener;
    }

    public HttpDownApi getService() {
        return this.service;
    }

    public void setService(HttpDownApi service) {
        this.service = service;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSavePath() {
        return TextUtils.isEmpty((CharSequence)this.savePath) ? MomentsConstants.PICTURE_FOLDER : this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public long getCountLength() {
        return this.countLength;
    }

    public void setCountLength(long countLength) {
        this.countLength = countLength;
    }

    public long getReadLength() {
        return this.readLength;
    }

    public void setReadLength(long readLength) {
        this.readLength = readLength;
    }

    public int getConnectionTime() {
        return this.connectionTime;
    }

    public void setConnectionTime(int connectionTime) {
        this.connectionTime = connectionTime;
    }

    @NonNull
    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(@NonNull String fileId) {
        this.fileId = fileId;
    }

    public boolean isUpdateProgress() {
        return this.updateProgress;
    }

    public void setUpdateProgress(boolean updateProgress) {
        this.updateProgress = updateProgress;
    }
}

