/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.Group;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseFragment;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.util.GlideCircleTransform;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.NewCommentsNotification;
import com.xdja.moments.sdk.flow.base.adapter.MomentsPagerAdapter;
import com.xdja.moments.sdk.flow.init.mvp.MomentsInitConstruct;
import com.xdja.moments.sdk.flow.init.mvp.MomentsInitPresenter;
import com.xdja.moments.sdk.flow.main.ColumnFragment;
import com.xdja.moments.sdk.http.bean.request.LoginParams;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModel;
import com.xdja.moments.sdk.viewmodel.NewCommentsViewModel;
import com.xdja.moments.sdk.viewmodel.NewMomentsViewModel;
import com.xdja.moments.sdk.widget.tablayout.MomentsTabLayout;
import io.reactivex.ObservableTransformer;
import io.reactivex.disposables.CompositeDisposable;
import java.util.ArrayList;
import java.util.List;

public class MomentsFragment
extends BaseFragment
implements MomentsInitConstruct.View,
View.OnClickListener {
    private static final int PAGE_OFFSET_SIZE = 5;
    private MomentsTabLayout mTabLayout;
    private ViewPager mViewPager;
    private ConstraintLayout mContentLayout;
    private ImageView mPersonImage;
    private TextView mUnreadText;
    private Group mUnReadGroup;
    private List<String> mTitleList = new ArrayList<String>();
    private List<Fragment> mFragmentList = new ArrayList<Fragment>();
    private List<MomentsClassify> mClassifyList = new ArrayList<MomentsClassify>();
    private MomentsInitPresenter presenter;
    private NewCommentsViewModel newCommentsViewModel;
    private MomentsClassifyViewModel classifyViewModel;
    private List<NewCommentsNotification> newCommentsNotificationList;
    private NewMomentsViewModel newMomentsViewModel;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private MomentsPagerAdapter momentsPagerAdapter;

    protected int getRootView() {
        return R.layout.moments_main_fragment;
    }

    protected ViewGroup getErrorParentView() {
        return this.mContentLayout;
    }

    protected LoadingType getLoadingType() {
        return LoadingType.LOAD_TYPE_COVER;
    }

    protected void initView(View rootView, LayoutInflater inflater) {
        this.mContentLayout = (ConstraintLayout)rootView.findViewById(R.id.contentLayout);
        this.mTabLayout = (MomentsTabLayout)rootView.findViewById(R.id.moments_tabLayout);
        this.mViewPager = (ViewPager)rootView.findViewById(R.id.moments_viewPager);
        this.mUnreadText = (TextView)rootView.findViewById(R.id.tv_new_comments);
        this.mPersonImage = (ImageView)rootView.findViewById(R.id.iv_person);
        this.mUnReadGroup = (Group)rootView.findViewById(R.id.new_comment_group);
        this.mUnreadText.setOnClickListener((View.OnClickListener)this);
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.presenter == null) {
            this.presenter = new MomentsInitPresenter(provider, this);
        }
        LoginParams loginParams = MomentsManager.getInstance().getLoginParams();
        this.presenter.init(loginParams);
    }

    private void setPageOffset(List<Fragment> fragmentList) {
        int size = fragmentList.size();
        if (size < 5) {
            this.mViewPager.setOffscreenPageLimit(size);
        } else {
            this.mViewPager.setOffscreenPageLimit(5);
        }
    }

    private void initViewPager() {
        this.mTabLayout.setTabMode(0);
        if (this.momentsPagerAdapter == null) {
            this.momentsPagerAdapter = new MomentsPagerAdapter(this.mFragmentList, this.mTitleList, this.getChildFragmentManager());
            this.mViewPager.setAdapter((PagerAdapter)this.momentsPagerAdapter);
        }
        this.momentsPagerAdapter.updateData(this.mFragmentList, this.mTitleList);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int position) {
                MomentsClassify momentsClassify;
                if (MomentsFragment.this.newMomentsViewModel != null && MomentsFragment.this.mClassifyList.size() > 0 && (momentsClassify = (MomentsClassify)MomentsFragment.this.mClassifyList.get(position)) != null) {
                    MomentsFragment.this.newMomentsViewModel.clearUnReadNumber(momentsClassify.getClassifyId());
                    MomentsFragment.this.mTabLayout.removeBadge(position);
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
        this.mTabLayout.setupWithViewPager(this.mViewPager);
        this.setPageOffset(this.mFragmentList);
    }

    @Override
    public void onInitFinish(List<MomentsClassify> classifyList) {
        this.initMomentClassifyViewModel();
    }

    private void initNewCommentsViewModel() {
        this.newCommentsViewModel.getNewComments().observe((LifecycleOwner)this, newCommentsNotificationList -> {
            if (newCommentsNotificationList != null && newCommentsNotificationList.size() > 0) {
                this.newCommentsNotificationList = newCommentsNotificationList;
                this.mUnReadGroup.setVisibility(0);
                this.mUnreadText.setText((CharSequence)String.format(this.getString(R.string.moments__unread_comment), newCommentsNotificationList.size()));
                this.setLastCommentHeadImage((List<NewCommentsNotification>)newCommentsNotificationList);
            } else {
                this.mUnReadGroup.setVisibility(8);
            }
        });
    }

    private void initMomentClassifyViewModel() {
        this.classifyViewModel = (MomentsClassifyViewModel)ViewModelProviders.of((Fragment)this).get(MomentsClassifyViewModel.class);
        if (this.newCommentsViewModel == null) {
            this.newCommentsViewModel = (NewCommentsViewModel)ViewModelProviders.of((Fragment)this).get(NewCommentsViewModel.class);
        }
        if (this.newMomentsViewModel == null) {
            this.newMomentsViewModel = (NewMomentsViewModel)ViewModelProviders.of((Fragment)this).get(NewMomentsViewModel.class);
        }
        this.initNewCommentsViewModel();
        this.classifyViewModel.getAllMomentsClassIfy().observe((LifecycleOwner)this, (Observer)new Observer<List<MomentsClassify>>(){

            public void onChanged(@Nullable List<MomentsClassify> momentsClassifies) {
                if (momentsClassifies == null) {
                    MomentsFragment.this.showEmptyLayout("\u6ca1\u6709\u4efb\u4f55\u5206\u7c7b\u54e6");
                    return;
                }
                MomentsFragment.this.mClassifyList.clear();
                MomentsFragment.this.mTitleList.clear();
                for (Fragment fragment : MomentsFragment.this.mFragmentList) {
                    fragment.onDestroy();
                }
                MomentsFragment.this.mFragmentList.clear();
                MomentsFragment.this.mClassifyList.addAll(momentsClassifies);
                if (momentsClassifies.size() == 1) {
                    MomentsFragment.this.mViewPager.setVisibility(8);
                    MomentsFragment.this.mTabLayout.setVisibility(8);
                    FragmentTransaction fragmentTransaction = MomentsFragment.this.getChildFragmentManager().beginTransaction();
                    fragmentTransaction.replace(R.id.fragment_layout, ColumnFragment.newInstance(momentsClassifies.get(0).getClassifyId()));
                    fragmentTransaction.commit();
                    return;
                }
                for (MomentsClassify momentsClassify : momentsClassifies) {
                    MomentsFragment.this.mTitleList.add(momentsClassify.getClassifyName());
                    MomentsFragment.this.mFragmentList.add(ColumnFragment.newInstance(momentsClassify.getClassifyId()));
                }
                if (momentsClassifies.size() > 1) {
                    MomentsFragment.this.initViewPager();
                }
            }
        });
    }

    private void setLastCommentHeadImage(List<NewCommentsNotification> newCommentsNotificationList) {
        String momentsUserId = newCommentsNotificationList.get(0).getCommentUserId();
        this.disposables.add(MomentsDataManager.getInstance().queryObservableUserInfo(momentsUserId).compose((ObservableTransformer)this.provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(userInfoBean -> {
            if (userInfoBean != null) {
                Glide.with((Fragment)this).load(userInfoBean.getUserAvatar()).transform(new BitmapTransformation[]{new GlideCircleTransform((Context)this.getActivity())}).error(R.drawable.moments_person_default).placeholder(R.drawable.moments_person_default).diskCacheStrategy(DiskCacheStrategy.ALL).into(this.mPersonImage);
            }
        }));
    }

    public void onClick(View view) {
        if (view.getId() == R.id.tv_new_comments) {
            long createTime = this.newCommentsNotificationList.get(this.newCommentsNotificationList.size() - 1).getCreateTime();
            Navigation.navigationNewComments(createTime, this.newCommentsNotificationList.size());
            this.newCommentsViewModel.clearUnReadComments();
        }
    }

    public void showPageDot(String classifyId) {
        for (int position = 0; position < this.mClassifyList.size(); ++position) {
            if (!classifyId.equals(this.mClassifyList.get(position).getClassifyId())) continue;
            this.mTabLayout.setTabBadgeNew(position);
        }
    }

    public boolean getIsSelect(String classifyId) {
        if (this.mViewPager == null) {
            return false;
        }
        return classifyId.equals(this.mClassifyList.get(this.mViewPager.getCurrentItem()).getClassifyId());
    }

    public void onDestroy() {
        super.onDestroy();
        this.disposables.dispose();
    }
}

