/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.base.adapter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.ClipboardManager;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import android.widget.Toast;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.XViewHolder;
import com.xdja.baselibrary.widget.SmoothCheckBox;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.FileBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.bean.VideoBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import com.xdja.moments.sdk.widget.CommentListView;
import com.xdja.moments.sdk.widget.ExpandableTextView;
import com.xdja.moments.sdk.widget.MomentsSpanTextView;
import com.xdja.moments.sdk.widget.PictureGridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MomentsListAdapter
extends XRecyclerViewAdapter<MomentsBean> {
    private MomentsConfig momentsConfig;
    private List<MomentsClassify> momentsClassifyList;
    private FaceManager faceManager;
    private Context context;
    private boolean longClick;
    private final SparseBooleanArray mCollapsedStatus;
    private Activity activity;
    private ClipboardManager clipboard;
    private boolean multiSelectEnable = false;
    private Boolean isReview = false;
    private List<String> checkedMoments = new ArrayList<String>();
    private OnMoreArrowClickListener onMoreArrowClickListener;
    private OnCheckNumberChangedClickListener onCheckNumberChangedClickListener;
    private OnPraiseClickListener onPraiseClickListener;
    private OnCommentIconClickListener onCommentIconClickListener;
    private OnDeleteCommentListener onDeleteCommentListener;
    private String loginUserId;

    public MomentsListAdapter(@NonNull RecyclerView mRecyclerView, List<MomentsBean> dataLists, Activity activity) {
        super(mRecyclerView, dataLists);
        this.activity = activity;
        this.mCollapsedStatus = new SparseBooleanArray();
        this.faceManager = FaceManager.getInstance();
        this.context = MomentsManager.getInstance().getContext();
        this.clipboard = (ClipboardManager)this.context.getSystemService("clipboard");
        this.loginUserId = MomentsManager.getInstance().getLoginer().getUserId();
    }

    protected void bindData(XViewHolder holder, final MomentsBean data, int position) {
        this.initHeader(holder, data, position);
        holder.setOnClickListener(R.id.content, v -> this.enterToDetail(data, null));
        switch (data.getMomentType()) {
            case 1: {
                break;
            }
            case 2: {
                PictureGridLayout pictureGridLayout = (PictureGridLayout)holder.getView(R.id.pictureGridLayout);
                List<ImageBean> imageBeans = data.getImageBeans();
                if (imageBeans == null || imageBeans.size() == 0) {
                    pictureGridLayout.setVisibility(8);
                    break;
                }
                pictureGridLayout.setPictures((Context)this.activity, imageBeans);
                break;
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)data.getMomentFilePath()) && data.getImageBeans() != null && data.getImageBeans().size() > 0) {
                    final ImageBean videoPrevBean = data.getImageBeans().get(0);
                    holder.setVisible(R.id.file_group, true);
                    MomentImageUtil.resetLayoutParams(holder.getView(R.id.iv_video_preview), videoPrevBean);
                    holder.setImageUrl(this.context, R.id.iv_video_preview, MomentImageUtil.getThumbnail(videoPrevBean.getPath(), videoPrevBean.getWidth(), videoPrevBean.getHeight()), R.drawable.moments_img_pic_default, true);
                    holder.setOnClickListener(R.id.iv_video_preview, new View.OnClickListener(){

                        public void onClick(View view) {
                            Integer integer;
                            String momentVideoTime = data.getMomentVideoTime();
                            try {
                                integer = Integer.valueOf(momentVideoTime);
                            }
                            catch (Exception e) {
                                integer = 0;
                            }
                            VideoBean videoBean = new VideoBean();
                            videoBean.setVideoDuration(integer);
                            videoBean.setVideoFileId(data.getMomentFilePath());
                            videoBean.setVideoPrevPath(videoPrevBean.getPath());
                            Navigation.navigationVideoDetailActivity(videoBean);
                        }
                    });
                    break;
                }
                holder.setVisible(R.id.file_group, false);
                break;
            }
            case 4: {
                if (TextUtils.isEmpty((CharSequence)data.getMomentFileName()) || TextUtils.isEmpty((CharSequence)data.getMomentFilePath()) || data.getMomentFileSize() == 0L) {
                    holder.setVisible(R.id.ly_accessory, false);
                    break;
                }
                holder.setVisible(R.id.ly_accessory, true);
                holder.setText(R.id.tv_file_name, (CharSequence)data.getMomentFileName());
                holder.setImageResource(R.id.img_file_icon, FileUtil.getFileDrawable(data.getMomentFileType()));
                holder.setOnClickListener(R.id.ly_accessory, new View.OnClickListener(){

                    public void onClick(View view) {
                        FileBean fileBean = new FileBean();
                        fileBean.setDownLoadUrl(data.getMomentFilePath());
                        fileBean.setFileExt(data.getMomentFileType());
                        fileBean.setFileName(data.getMomentFileName());
                        fileBean.setFileSize(data.getMomentFileSize());
                        Navigation.navigationFileDetail(fileBean);
                    }
                });
                break;
            }
            case 5: {
                if (TextUtils.isEmpty((CharSequence)data.getMomentShareUrl()) || TextUtils.isEmpty((CharSequence)data.getMomentShareContent())) {
                    holder.setVisible(R.id.ly_accessory, false);
                    break;
                }
                holder.setVisible(R.id.ly_accessory, true);
                holder.setImageUrl(this.context, R.id.img_link, data.getMomentShareUrl(), R.drawable.moments_img_pic_default, true);
                holder.setText(R.id.tv_link_name, (CharSequence)data.getMomentShareContent());
                holder.setOnClickListener(R.id.ly_accessory, new View.OnClickListener(){

                    public void onClick(View view) {
                        Navigation.navigationUrlDetailActivity(MomentsListAdapter.this.activity, data.getMomentShareContent(), data.getMomentShareUrl());
                    }
                });
                break;
            }
        }
        this.initFooter(holder, data);
        holder.itemView.setOnClickListener(view -> this.enterToDetail(data, null));
    }

    private void initHeader(XViewHolder holder, MomentsBean data, int position) {
        View.OnClickListener onMoreClickListener = view -> {
            if (this.onMoreArrowClickListener != null) {
                this.onMoreArrowClickListener.onMoreArrowClick(data);
            }
        };
        View.OnClickListener onUserClickListener = view -> Navigation.navigationPersonDetail((Context)this.activity, data.getUserInfo().getUserId());
        SmoothCheckBox.OnCheckedChangeListener onCheckedChangeListener = (checkBox, isChecked) -> {
            if (isChecked) {
                if (!this.checkedMoments.contains(data.getMomentId())) {
                    this.checkedMoments.add(data.getMomentId());
                }
            } else if (this.checkedMoments.contains(data.getMomentId())) {
                this.checkedMoments.remove(data.getMomentId());
            }
            if (this.onCheckNumberChangedClickListener != null) {
                this.onCheckNumberChangedClickListener.OnCheckNumberChanged(this.checkedMoments.size());
            }
        };
        if (3 == data.getMomentVerifyStatus()) {
            holder.setVisible(R.id.tv_reView_fail_reason, true);
            holder.setText(R.id.tv_reView_fail_reason, (CharSequence)String.format("\u5ba1\u6838\u4e0d\u901a\u8fc7\uff1a%s", data.getMomentVerifyContent()));
        } else {
            holder.setVisible(R.id.tv_reView_fail_reason, false);
        }
        UserInfoBean userInfo = data.getUserInfo();
        holder.setImageUrl(this.context, R.id.iv_head_image, userInfo.getUserAvatar(), R.drawable.moments_person_default, true, true);
        holder.setVisible(R.id.iv_auxpolice_mark, userInfo.isAuxPolice());
        holder.setVisible(R.id.iv_top, Integer.valueOf("1").intValue() == data.getRecommendFlag());
        holder.setText(R.id.tv_topic_user_name, (CharSequence)(TextUtils.isEmpty((CharSequence)userInfo.getUserName()) ? "\u672a\u77e5\u7528\u6237" : userInfo.getUserName()));
        holder.setText(R.id.tv_topic_time, (CharSequence)data.getTimeString());
        holder.setText(R.id.tv_from, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getShareSource()) ? "\u6765\u81ea" + userInfo.getDeptName() : "\u6765\u81ea" + data.getShareSource()));
        holder.setOnClickListener(R.id.tv_topic_user_name, onUserClickListener);
        holder.setOnClickListener(R.id.iv_moment_more, onMoreClickListener);
        holder.setOnClickListener(R.id.iv_head_image, onUserClickListener);
        holder.setVisible(R.id.cb_review_select, this.multiSelectEnable);
        if (!this.multiSelectEnable) {
            if (this.isReview.booleanValue() || "on".equals(this.momentsConfig.getSwitchForwardMoment())) {
                holder.setVisible(R.id.iv_moment_more, true);
            } else if (data.getUserInfo().getUserId().equals(MomentsManager.getInstance().getLoginer().getUserId())) {
                holder.setVisible(R.id.iv_moment_more, true);
            } else if ("on".equals(this.momentsConfig.getSwitchHideMoment())) {
                holder.setVisible(R.id.iv_moment_more, true);
            } else {
                holder.setVisible(R.id.iv_moment_more, false);
            }
        } else {
            holder.setVisible(R.id.iv_moment_more, false);
        }
        SmoothCheckBox smoothCheckBox = (SmoothCheckBox)holder.getView(R.id.cb_review_select);
        smoothCheckBox.setOnCheckedChangeListener(onCheckedChangeListener);
        holder.setChecked(R.id.cb_review_select, this.checkedMoments.contains(data.getMomentId()));
        this.setContentText(holder, data, position);
    }

    private void initFooter(XViewHolder holder, MomentsBean data) {
        boolean[] isAnimation = new boolean[]{false};
        View.OnClickListener onLocationClickListener = view -> Navigation.navigationLocationDetailActivity(this.activity, data.getAddress(), data.getAddressDetail(), Double.parseDouble(data.getLongitude()), Double.parseDouble(data.getLatitude()));
        MomentsSpanTextView.MemberClickListener memberClickListener = commentBean -> Navigation.navigationPersonDetail((Context)this.activity, commentBean.getUserId());
        CommentListView.OnItemClickListener onCommentClickListener = commentBean -> {
            if (this.multiSelectEnable) {
                return;
            }
            if ("2".equals(this.momentsConfig.getSwitchShowCommentWay())) {
                this.enterToDetail(data, commentBean);
            } else if (this.onCommentIconClickListener != null) {
                this.onCommentIconClickListener.onCommentItemClick(data.getMomentId(), commentBean);
            }
        };
        CommentListView.OnItemLongClickListener onCommentLongClickListener = commentBean -> this.showCommentLongPressDialog(data, commentBean);
        View.OnClickListener onReleaseCommentClickListener = view -> {
            if (this.multiSelectEnable) {
                return;
            }
            if (this.onCommentIconClickListener != null) {
                if ("2".equals(this.momentsConfig.getSwitchShowCommentWay())) {
                    this.enterToDetail(data, null);
                } else {
                    this.onCommentIconClickListener.onCommentIconClick(data);
                }
            }
        };
        Animation animation = this.getAnimation(isAnimation, data);
        View.OnClickListener onPraiseClickListener = view -> {
            if (!isAnimation[0]) {
                holder.getView(R.id.tv_praise).startAnimation(animation);
            }
        };
        if (TextUtils.isEmpty((CharSequence)data.getAddress()) || TextUtils.isEmpty((CharSequence)data.getLatitude()) || TextUtils.isEmpty((CharSequence)data.getLongitude())) {
            holder.setVisible(R.id.tv_location, false);
        } else {
            holder.setVisible(R.id.tv_location, true);
            holder.setText(R.id.tv_location, (CharSequence)data.getAddress());
            holder.setOnClickListener(R.id.tv_location, onLocationClickListener);
        }
        if (data.getAtInfoList() == null || data.getAtInfoList().size() == 0) {
            holder.setVisible(R.id.at_group, false);
        } else {
            holder.setVisible(R.id.at_group, true);
            MomentsSpanTextView momentsSpanTextView = (MomentsSpanTextView)holder.getView(R.id.atListView);
            momentsSpanTextView.setUserList(data.getAtInfoList(), memberClickListener);
        }
        holder.setText(R.id.tv_praise, (CharSequence)String.valueOf(data.getPraiseCount()));
        holder.setTextColor(R.id.tv_praise, "1".equals(data.getPraiseFlag()) ? this.context.getResources().getColor(R.color.moments_praise_color) : this.context.getResources().getColor(R.color.moments_text_gray));
        Drawable drawable2 = this.context.getResources().getDrawable("1".equals(data.getPraiseFlag()) ? R.drawable.moments_item_praise : R.drawable.moments_item_unpraise);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        holder.setCompoundDrawables(R.id.tv_praise, null, null, null, drawable2);
        holder.setOnClickListener(R.id.tv_praise, onPraiseClickListener);
        List<UserInfoBean> praiseList = data.getPraiseList();
        if ("on".equals(this.momentsConfig.getSwitchHomeShowPraise()) && praiseList != null && praiseList.size() > 0) {
            MomentsSpanTextView praiseListView = (MomentsSpanTextView)holder.getView(R.id.praiseListView);
            praiseListView.setBasePraiseText(praiseList, data.getPraiseCount(), "2".equals(this.momentsConfig.getSwitchShowPraiseWay()), memberClickListener);
            holder.setVisible(R.id.praiseListView, true);
        } else {
            holder.setVisible(R.id.praiseListView, false);
        }
        List<CommentBean> commentList = data.getCommentList();
        if ("on".equals(this.momentsConfig.getSwitchHomeShowComment()) && commentList != null && commentList.size() > 0) {
            holder.setVisible(R.id.commentListView, true);
            CommentListView commentListView = (CommentListView)holder.getView(R.id.commentListView);
            commentListView.setDatas(commentList, this.momentsConfig.getSwitchShowCommentWay().equals("2"));
            commentListView.setOnItemClickListener(onCommentClickListener);
            commentListView.setOnItemLongClickListener(onCommentLongClickListener);
        } else {
            holder.setVisible(R.id.commentListView, false);
        }
        holder.setText(R.id.tv_comment, (CharSequence)String.valueOf(data.getCommentCount()));
        holder.setOnClickListener(R.id.tv_comment, onReleaseCommentClickListener);
        holder.setVisible(R.id.comment_layout, true);
        if (2 == data.getMomentVerifyStatus()) {
            if (data.getPraiseCount() <= 0 && data.getCommentCount() <= 0) {
                holder.setVisible(R.id.comment_layout, false);
            }
            if ("off".equals(this.momentsConfig.getSwitchHomeShowPraise()) && "off".equals(this.momentsConfig.getSwitchHomeShowComment())) {
                holder.setVisible(R.id.comment_layout, false);
            }
            if (this.hasPraisePower(data.getClassifyId())) {
                holder.setVisible(R.id.tv_praise, true);
            } else {
                holder.setVisible(R.id.tv_praise, false);
            }
            if (this.hasCommentPower(data.getClassifyId())) {
                holder.setVisible(R.id.tv_comment, true);
            } else {
                holder.setVisible(R.id.tv_comment, false);
            }
            if ("on".equals(this.momentsConfig.getSwitchHomeShowPraise()) && "on".equals(this.momentsConfig.getSwitchHomeShowComment()) && commentList != null && commentList.size() > 0 && praiseList != null && praiseList.size() > 0) {
                holder.setVisible(R.id.praise_split_line, true);
            } else {
                holder.setVisible(R.id.praise_split_line, false);
            }
        } else {
            holder.setVisible(R.id.comment_layout, false);
            holder.setVisible(R.id.tv_comment, false);
            holder.setVisible(R.id.tv_praise, false);
        }
    }

    @NonNull
    private Animation getAnimation(final boolean[] isAnimation, final MomentsBean data) {
        Animation animation = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.moments_praise_scale);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation arg0) {
                isAnimation[0] = true;
                if (MomentsListAdapter.this.onPraiseClickListener != null) {
                    MomentsListAdapter.this.onPraiseClickListener.onPraiseClick(data);
                }
            }

            public void onAnimationRepeat(Animation arg0) {
            }

            public void onAnimationEnd(Animation arg0) {
                isAnimation[0] = false;
            }
        });
        return animation;
    }

    public int getItemLayoutResId(MomentsBean data, int position) {
        switch (data.getMomentType()) {
            case 1: {
                return R.layout.moments_item_text;
            }
            case 2: {
                return R.layout.moments_item_image;
            }
            case 3: {
                return R.layout.moments_item_video;
            }
            case 4: {
                return R.layout.moments_item_file;
            }
            case 5: {
                return R.layout.moments_item_link;
            }
        }
        return R.layout.moments_item_text;
    }

    private void setContentText(XViewHolder holder, final MomentsBean data, int position) {
        final ExpandableTextView expandableTextView = (ExpandableTextView)holder.getView(R.id.expand_text_view);
        if (TextUtils.isEmpty((CharSequence)data.getMomentContent())) {
            expandableTextView.setVisibility(8);
            return;
        }
        expandableTextView.setVisibility(0);
        expandableTextView.setText(this.faceManager.convertNormalStringToSpannableString(this.context, data.getMomentContent()), TextView.BufferType.SPANNABLE, this.mCollapsedStatus, position);
        SpannableString spannableString = (SpannableString)expandableTextView.getText();
        if (spannableString != null) {
            Pattern mentionsPattern = Pattern.compile("((http|https|rtsp)://)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|([A-Za-z0-9-_]+\\.)+([A-Za-z]{2,6}))(:[0-9]{1,5})?((/[\\S&&[^,;\\s]]+)+)?");
            Matcher matcher = mentionsPattern.matcher((CharSequence)spannableString);
            while (matcher.find()) {
                MyUrlSpan myUrlSpan = new MyUrlSpan(matcher.group());
                spannableString.setSpan((Object)myUrlSpan, matcher.start(), matcher.end(), 33);
            }
        }
        expandableTextView.setAutoLinkMask(0);
        expandableTextView.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE, this.mCollapsedStatus, position);
        expandableTextView.setMovementMethod(LinkMovementMethod.getInstance());
        expandableTextView.setOnLongClickListener(arg0 -> {
            this.longClick = true;
            return true;
        });
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                MomentsListAdapter.this.longClick = true;
                final CharSequence text = expandableTextView.getText();
                if (text == null) {
                    Toast.makeText((Context)MomentsListAdapter.this.context, (CharSequence)"\u6ca1\u6709\u5185\u5bb9\u53ef\u4ee5\u590d\u5236", (int)0).show();
                } else {
                    final AlertDialog dlg = new AlertDialog.Builder((Context)MomentsListAdapter.this.activity).create();
                    dlg.show();
                    Window window = dlg.getWindow();
                    window.setContentView(R.layout.moments_alertdialog_copy);
                    TextView save2Disk = (TextView)window.findViewById(R.id.tv_copy);
                    save2Disk.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            dlg.dismiss();
                            Toast.makeText((Context)MomentsListAdapter.this.activity, (CharSequence)"\u5df2\u590d\u5236", (int)0).show();
                            MomentsListAdapter.this.clipboard.setText(text);
                        }
                    });
                }
                return true;
            }
        };
        View.OnClickListener enterDetailClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                MomentsListAdapter.this.enterToDetail(data, null);
            }
        };
        expandableTextView.setContentOnClickListener(enterDetailClickListener);
        expandableTextView.setOnClickListener(enterDetailClickListener);
        expandableTextView.setContentOnLongClickListener(onLongClickListener);
        holder.setOnClickListener(R.id.tv_moments_content, enterDetailClickListener);
    }

    private boolean hasPraisePower(String classifyId) {
        MomentsClassify myMomentsClassify = this.getClassIfyById(classifyId);
        if (myMomentsClassify == null) {
            return false;
        }
        return "1".equals(myMomentsClassify.getPraiseMomentPower());
    }

    private boolean hasReadPower(String classifyId) {
        MomentsClassify myMomentsClassify = this.getClassIfyById(classifyId);
        if (myMomentsClassify == null) {
            return false;
        }
        return "1".equals(myMomentsClassify.getLookMomentPower());
    }

    private boolean hasCommentPower(String classifyId) {
        MomentsClassify myMomentsClassify = this.getClassIfyById(classifyId);
        if (myMomentsClassify == null) {
            return false;
        }
        return "1".equals(myMomentsClassify.getCommentMomentPower());
    }

    private MomentsClassify getClassIfyById(String classifyId) {
        if (this.momentsClassifyList == null) {
            return null;
        }
        for (MomentsClassify classify : this.momentsClassifyList) {
            if (!classify.getClassifyId().equals(classifyId)) continue;
            return classify;
        }
        return null;
    }

    private void enterToDetail(MomentsBean data, CommentBean commentBean) {
        if (this.hasReadPower(data.getClassifyId()) && "2".equals(this.momentsConfig.getSwitchShowCommentWay())) {
            if (null != commentBean) {
                Navigation.navigationMomentDetail(data.getMomentId(), commentBean.getCommentId());
            } else {
                Navigation.navigationMomentDetail(data.getMomentId());
            }
        } else {
            Logger.d((Object)("\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u5de5\u4f5c\u5708\uff0c\u680f\u76ee\u6743\u9650:" + this.hasPraisePower(data.getClassifyId()) + ",\u5ba1\u6838\u72b6\u6001\uff1a" + data.getMomentVerifyStatus() + "\u8bc4\u8bba\u5c55\u793a\u65b9\u5f0f\uff1a" + this.momentsConfig.getSwitchShowCommentWay()));
        }
    }

    private void showCommentLongPressDialog(final MomentsBean momentsBean, final CommentBean commentBean) {
        final AlertDialog dlg = new AlertDialog.Builder((Context)this.activity).create();
        dlg.show();
        Window window = dlg.getWindow();
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.moments_alertdialog_comment);
        TextView save2Disk = (TextView)window.findViewById(R.id.tv_copy);
        save2Disk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dlg.dismiss();
                MomentsListAdapter.this.clipboard.setText((CharSequence)("" + commentBean.getCommentContent()));
                Toast.makeText((Context)MomentsListAdapter.this.context, (CharSequence)"\u5df2\u590d\u5236", (int)0).show();
            }
        });
        TextView deleteComment = (TextView)window.findViewById(R.id.tv_delete);
        deleteComment.setVisibility(this.loginUserId.equals(commentBean.getUserInfo().getUserId()) ? 0 : 8);
        deleteComment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dlg.dismiss();
                if (MomentsListAdapter.this.onDeleteCommentListener != null) {
                    MomentsListAdapter.this.onDeleteCommentListener.onClickDeleteComment(momentsBean, commentBean);
                }
            }
        });
    }

    public void onMomentsClassifyChanged(List<MomentsClassify> momentsClassify) {
        this.momentsClassifyList = momentsClassify;
        this.notifyDataSetChanged();
    }

    public void onMomentsConfigChanged(MomentsConfig momentsConfig) {
        this.momentsConfig = momentsConfig;
        this.notifyDataSetChanged();
    }

    public void setMultiSelectEnable(Boolean multiSelectEnable) {
        this.multiSelectEnable = multiSelectEnable;
        this.notifyDataSetChanged();
    }

    public List<String> getCheckedMoments() {
        return this.checkedMoments;
    }

    public void clearCheckedMoments() {
        this.checkedMoments.clear();
    }

    public void setOnMoreArrowClickListener(OnMoreArrowClickListener listener) {
        this.onMoreArrowClickListener = listener;
    }

    public void setOnCheckNumberChangedListener(OnCheckNumberChangedClickListener listener) {
        this.onCheckNumberChangedClickListener = listener;
    }

    public void setIsReview(Boolean isReview) {
        this.isReview = isReview;
    }

    public void setOnPraiseClickListener(OnPraiseClickListener listener) {
        this.onPraiseClickListener = listener;
    }

    public void setOnCommentClickListener(OnCommentIconClickListener listener) {
        this.onCommentIconClickListener = listener;
    }

    public void setOnDeleteCommentListener(OnDeleteCommentListener listener) {
        this.onDeleteCommentListener = listener;
    }

    public static interface OnDeleteCommentListener {
        public void onClickDeleteComment(MomentsBean var1, CommentBean var2);
    }

    public static interface OnCommentIconClickListener {
        public void onCommentIconClick(MomentsBean var1);

        public void onCommentItemClick(String var1, CommentBean var2);
    }

    public static interface OnPraiseClickListener {
        public void onPraiseClick(MomentsBean var1);
    }

    public static interface OnCheckNumberChangedClickListener {
        public void OnCheckNumberChanged(int var1);
    }

    public static interface OnMoreArrowClickListener {
        public void onMoreArrowClick(MomentsBean var1);
    }

    private class MyUrlSpan
    extends ClickableSpan {
        private String mUrl;

        MyUrlSpan(String url) {
            this.mUrl = url;
        }

        public void updateDrawState(TextPaint ds) {
            super.updateDrawState(ds);
            ds.setColor(-16743733);
            ds.setUnderlineText(false);
        }

        public void onClick(View widget) {
            if (MomentsListAdapter.this.longClick) {
                MomentsListAdapter.this.longClick = false;
                return;
            }
            Navigation.navigationUrlDetailActivity(MomentsListAdapter.this.activity, "\u8be6\u60c5", this.mUrl);
            widget.clearFocus();
        }
    }
}

