/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.base.business.impl;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BasePageResponse;
import com.xdja.baselibrary.base.BaseParams;
import com.xdja.baselibrary.base.BaseResult;
import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.PraiseBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.flow.base.business.BaseMomentBusiness;
import com.xdja.moments.sdk.http.bean.response.CommentResponseBean;
import com.xdja.moments.sdk.http.bean.response.MomentsResponseBean;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BaseMomentBusinessImpl
implements BaseMomentBusiness {
    protected LifecycleProvider<Lifecycle.Event> provider;

    public BaseMomentBusinessImpl(LifecycleProvider<Lifecycle.Event> provider) {
        this.provider = provider;
    }

    @Override
    public Observable<List<MomentsBean>> operatorMomentData(Observable<BaseResult<BasePageResponse<List<MomentsResponseBean>>>> observable, BaseParams params) {
        return observable.compose(MomentsRxTransformer.momentsCompose(this.provider, params)).map(BasePageResponse::getData).flatMap(Observable::fromIterable).map(this::getMomentsABean).toList().toObservable().compose(ObservableTransfor.io_main());
    }

    @NonNull
    protected MomentsBean getMomentsABean(MomentsResponseBean momentsResponseBean) {
        MomentsBean momentsBean = new MomentsBean();
        UserInfoBean userInfo = MomentsDataManager.getInstance().queryUserInfo(momentsResponseBean.getUserId());
        if (userInfo == null || TextUtils.isEmpty((CharSequence)userInfo.getUserName()) || TextUtils.isEmpty((CharSequence)userInfo.getUserId())) {
            userInfo = new UserInfoBean();
            userInfo.setAuxPolice(false);
            userInfo.setDeptId("");
            userInfo.setDeptName("");
            userInfo.setDeptId("");
            userInfo.setUserAvatar("");
            userInfo.setUserName("\u5df2\u5220\u9664\u7528\u6237");
            userInfo.setUserId("");
        }
        momentsBean.setUserInfo(userInfo);
        String atIds = momentsResponseBean.getAtIds();
        List<UserInfoBean> atUserInfoList = this.buildAtList(atIds);
        momentsBean.setAtInfoList(atUserInfoList);
        List<PraiseBean> praiseList = momentsResponseBean.getPraiseList();
        List<UserInfoBean> newPraiseInfoList = this.buildPraiseList(praiseList);
        momentsBean.setPraiseList(newPraiseInfoList);
        List<CommentResponseBean> commentList = momentsResponseBean.getCommentList();
        List<CommentBean> newCommentList = this.buildCommentList(commentList);
        momentsBean.setCommentList(newCommentList);
        String momentPicturePath = momentsResponseBean.getMomentPicturePath();
        List<ImageBean> imageBeans = this.buildImageList(momentPicturePath);
        momentsBean.setImageBeans(imageBeans);
        momentsBean.setAddress(momentsResponseBean.getAddress());
        momentsBean.setAddressDetail(momentsResponseBean.getAddressDetail());
        momentsBean.setBrowseAuth(momentsResponseBean.getBrowseAuth());
        momentsBean.setClassifyId(momentsResponseBean.getClassifyId());
        momentsBean.setCommentCount(momentsResponseBean.getCommentCount());
        momentsBean.setCommentIsLastPage(momentsResponseBean.isCommentIsLastPage());
        momentsBean.setCommentLastRecodeTimeStamp(momentsResponseBean.getCommentLastRecodeTimeStamp());
        momentsBean.setCreateTime(momentsResponseBean.getCreateTime());
        momentsBean.setDeleteFlag(momentsResponseBean.getDeleteFlag());
        momentsBean.setEliteFlag(momentsResponseBean.getEliteFlag());
        momentsBean.setHotFlag(momentsResponseBean.getHotFlag());
        momentsBean.setLatitude(momentsResponseBean.getLatitude());
        momentsBean.setLongitude(momentsResponseBean.getLongitude());
        momentsBean.setMomentContent(momentsResponseBean.getMomentContent());
        momentsBean.setMomentFileName(momentsResponseBean.getMomentFileName());
        momentsBean.setMomentFilePath("http://" + ConstantUrl.FASTDFS_HOST + ":" + ConstantUrl.FASTDFS__PORT + "/" + momentsResponseBean.getMomentFilePath());
        try {
            momentsBean.setMomentFileSize(momentsResponseBean.getMomentFileSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        momentsBean.setMomentFileType(momentsResponseBean.getMomentFileType());
        momentsBean.setMomentId(momentsResponseBean.getMomentId());
        momentsBean.setMomentType(momentsResponseBean.getMomentType());
        momentsBean.setMomentVerifyContent(momentsResponseBean.getMomentVerifyContent());
        momentsBean.setMomentVerifyStatus(momentsResponseBean.getMomentVerifyStatus());
        momentsBean.setMomentVerifyTime(momentsResponseBean.getMomentVerifyTime());
        momentsBean.setMomentVideoTime(momentsResponseBean.getMomentVideoTime());
        momentsBean.setPraiseCount(momentsResponseBean.getPraiseCount());
        momentsBean.setRecommendFlag(momentsResponseBean.getRecommendFlag());
        momentsBean.setRecommendPeriod(momentsResponseBean.getRecommendPeriod());
        momentsBean.setRecommendTime(momentsResponseBean.getRecommendTime());
        momentsBean.setRecommendType(momentsResponseBean.getRecommendType());
        momentsBean.setShareFlag(momentsResponseBean.getShareFlag());
        momentsBean.setShareSource(momentsResponseBean.getShareSource());
        momentsBean.setTenantId(momentsResponseBean.getTenantId());
        momentsBean.setMomentShareContent(momentsResponseBean.getMomentShareContent());
        momentsBean.setMomentShareUrl(momentsResponseBean.getMomentShareUrl());
        momentsBean.setMomentSharePicture(momentsResponseBean.getMomentSharePicture());
        momentsBean.setPraiseFlag(momentsResponseBean.getPraiseFlag());
        return momentsBean;
    }

    @NonNull
    private List<ImageBean> buildImageList(String imageFileIds) {
        ArrayList<ImageBean> imageList = new ArrayList<ImageBean>();
        if (!TextUtils.isEmpty((CharSequence)imageFileIds)) {
            List<String> imageFileIdList = Arrays.asList(imageFileIds.split("\\,"));
            for (String imageFileId : imageFileIdList) {
                ImageBean imageBean = new ImageBean();
                imageBean.setHeight(MomentImageUtil.getImageHeight(imageFileId));
                imageBean.setWidth(MomentImageUtil.getImageWidth(imageFileId));
                imageBean.setPath(MomentImageUtil.getImageUrl(imageFileId));
                imageList.add(imageBean);
            }
        }
        return imageList;
    }

    @NonNull
    private List<UserInfoBean> buildAtList(String atIds) {
        ArrayList<UserInfoBean> atUserInfoList = new ArrayList<UserInfoBean>();
        if (!TextUtils.isEmpty((CharSequence)atIds)) {
            List<String> ids = Arrays.asList(atIds.split("\\,"));
            atUserInfoList.addAll(MomentsDataManager.getInstance().queryUserList(ids));
        }
        return atUserInfoList;
    }

    @NonNull
    private List<UserInfoBean> buildPraiseList(List<PraiseBean> praiseList) {
        ArrayList<UserInfoBean> userInfoList = new ArrayList<UserInfoBean>();
        if (praiseList != null && praiseList.size() > 0) {
            ArrayList<String> praiseIds = new ArrayList<String>();
            for (PraiseBean praiseBean : praiseList) {
                praiseIds.add(praiseBean.getUserId());
            }
            List<UserInfoBean> userInfoBeans = MomentsDataManager.getInstance().queryUserList(praiseIds);
            for (UserInfoBean userInfoBean : userInfoBeans) {
                if (userInfoBean != null && !TextUtils.isEmpty((CharSequence)userInfoBean.getUserName()) && !TextUtils.isEmpty((CharSequence)userInfoBean.getUserId())) continue;
                userInfoBean = new UserInfoBean();
                userInfoBean.setAuxPolice(false);
                userInfoBean.setDeptId("");
                userInfoBean.setDeptName("");
                userInfoBean.setDeptId("");
                userInfoBean.setUserAvatar("");
                userInfoBean.setUserName("\u5df2\u5220\u9664\u7528\u6237");
                userInfoBean.setUserId("");
            }
            userInfoList.addAll(userInfoBeans);
        }
        return userInfoList;
    }

    @NonNull
    protected List<CommentBean> buildCommentList(List<CommentResponseBean> commentList) {
        ArrayList<CommentBean> newCommentList = new ArrayList<CommentBean>();
        if (commentList != null && commentList.size() > 0) {
            for (CommentResponseBean commentResponseBean : commentList) {
                String toUserId;
                if (commentResponseBean == null) continue;
                CommentBean newCommentBean = new CommentBean();
                String userId = commentResponseBean.getUserId();
                UserInfoBean commentUserInfo = MomentsDataManager.getInstance().queryUserInfo(userId);
                if (commentUserInfo == null || TextUtils.isEmpty((CharSequence)commentUserInfo.getUserName()) || TextUtils.isEmpty((CharSequence)commentUserInfo.getUserId())) {
                    commentUserInfo = new UserInfoBean();
                    commentUserInfo.setAuxPolice(false);
                    commentUserInfo.setDeptId("");
                    commentUserInfo.setDeptName("");
                    commentUserInfo.setDeptId("");
                    commentUserInfo.setUserAvatar("");
                    commentUserInfo.setUserName("\u5df2\u5220\u9664\u7528\u6237");
                    commentUserInfo.setUserId("");
                }
                if (TextUtils.isEmpty((CharSequence)(toUserId = commentResponseBean.getToUserId()))) {
                    newCommentBean.setToUserInfo(null);
                } else {
                    UserInfoBean toUserInfo = MomentsDataManager.getInstance().queryUserInfo(toUserId);
                    if (toUserInfo == null || TextUtils.isEmpty((CharSequence)toUserInfo.getUserName()) || TextUtils.isEmpty((CharSequence)toUserInfo.getUserId())) {
                        toUserInfo = new UserInfoBean();
                        toUserInfo.setAuxPolice(false);
                        toUserInfo.setDeptId("");
                        toUserInfo.setDeptName("");
                        toUserInfo.setDeptId("");
                        toUserInfo.setUserAvatar("");
                        toUserInfo.setUserName("\u5df2\u5220\u9664\u7528\u6237");
                        toUserInfo.setUserId("");
                    }
                    newCommentBean.setToUserInfo(toUserInfo);
                }
                newCommentBean.setCommentContent(commentResponseBean.getCommentContent());
                newCommentBean.setCommentId(commentResponseBean.getCommentId());
                newCommentBean.setCreateTime(commentResponseBean.getCreateTime());
                newCommentBean.setUserInfo(commentUserInfo);
                newCommentList.add(newCommentBean);
            }
        }
        return newCommentList;
    }
}

