/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.base.moments;

import android.arch.lifecycle.Lifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseObserver;
import com.xdja.baselibrary.base.BasePageResponse;
import com.xdja.baselibrary.base.BaseParams;
import com.xdja.baselibrary.base.BaseResult;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.flow.base.business.BaseMomentListBusiness;
import com.xdja.moments.sdk.flow.base.business.impl.BaseMomentListBusinessImpl;
import com.xdja.moments.sdk.flow.base.moments.BaseMomentsPresenter;
import com.xdja.moments.sdk.flow.base.moments.IBaseMomentListPresenter;
import com.xdja.moments.sdk.flow.base.moments.IBaseMomentListView;
import com.xdja.moments.sdk.http.bean.request.MomentsSaveComment;
import com.xdja.moments.sdk.http.bean.response.MomentsResponseBean;
import com.xdja.moments.sdk.http.bean.response.PraiseResponseBean;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class BaseMomentListPresenter
extends BaseMomentsPresenter
implements IBaseMomentListPresenter {
    private IBaseMomentListView mView;
    private BaseMomentListBusiness business;

    public BaseMomentListPresenter(LifecycleProvider<Lifecycle.Event> provider, IBaseMomentListView view) {
        super(provider, view);
        this.mView = view;
        this.business = new BaseMomentListBusinessImpl(provider);
    }

    @Override
    public void operatorMomentsData(Observable<BaseResult<BasePageResponse<List<MomentsResponseBean>>>> observable, BaseParams params) {
        this.business.operatorMomentData(observable, params).subscribe((Observer)new BaseObserver<List<MomentsBean>>((IBaseView)this.mView, "\u52a0\u8f7d\u4e2d\u2026"){

            public void onNext(List<MomentsBean> momentsBeanList) {
                super.onNext(momentsBeanList);
                BaseMomentListPresenter.this.mView.onGetMomentsFinish(momentsBeanList);
            }
        });
    }

    @Override
    public void deleteMoments(String momentId) {
        this.business.deleteMoments(momentId).subscribe((Observer)new BaseObserver<Object>((IBaseView)this.mView, "\u52a0\u8f7d\u4e2d\u2026", "momentInfo/deleteMomentInfo"){

            public void onNext(Object o) {
                super.onNext(o);
                BaseMomentListPresenter.this.mView.onDeleteMomentsSuccess();
            }
        });
    }

    @Override
    public void hideMoments(String momentId) {
        this.business.hideMoments(momentId).subscribe((Observer)new BaseObserver<Object>((IBaseView)this.mView, "\u52a0\u8f7d\u4e2d\u2026", "momentHide/hideMomentInfo"){

            public void onNext(Object o) {
                super.onNext(o);
                BaseMomentListPresenter.this.mView.onHideSuccess();
            }
        });
    }

    @Override
    public void praiseMoments(String momentId, String praiseFlag) {
        this.business.praiseMoments(momentId, praiseFlag).subscribe((Observer)new BaseObserver<PraiseResponseBean>((IBaseView)this.mView, false, "", "momentPraise/updateMomentPraise"){

            public void onNext(PraiseResponseBean o) {
                super.onNext((Object)o);
                BaseMomentListPresenter.this.mView.onPraiseSuccess(o);
            }
        });
    }

    @Override
    public void deleteComment(String commentId) {
        this.business.deleteComment(commentId).subscribe((Observer)new BaseObserver<Object>((IBaseView)this.mView, "\u52a0\u8f7d\u4e2d\u2026", "momentComment/deleteMomentComment"){

            public void onNext(Object o) {
                super.onNext(o);
                BaseMomentListPresenter.this.mView.onDeleteCommentsSuccess();
            }
        });
    }

    @Override
    public void saveComment(MomentsSaveComment info) {
        this.business.saveComment(info).subscribe((Observer)new BaseObserver<Object>((IBaseView)this.mView, "\u52a0\u8f7d\u4e2d\u2026", "momentComment/saveMomentComment"){

            public void onNext(Object o) {
                super.onNext(o);
                BaseMomentListPresenter.this.mView.onCommentSuccess();
            }
        });
    }
}

