/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail;

import android.app.Activity;
import android.app.AlertDialog;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.ClipboardManager;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.util.DensityUtil;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.baselibrary.util.GlideCircleTransform;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.baselibrary.widget.SmoothCheckBox;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.flow.detail.adapter.MomentsDetailAdapter;
import com.xdja.moments.sdk.flow.detail.mvp.MomentDetailConstruct;
import com.xdja.moments.sdk.flow.detail.mvp.MomentDetailPresenter;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import com.xdja.moments.sdk.utils.SoftHideKeyBoardUtil;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModel;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModelFactory;
import com.xdja.moments.sdk.viewmodel.MomentsConfigViewModel;
import com.xdja.moments.sdk.widget.ExpandableTextView;
import com.xdja.moments.sdk.widget.MomentsSpanTextView;
import com.xdja.moments.sdk.widget.PictureGridLayout;
import com.xdja.moments.sdk.widget.input.InputLinearLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Route(path="/detail/momentDetail")
public class MomentDetailActivity
extends BaseActivity
implements MomentDetailConstruct.View,
OnRefreshLoadMoreListener {
    private MomentDetailPresenter presenter;
    private TextView mTvReViewFailReason;
    private ImageView mIvHeadImage;
    private ImageView mIvAuxpoliceMark;
    private TextView mTvTopicUserName;
    private TextView mTvTopicTime;
    private TextView mTvFrom;
    private ImageView mIvMomentMore;
    private SmoothCheckBox mCbReviewSelect;
    private TextView mTvMomentsContent;
    private Button mExpandCollapse;
    private ExpandableTextView mExpandTextView;
    private MomentsSpanTextView mAtListView;
    private TextView mTvLocation;
    private TextView mTvPraise;
    private TextView mTvComment;
    private MomentsSpanTextView mPraiseListView;
    private InputLinearLayout inputView;
    private PictureGridLayout pictureGridLayout;
    private ImageView ivVideoPreview;
    private ImageView ivVideoPlay;
    private ImageView imgFileIcon;
    private TextView tvFileName;
    private View atGroup;
    private View praiseGroup;
    private View fileView;
    private View inputViewLine;
    private ViewGroup content;
    private boolean longClick;
    private ClipboardManager clipboard;
    private MomentsDetailAdapter adapter;
    @Autowired(name="moment_id")
    public String momentsId;
    @Autowired(name="comment_id")
    public String commentId;
    private SmartRefreshLayout mRefreshLayout;
    private RecyclerView mRecyclerView;
    private View headerView;
    private List<BottomMenuBean> bottomMenuBeanList = new ArrayList<BottomMenuBean>();
    private MomentsConfigViewModel configViewModel;
    private MomentsClassifyViewModel classifyViewModel;
    private boolean isRuningAnimation = false;

    protected int getRootView() {
        return R.layout.moments_detail_activity_layout;
    }

    protected ViewGroup getErrorParentView() {
        return this.content;
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        this.setOnceLoadingType(LoadingType.LOAD_TYPE_COVER);
        this.presenter = new MomentDetailPresenter(this, provider);
        this.clipboard = (ClipboardManager)this.getSystemService("clipboard");
        this.presenter.getMomentDetail(this.momentsId, true);
        this.configViewModel = (MomentsConfigViewModel)ViewModelProviders.of((FragmentActivity)this).get(MomentsConfigViewModel.class);
        this.configViewModel.getMomentsConfig().observe((LifecycleOwner)this, (Observer)new Observer<MomentsConfig>(){

            public void onChanged(@Nullable MomentsConfig momentsConfig) {
                MomentDetailActivity.this.presenter.onMomentsConfigChanged(momentsConfig);
            }
        });
    }

    protected void initView() {
        ARouter.getInstance().inject((Object)this);
        this.setMomentsTitle("\u52a8\u6001\u8be6\u60c5");
        SoftHideKeyBoardUtil.assistActivity((Activity)this);
        this.content = (ViewGroup)this.findViewById(R.id.ly_content);
        this.inputViewLine = this.findViewById(R.id.line);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refreshLayout);
        if (!MomentsManager.getInstance().isCustomHeader()) {
            this.mRefreshLayout.setRefreshHeader((RefreshHeader)new ClassicsHeader(this.getApplicationContext()).setProgressResource(R.drawable.moments_progressbar_loading));
        }
        if (!MomentsManager.getInstance().isCustomFooter()) {
            this.mRefreshLayout.setRefreshFooter((RefreshFooter)new ClassicsFooter(this.getApplicationContext()).setProgressResource(R.drawable.moments_progressbar_loading));
        }
        this.mRefreshLayout.setOnRefreshLoadMoreListener((OnRefreshLoadMoreListener)this);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.inputView = (InputLinearLayout)this.findViewById(R.id.review_ll);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.adapter = new MomentsDetailAdapter(this.mRecyclerView, new ArrayList<CommentBean>());
        this.inputView.setFocusable(true);
        this.inputView.setFocusableInTouchMode(true);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.adapter.setOnItemClickListener(new MomentsDetailAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(CommentBean commentBean) {
                MomentDetailActivity.this.presenter.onClickComments(commentBean);
                MomentDetailActivity.this.mRecyclerView.scrollToPosition(MomentDetailActivity.this.adapter.getDataLists().indexOf(commentBean) + 1);
            }
        });
        this.adapter.setOnItemLongClickListener(new MomentsDetailAdapter.OnItemLongClickListener(){

            @Override
            public void onItemLongClick(CommentBean commentBean) {
                MomentDetailActivity.this.presenter.onCommentLongClick(commentBean);
            }
        });
        this.mRecyclerView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View arg0, MotionEvent arg1) {
                MomentDetailActivity.this.presenter.onClickCommentsOutSide();
                MomentDetailActivity.this.inputView.hideKeyboardAndEmoji();
                return false;
            }
        });
        this.inputView.initView((Activity)this, false, new InputLinearLayout.SendClickListener(){

            @Override
            public void onSendClick(String content) {
                MomentDetailActivity.this.presenter.onClickSendComment(content);
            }
        });
        this.inputView.setHint(this.getString(R.string.moments_write_comment));
    }

    @Override
    public void setHeaderView(final MomentsBean momentsBean) {
        if (this.headerView != null) {
            return;
        }
        MomentsClassifyViewModelFactory factory = new MomentsClassifyViewModelFactory(this.getApplication(), momentsBean.getClassifyId());
        this.classifyViewModel = (MomentsClassifyViewModel)ViewModelProviders.of((FragmentActivity)this, factory).get(MomentsClassifyViewModel.class);
        this.classifyViewModel.getMomentsClassIfy().observe((LifecycleOwner)this, (Observer)new Observer<MomentsClassify>(){

            public void onChanged(@Nullable MomentsClassify momentsClassify) {
                MomentDetailActivity.this.presenter.onMomentsPowerChanged(momentsClassify);
            }
        });
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        switch (momentsBean.getMomentType()) {
            case 1: {
                this.headerView = inflater.inflate(R.layout.moments_detail_include_text_header, (ViewGroup)this.mRecyclerView, false);
                break;
            }
            case 2: {
                this.headerView = inflater.inflate(R.layout.moments_detail_include_image_header, (ViewGroup)this.mRecyclerView, false);
                break;
            }
            case 3: {
                this.headerView = inflater.inflate(R.layout.moments_detail_include_video_header, (ViewGroup)this.mRecyclerView, false);
                break;
            }
            case 4: {
                this.headerView = inflater.inflate(R.layout.moments_detail_include_file_header, (ViewGroup)this.mRecyclerView, false);
                break;
            }
            case 5: {
                this.headerView = inflater.inflate(R.layout.moments_detail_include_link_header, (ViewGroup)this.mRecyclerView, false);
                break;
            }
            default: {
                this.headerView = inflater.inflate(R.layout.moments_detail_include_text_header, (ViewGroup)this.mRecyclerView, false);
            }
        }
        this.headerView.setOnClickListener(v -> {});
        this.headerView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                MomentDetailActivity.this.showCopyDialog(momentsBean.getMomentContent());
                return true;
            }
        });
        this.adapter.addHeaderView(this.headerView);
        this.findViews();
    }

    @Override
    public void setCommentHint(String hint) {
        this.inputView.setHint(hint);
    }

    @Override
    public void removeComment(CommentBean commentBean) {
        this.adapter.remove(commentBean);
    }

    @Override
    public void setLoadingType(LoadingType loadingType) {
        this.setOnceLoadingType(loadingType);
    }

    @Override
    public String getCommentInputText() {
        return this.inputView.getInputText();
    }

    @Override
    public void setCommentInputViewText(String s) {
        this.inputView.getEditText().setText((CharSequence)s);
    }

    @Override
    public void setBottomMenuList(List<BottomMenuBean> menuList) {
        if (ListUtil.isEmpty(menuList)) {
            return;
        }
        this.bottomMenuBeanList.clear();
        this.bottomMenuBeanList.addAll(menuList);
    }

    private void findViews() {
        this.mTvReViewFailReason = (TextView)this.headerView.findViewById(R.id.tv_reView_fail_reason);
        this.mIvHeadImage = (ImageView)this.headerView.findViewById(R.id.iv_head_image);
        this.mIvAuxpoliceMark = (ImageView)this.headerView.findViewById(R.id.iv_auxpolice_mark);
        this.mTvTopicUserName = (TextView)this.headerView.findViewById(R.id.tv_topic_user_name);
        this.mTvTopicTime = (TextView)this.headerView.findViewById(R.id.tv_topic_time);
        this.mTvFrom = (TextView)this.headerView.findViewById(R.id.tv_from);
        this.mIvMomentMore = (ImageView)this.headerView.findViewById(R.id.iv_moment_more);
        this.mCbReviewSelect = (SmoothCheckBox)this.headerView.findViewById(R.id.cb_review_select);
        this.mTvMomentsContent = (TextView)this.headerView.findViewById(R.id.tv_moments_content);
        this.mExpandCollapse = (Button)this.headerView.findViewById(R.id.expand_collapse);
        this.mExpandTextView = (ExpandableTextView)this.headerView.findViewById(R.id.expand_text_view);
        this.mAtListView = (MomentsSpanTextView)this.headerView.findViewById(R.id.atListView);
        this.mTvLocation = (TextView)this.headerView.findViewById(R.id.tv_location);
        this.mTvPraise = (TextView)this.headerView.findViewById(R.id.tv_praise);
        this.mTvComment = (TextView)this.headerView.findViewById(R.id.tv_comment);
        this.mPraiseListView = (MomentsSpanTextView)this.headerView.findViewById(R.id.praiseListView);
        this.pictureGridLayout = (PictureGridLayout)this.headerView.findViewById(R.id.pictureGridLayout);
        this.ivVideoPreview = (ImageView)this.headerView.findViewById(R.id.iv_video_preview);
        this.ivVideoPlay = (ImageView)this.headerView.findViewById(R.id.iv_video_play);
        this.imgFileIcon = (ImageView)this.headerView.findViewById(R.id.img_file_icon);
        this.tvFileName = (TextView)this.headerView.findViewById(R.id.tv_file_name);
        this.atGroup = this.headerView.findViewById(R.id.at_group);
        this.fileView = this.headerView.findViewById(R.id.ly_accessory);
        this.praiseGroup = this.headerView.findViewById(R.id.praise_group);
        this.mTvReViewFailReason.setVisibility(8);
        this.mIvMomentMore.setVisibility(8);
        this.mTvPraise.setOnClickListener(v -> this.presenter.onClickPraise());
        this.mTvLocation.setOnClickListener(v -> this.presenter.onLocationClick());
        this.mTvComment.setOnClickListener(v -> {
            if (this.inputView.getVisibility() == 0) {
                this.inputView.getEditText().requestFocus();
                this.showKeyboard(this.inputView.getEditText());
            }
        });
        if (this.fileView != null) {
            this.fileView.setOnClickListener(v -> this.presenter.onFileViewClick());
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_detail, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        this.showBottomMenu(this.bottomMenuBeanList);
        return super.onOptionsItemSelected(item);
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_LIST;
    }

    protected void onBottomMenuItemClick(int position) {
        BottomMenuBean bottomMenuBean = this.bottomMenuBeanList.get(position);
        if (TextUtils.equals((CharSequence)this.getString(R.string.moments_bottom_menu_transmit), (CharSequence)bottomMenuBean.getItemName())) {
            this.presenter.onClickTransmit();
        } else if (TextUtils.equals((CharSequence)this.getString(R.string.moments_bottom_menu_hide), (CharSequence)bottomMenuBean.getItemName())) {
            this.showAlertDialog(this.getString(R.string.moments_cancel), this.getString(R.string.moments_confirm), this.getString(R.string.moments_confirm_hide_moment), v -> this.dismissAlertDialog(), v -> {
                this.dismissAlertDialog();
                this.presenter.onClickHideMoment();
            });
        } else if (TextUtils.equals((CharSequence)this.getString(R.string.moments_bottom_menu_delete), (CharSequence)bottomMenuBean.getItemName())) {
            this.showAlertDialog(this.getString(R.string.moments_cancel), this.getString(R.string.moments_confirm), this.getString(R.string.moments_confirm_delete_moment), v -> this.dismissAlertDialog(), v -> {
                this.dismissAlertDialog();
                this.presenter.onClickDeleteMoment();
            });
        }
        this.hideBottomMenu();
    }

    @Override
    public void setPublishUserName(String name) {
        this.mTvTopicUserName.setText((CharSequence)name);
    }

    @Override
    public void setPublishUserAvatar(String avatarPath) {
        Glide.with((FragmentActivity)this).load(avatarPath).transform(new BitmapTransformation[]{new GlideCircleTransform((Context)this)}).placeholder(R.drawable.moments_person_default).error(R.drawable.moments_person_default).into(this.mIvHeadImage);
    }

    @Override
    public void setPublishTime(String time) {
        this.mTvTopicTime.setText((CharSequence)time);
    }

    @Override
    public void setPublishDept(String dept) {
        this.mTvFrom.setText((CharSequence)dept);
    }

    @Override
    public void setTextContent(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            this.mExpandTextView.setVisibility(8);
            return;
        }
        this.mExpandTextView.setVisibility(0);
        this.mExpandTextView.setText(FaceManager.getInstance().convertNormalStringToSpannableString((Context)this, content), TextView.BufferType.SPANNABLE);
        SpannableString spannableString = (SpannableString)this.mExpandTextView.getText();
        if (spannableString != null) {
            Pattern mentionsPattern = Pattern.compile("((http|https|rtsp)://)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|([A-Za-z0-9-_]+\\.)+([A-Za-z]{2,6}))(:[0-9]{1,5})?((/[\\S&&[^,;\\s]]+)+)?");
            Matcher matcher = mentionsPattern.matcher((CharSequence)spannableString);
            while (matcher.find()) {
                MyURLSpan myURLSpan = new MyURLSpan(matcher.group());
                spannableString.setSpan((Object)myURLSpan, matcher.start(), matcher.end(), 33);
            }
        }
        this.mExpandTextView.setAutoLinkMask(0);
        this.mExpandTextView.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
        this.mExpandTextView.setMovementMethod(LinkMovementMethod.getInstance());
        this.mExpandTextView.setOnLongClickListener(arg0 -> {
            this.longClick = true;
            return true;
        });
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                MomentDetailActivity.this.longClick = true;
                CharSequence text = MomentDetailActivity.this.mExpandTextView.getText();
                if (text == null) {
                    MomentDetailActivity.this.showToast("\u6ca1\u6709\u5185\u5bb9\u53ef\u4ee5\u590d\u5236");
                } else {
                    MomentDetailActivity.this.showCopyDialog(text.toString());
                }
                return true;
            }
        };
        this.mExpandTextView.setContentOnLongClickListener(onLongClickListener);
    }

    @Override
    public void showCopyDialog(String text) {
        AlertDialog dlg = new AlertDialog.Builder((Context)this).create();
        dlg.show();
        Window window = dlg.getWindow();
        window.setContentView(R.layout.moments_alertdialog_copy);
        TextView copy = (TextView)window.findViewById(R.id.tv_copy);
        copy.setOnClickListener(v -> {
            dlg.dismiss();
            this.clipboard.setText((CharSequence)text);
            this.showToast("\u5df2\u590d\u5236");
        });
    }

    @Override
    public void showCopyAndDeleteDialog(final CommentBean bean) {
        final AlertDialog dlg = new AlertDialog.Builder((Context)this).create();
        dlg.show();
        Window window = dlg.getWindow();
        window.setContentView(R.layout.moments_alertdialog_copy_delete);
        TextView copy = (TextView)window.findViewById(R.id.tv_copy);
        TextView delete = (TextView)window.findViewById(R.id.tv_delete);
        copy.setOnClickListener(v -> {
            dlg.dismiss();
            this.clipboard.setText((CharSequence)bean.getCommentContent());
            this.showToast("\u5df2\u590d\u5236");
        });
        delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dlg.dismiss();
                MomentDetailActivity.this.presenter.onClickDeleteComment(bean);
            }
        });
    }

    @Override
    public void showInputCommentView(boolean b) {
        this.inputView.setVisibility(b ? 0 : 8);
        this.inputViewLine.setVisibility(b ? 0 : 8);
    }

    @Override
    public void showPraiseView(boolean b) {
        this.mTvPraise.setVisibility(b ? 0 : 8);
    }

    public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
        this.presenter.onLoadMore();
    }

    public void onRefresh(@NonNull RefreshLayout refreshLayout) {
        this.presenter.getMomentDetail(this.momentsId, false);
    }

    @Override
    public void setAtView(List<UserInfoBean> atUserList) {
        if (ListUtil.isEmpty(atUserList)) {
            this.atGroup.setVisibility(8);
        } else {
            this.atGroup.setVisibility(0);
            this.mAtListView.setUserList(atUserList, userInfoBean -> this.presenter.onMemberClick(userInfoBean));
        }
    }

    @Override
    public void setPictureView(List<ImageBean> pictureList) {
        this.pictureGridLayout.setPictures((Context)this, pictureList);
    }

    @Override
    public void setVideoView(String videoPath, ImageBean thumbImageBean) {
        MomentImageUtil.resetLayoutParams((View)this.ivVideoPreview, thumbImageBean);
        Glide.with((FragmentActivity)this).load(thumbImageBean.getPath()).fitCenter().error(R.drawable.moments_img_pic_default).placeholder(R.drawable.moments_img_pic_default).diskCacheStrategy(DiskCacheStrategy.RESULT).into(this.ivVideoPreview);
        this.ivVideoPlay.setOnClickListener(v -> this.presenter.onClickPlayVideo(videoPath));
    }

    @Override
    public void setFileView(String filePath, String ext) {
        int resId = FileUtil.getFileDrawable(filePath);
        this.imgFileIcon.setImageResource(resId);
        this.tvFileName.setText((CharSequence)FileUtils.getFileName((String)filePath));
    }

    @Override
    public void setLinkView(String momentShareUrl, String momentShareContent, String momentSharePicture) {
        Glide.with((FragmentActivity)this).load(momentSharePicture).fitCenter().error(R.drawable.moments_img_pic_default).placeholder(R.drawable.moments_img_pic_default).diskCacheStrategy(DiskCacheStrategy.RESULT).into(this.imgFileIcon);
        this.tvFileName.setText((CharSequence)momentShareContent);
    }

    @Override
    public void setLocation(String address) {
        if (!TextUtils.isEmpty((CharSequence)address)) {
            this.mTvLocation.setVisibility(0);
            this.mTvLocation.setText((CharSequence)address);
        } else {
            this.mTvLocation.setVisibility(8);
        }
    }

    @Override
    public void setCommentNum(int num) {
        this.mTvComment.setText((CharSequence)("\u8bc4\u8bba " + num));
    }

    @Override
    public void setPraiseNum(int num) {
        this.mTvPraise.setText((CharSequence)("\u70b9\u8d5e " + num));
    }

    @Override
    public void setPraiseState(String state) {
        Drawable drawable2 = this.getResources().getDrawable("1".equals(state) ? R.drawable.moments_item_praise : R.drawable.moments_item_unpraise);
        drawable2.setBounds(0, 0, DensityUtil.dip2px((Context)this, (float)15.0f), DensityUtil.dip2px((Context)this, (float)15.0f));
        this.mTvPraise.setCompoundDrawables(drawable2, null, null, null);
    }

    @Override
    public void setPraiseDetail(List<UserInfoBean> list, int realCount, boolean isShowNew) {
        this.mPraiseListView.setBasePraiseText(list, realCount, isShowNew, userInfoBean -> this.presenter.onMemberClick(userInfoBean));
        this.praiseGroup.setVisibility(ListUtil.isEmpty(list) ? 8 : 0);
        this.adapter.setShowPraiseView(!ListUtil.isEmpty(list));
    }

    @Override
    public void onRefreshSucess(List<CommentBean> commentList, boolean isLastPage) {
        this.mRefreshLayout.finishRefresh();
        if (isLastPage) {
            this.mRefreshLayout.setEnableLoadMore(false);
            if (!ListUtil.isEmpty(commentList)) {
                this.adapter.showLoadComplete();
            } else {
                this.adapter.hideLoadComplete();
            }
        }
        this.adapter.clear();
        if (ListUtil.isEmpty(commentList)) {
            this.adapter.showEmptyFooter();
        } else {
            this.adapter.removeEmtypFooter();
            this.adapter.addAll(commentList);
            if (!TextUtils.isEmpty((CharSequence)this.commentId)) {
                for (CommentBean bean : commentList) {
                    if (!this.commentId.equals(bean.getCommentId())) continue;
                    int position = commentList.indexOf(bean);
                    this.mRecyclerView.scrollToPosition(this.adapter.getHeaderCount() + position);
                    this.commentId = "";
                }
            }
        }
    }

    @Override
    public void onRefreshFail() {
        this.mRefreshLayout.finishRefresh();
    }

    @Override
    public void onLoadMoreSuccess(List<CommentBean> data, boolean isFirstPage) {
        this.mRefreshLayout.finishLoadMore();
        if (data == null || data.size() == 0) {
            if (isFirstPage) {
                this.adapter.showEmptyFooter();
            } else {
                this.adapter.removeEmtypFooter();
                this.mRefreshLayout.setEnableLoadMore(false);
                this.adapter.showLoadComplete();
            }
            return;
        }
        this.adapter.removeEmtypFooter();
        if (isFirstPage) {
            this.adapter.getDataLists().clear();
        }
        this.adapter.addAll(data);
    }

    @Override
    public void onLoadMoreFail() {
        this.mRefreshLayout.finishLoadMore();
    }

    protected void onErrorLayoutClick() {
        super.onErrorLayoutClick();
        this.presenter.getMomentDetail(this.momentsId, true);
    }

    protected LoadingType getLoadingType() {
        return LoadingType.LOAD_TYPE_NONE;
    }

    @Override
    public void finish() {
        this.hideKeyboard();
        super.finish();
    }

    @Override
    public void showKeyBoard(boolean b) {
        if (b) {
            this.inputView.getEditText().requestFocus();
            this.showKeyboard(this.inputView.getEditText());
        } else {
            this.hideKeyboard();
        }
    }

    @Override
    public void startPraiseAnimation(Animation animation) {
        this.mTvPraise.startAnimation(animation);
    }

    private class MyURLSpan
    extends ClickableSpan {
        private String mUrl;

        MyURLSpan(String url) {
            this.mUrl = url;
        }

        public void updateDrawState(TextPaint ds) {
            super.updateDrawState(ds);
            ds.setColor(-16743733);
            ds.setUnderlineText(false);
        }

        public void onClick(View widget) {
            if (MomentDetailActivity.this.longClick) {
                MomentDetailActivity.this.longClick = false;
                return;
            }
            Navigation.navigationUrlDetailActivity((Activity)MomentDetailActivity.this, "\u8be6\u60c5", this.mUrl);
            widget.clearFocus();
        }
    }
}

