/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.XViewHolder;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.utils.DateUtil;
import com.xdja.moments.sdk.utils.UrlUtils;
import com.xdja.moments.sdk.utils.spannable.CircleMovementMethod;
import com.xdja.moments.sdk.utils.spannable.SpannableClickable;
import com.xdja.moments.sdk.widget.MomentsSpanTextView;
import java.util.List;

public class MomentsDetailAdapter
extends XRecyclerViewAdapter<CommentBean> {
    private Context context;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private RecyclerView recyclerView;
    private View emptyFooter;
    private boolean showPraiseView;

    public MomentsDetailAdapter(@NonNull RecyclerView mRecyclerView, List<CommentBean> dataLists) {
        super(mRecyclerView, dataLists, R.layout.moments_detail_comment_item_layout);
        this.recyclerView = mRecyclerView;
        this.context = mRecyclerView.getContext();
    }

    protected void bindData(XViewHolder holder, CommentBean bean, int position) {
        ImageView icon = (ImageView)holder.getView(R.id.icon);
        TextView mTvName = (TextView)holder.getView(R.id.tv_name);
        MomentsSpanTextView mTvComment = (MomentsSpanTextView)holder.getView(R.id.tv_comment);
        TextView mTvCommentTime = (TextView)holder.getView(R.id.tv_comment_time);
        ImageView mIvHead = (ImageView)holder.getView(R.id.iv_head);
        if (this.dataLists.indexOf(bean) == 0) {
            icon.setVisibility(0);
            if (!this.showPraiseView) {
                holder.getView(R.id.contentLayout).setBackgroundResource(R.drawable.moments_comment_item_bg);
            } else {
                holder.getView(R.id.contentLayout).setBackgroundResource(R.color.moments_detail_comment_bg);
            }
        } else {
            icon.setVisibility(4);
            holder.getView(R.id.contentLayout).setBackgroundResource(R.color.moments_detail_comment_bg);
        }
        if (this.dataLists.indexOf(bean) + 1 == this.dataLists.size()) {
            holder.setVisible(R.id.divider, false);
        } else {
            holder.setVisible(R.id.divider, true);
        }
        CircleMovementMethod circleMovementMethod = new CircleMovementMethod(this.context.getResources().getColor(R.color.moments_clickable_color), this.context.getResources().getColor(R.color.moments_clickable_color));
        final UserInfoBean userInfoBean = bean.getUserInfo();
        holder.setImageUrl(this.context, R.id.iv_head, userInfoBean.getUserAvatar(), R.drawable.moments_person_default, true, true);
        String name = userInfoBean.getUserName();
        if (TextUtils.isEmpty((CharSequence)name) || "null".equals(name)) {
            name = "\u5df2\u5220\u9664\u7684\u7528\u6237";
        }
        mTvName.setText((CharSequence)name);
        mTvCommentTime.setText((CharSequence)DateUtil.getTimeStringFromNow(bean.getCreateTime()));
        mTvComment.setCommentText(bean, new MomentsSpanTextView.MemberClickListener(){

            @Override
            public void onMemberClick(UserInfoBean userInfoBean) {
                Navigation.navigationPersonDetail(MomentsDetailAdapter.this.context, userInfoBean.getUserId());
            }
        });
        String contentBodyStr = bean.getCommentContent();
        if (!TextUtils.isEmpty((CharSequence)contentBodyStr)) {
            mTvComment.append((CharSequence)UrlUtils.formatUrlString(contentBodyStr));
        }
        holder.getConvertView().setOnClickListener(v -> {
            if (circleMovementMethod.isPassToTv() && this.onItemClickListener != null) {
                this.onItemClickListener.onItemClick(bean);
            }
        });
        holder.getConvertView().setOnLongClickListener(v -> {
            if (circleMovementMethod.isPassToTv()) {
                if (this.onItemLongClickListener != null) {
                    this.onItemLongClickListener.onItemLongClick(bean);
                }
                return true;
            }
            return false;
        });
        mIvHead.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Navigation.navigationPersonDetail(MomentsDetailAdapter.this.context, userInfoBean.getUserId());
            }
        });
    }

    private SpannableString setClickableSpan(String textStr, final String id2) {
        SpannableString subjectSpanText = new SpannableString((CharSequence)textStr);
        subjectSpanText.setSpan((Object)new SpannableClickable(this.context.getResources().getColor(R.color.moments_text_blue)){

            public void onClick(View widget) {
                Navigation.navigationPersonDetail(MomentsDetailAdapter.this.context, id2);
            }
        }, 0, subjectSpanText.length(), 33);
        return subjectSpanText;
    }

    public void showEmptyFooter() {
        if (this.emptyFooter == null) {
            this.emptyFooter = LayoutInflater.from((Context)this.context).inflate(R.layout.moments_detail_no_comment, (ViewGroup)this.recyclerView, false);
        }
        if (this.showPraiseView) {
            this.emptyFooter.findViewById(R.id.line).setVisibility(8);
        } else {
            this.emptyFooter.findViewById(R.id.line).setVisibility(0);
        }
        this.addFooterView(this.emptyFooter);
    }

    public void removeEmtypFooter() {
        if (this.emptyFooter != null) {
            this.removeFooterView(this.emptyFooter);
            this.emptyFooter = null;
        }
    }

    public void setShowPraiseView(boolean b) {
        this.showPraiseView = b;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(CommentBean var1);
    }

    public static interface OnItemClickListener {
        public void onItemClick(CommentBean var1);
    }
}

