/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.file;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.orhanobut.logger.Logger;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.FileBean;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.http.download.DownLoadListener.HttpDownOnNextListener;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownManager;
import com.xdja.moments.sdk.repository.DownInfoRepository;
import com.xdja.moments.sdk.utils.FileProviderUtils;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.widget.MyProgressWheel;
import io.reactivex.FlowableTransformer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.ArrayList;

@Route(path="/detail/fileDetail")
public class FileDetailActivity
extends BaseActivity
implements View.OnClickListener {
    @Autowired(name="file_bean")
    public FileBean fileBean;
    private ImageView mImgMomentFileType;
    private TextView mTvFileName;
    private TextView mTvFileSize;
    private TextView mBtnDownload;
    private ImageView pBarBgImage;
    private MyProgressWheel myProgressWheel;
    private DownInfo downInfo;
    private HttpDownManager downloadManager;

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        this.downloadManager = HttpDownManager.getInstance();
        this.mBtnDownload.setText((CharSequence)"\u521d\u59cb\u5316\u2026");
        if (this.fileBean != null) {
            if (!FileUtil.isFileExist(FileUtil.getSavePath(this.fileBean.getDownLoadUrl()))) {
                Disposable disposable = DownInfoRepository.getInstance().getDownloadInfoByFileId(this.fileBean.getDownLoadUrl()).compose(FlowableTransfor.io_main()).compose((FlowableTransformer)provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(downInfo -> {
                    downInfo.setUpdateProgress(true);
                    this.downInfo = downInfo;
                    this.mBtnDownload.setEnabled(true);
                    this.mBtnDownload.setText((CharSequence)"\u4e0b\u8f7d");
                }, Throwable::printStackTrace);
            } else {
                this.pBarBgImage.setVisibility(8);
                this.myProgressWheel.setVisibility(8);
                this.mBtnDownload.setText(R.string.moments_open_file);
            }
        }
    }

    protected void initView() {
        ARouter.getInstance().inject((Object)this);
        this.setMomentsTitle(this.getString(R.string.moments_file_detail));
        this.mImgMomentFileType = (ImageView)this.findViewById(R.id.img_moment_file_type);
        this.mTvFileName = (TextView)this.findViewById(R.id.tv_file_name);
        this.mTvFileSize = (TextView)this.findViewById(R.id.tv_file_size);
        this.mBtnDownload = (TextView)this.findViewById(R.id.btn_download);
        this.mBtnDownload.setOnClickListener((View.OnClickListener)this);
        this.pBarBgImage = (ImageView)this.findViewById(R.id.img_loadingbg);
        this.myProgressWheel = (MyProgressWheel)this.findViewById(R.id.pb_sending_file);
        this.mImgMomentFileType.setImageResource(FileUtil.getFileDrawable(this.fileBean.getFileExt()));
        this.mTvFileName.setText((CharSequence)this.fileBean.getFileName());
        this.mTvFileSize.setText((CharSequence)FileUtil.getSizeString(this.fileBean.getFileSize()));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_detail, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_LIST;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.operate) {
            ArrayList<BottomMenuBean> list = new ArrayList<BottomMenuBean>();
            list.add(new BottomMenuBean(R.drawable.moments_icon_tran, this.getString(R.string.moments_bottom_menu_transmit)));
            this.showBottomMenu(list);
        }
        return false;
    }

    protected int getRootView() {
        return R.layout.moments_activity_file_detail;
    }

    protected void onBottomMenuItemClick(int position) {
        switch (position) {
            case 0: {
                if (this.downInfo != null && this.downInfo.getState() == DownState.FINISH) {
                    Navigation.shareFileTo(this.downInfo.getSavePath());
                    break;
                }
                this.showToast("\u6587\u4ef6\u9700\u8981\u4e0b\u8f7d\u624d\u80fd\u8f6c\u53d1");
            }
        }
        this.hideBottomMenu();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_download) {
            if (this.downInfo != null) {
                if (this.downInfo.getState() != DownState.FINISH && this.downInfo.getState() != DownState.DOWN) {
                    this.downloadFile();
                } else if (this.downInfo.getState() == DownState.FINISH) {
                    this.openFile(this.downInfo.getSavePath());
                }
            } else if (this.fileBean != null && FileUtil.isFileExist(FileUtil.getSavePath(this.fileBean.getDownLoadUrl()))) {
                this.openFile(FileUtil.getSavePath(this.fileBean.getDownLoadUrl()));
            }
        }
    }

    private void openFile(String path) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        File file = new File(path);
        FileProviderUtils.setIntentDataAndType((Context)this, intent, FileUtil.getFileMineType(file), file, true);
        this.startActivity(intent);
    }

    private void downloadFile() {
        try {
            if (this.downInfo != null) {
                this.downInfo.setListener(new HttpDownOnNextListener(){

                    public void onNext(Object o) {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onStart() {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onComplete() {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onError(Throwable e) {
                        super.onError(e);
                        FileDetailActivity.this.showToast("\u4e0b\u8f7d\u9519\u8bef");
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onPuase() {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void updateProgress(long readLength, long countLength) {
                        Logger.i((String)("readLength:" + readLength + ",countLength:" + countLength), (Object[])new Object[0]);
                        FileDetailActivity.this.refresh();
                    }
                });
                this.downloadManager.startDown(this.downInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refresh() {
        if (this.downInfo != null) {
            this.pBarBgImage.setVisibility(0);
            this.myProgressWheel.setVisibility(0);
            switch (this.downInfo.getState()) {
                case START: {
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_wait));
                    this.myProgressWheel.setProgress(0);
                    break;
                }
                case DOWN: {
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_stop));
                    this.myProgressWheel.setProgress((int)(this.downInfo.getReadLength() * 360L / this.downInfo.getCountLength()));
                    break;
                }
                case PAUSE: {
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_resume));
                    break;
                }
                case FINISH: {
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_open_file));
                    this.pBarBgImage.setVisibility(8);
                    this.myProgressWheel.setVisibility(8);
                    break;
                }
                case ERROR: {
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_retry));
                    break;
                }
            }
        }
    }
}

