/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.gallery;

import android.arch.lifecycle.Lifecycle;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.flow.detail.gallery.GalleryActivityPermissionsDispatcher;
import com.xdja.moments.sdk.flow.detail.gallery.fragment.ImageDetailFragment;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.widget.HackyViewPager;
import java.io.File;
import java.util.ArrayList;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
@Route(path="/publish/gallery")
public class GalleryActivity
extends BaseActivity {
    private static final String STATE_POSITION = "STATE_POSITION";
    public static final String EXTRA_IMAGE_INDEX = "image_index";
    public static final String EXTRA_IMAGE_URLS = "image_urls";
    private HackyViewPager mPager;
    @Autowired(name="image_index")
    public int pagerPosition;
    @Autowired(name="image_urls")
    public ArrayList<ImageBean> urls;
    private ImageBean mImageBean;
    private String imageScanResult = null;
    private int width = 0;
    private int height = 0;
    private String fileId;
    private String fileExt;
    private TextView indicator;
    private ImageButton imageButton;
    public static final String IMAGE_LOADING_SUCCESS = "com.xdja.jxclient.boardcast.imageloading";
    public static final String IMAGE_LONGCLICK = "com.xdja.jxclient.boardcast.imagelongclick";
    BroadcastReceiver imageLoadingReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ((intent == null || !intent.getAction().equals(GalleryActivity.IMAGE_LOADING_SUCCESS)) && intent != null && intent.getAction().equals(GalleryActivity.IMAGE_LONGCLICK)) {
                GalleryActivity.this.showDialog();
            }
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ARouter.getInstance().inject((Object)this);
        if (savedInstanceState != null) {
            this.pagerPosition = savedInstanceState.getInt(STATE_POSITION);
        }
        super.onCreate(savedInstanceState);
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        this.mPager = (HackyViewPager)this.findViewById(R.id.pager);
        ImagePagerAdapter mAdapter = new ImagePagerAdapter(this.getSupportFragmentManager(), this.urls);
        this.mPager.setAdapter((PagerAdapter)mAdapter);
        if (this.urls.size() != 0) {
            this.mImageBean = this.urls.size() >= this.pagerPosition ? this.urls.get(this.pagerPosition) : this.urls.get(0);
        }
        this.indicator = (TextView)this.findViewById(R.id.indicator);
        if (this.urls != null && this.urls.size() > 1) {
            String index = this.pagerPosition + 1 + "/" + this.urls.size();
            this.indicator.setText((CharSequence)index);
            this.indicator.setBackgroundResource(R.drawable.moments_bg_page_count);
        }
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrollStateChanged(int arg0) {
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageSelected(int position) {
                String index = position + 1 + "/" + GalleryActivity.this.urls.size();
                GalleryActivity.this.indicator.setText((CharSequence)index);
                GalleryActivity.this.pagerPosition = position;
                GalleryActivity.this.mImageBean = GalleryActivity.this.urls.get(position);
            }
        });
        GalleryActivityPermissionsDispatcher.gaintWriteExtPermissionForFile1WithPermissionCheck(this, this.pagerPosition);
        this.imageButton = (ImageButton)this.findViewById(R.id.ib_operate);
        this.imageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FileUtil.isLocalHasFile(GalleryActivity.this.mImageBean.getPath())) {
                    if (FileUtils.getFileSize((String)FileUtil.getSavePath(GalleryActivity.this.mImageBean.getPath())) > 0L) {
                        GalleryActivity.this.showDialog();
                    } else {
                        Toast.makeText((Context)GalleryActivity.this, (CharSequence)"\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728", (int)0).show();
                    }
                }
            }
        });
        IntentFilter myIntentFilter = new IntentFilter();
        myIntentFilter.addAction(IMAGE_LOADING_SUCCESS);
        myIntentFilter.addAction(IMAGE_LONGCLICK);
        this.registerReceiver(this.imageLoadingReceiver, myIntentFilter);
    }

    protected void initView() {
    }

    protected int getRootView() {
        this.getWindow().setFlags(1024, 1024);
        return R.layout.moments_activity_gallery;
    }

    protected void onDestroy() {
        this.unregisterReceiver(this.imageLoadingReceiver);
        super.onDestroy();
    }

    public void showDialog() {
        CharSequence[] items = this.getResources().getStringArray(R.array.moments_gallery_operate);
        AlertDialog dlg = new AlertDialog.Builder((Context)this).setItems(items, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case 0: {
                        dialog.dismiss();
                        GalleryActivityPermissionsDispatcher.gaintWriteExtPermissionForFileWithPermissionCheck(GalleryActivity.this, true);
                        break;
                    }
                    case 1: {
                        dialog.dismiss();
                        GalleryActivityPermissionsDispatcher.gaintWriteExtPermissionForFileWithPermissionCheck(GalleryActivity.this, false);
                    }
                }
            }
        }).create();
        dlg.show();
    }

    private void forwardPic() {
        if (FileUtil.isLocalHasFile(this.mImageBean.getPath())) {
            Navigation.shareFileTo(FileUtil.getSavePath(this.mImageBean.getPath()));
        } else {
            this.showToast(this.getString(R.string.moments_file_not_exit));
        }
    }

    private void savePic() {
        FileUtils.makeDirs((String)MomentsConstants.PICTURE_FOLDER);
        String destFilePath = FileUtil.getSavePath(this.mImageBean.getPath());
        if (FileUtils.isFileExist((String)destFilePath)) {
            this.showToast("\u5df2\u4fdd\u5b58\u5728" + MomentsConstants.PICTURE_FOLDER + "\u6587\u4ef6\u5939\u4e0b\uff01");
            File destFile = new File(destFilePath);
            Uri uri = Uri.fromFile((File)destFile);
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri);
            this.sendBroadcast(intent);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(STATE_POSITION, this.mPager.getCurrentItem());
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        GalleryActivityPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    @NeedsPermission(value={"android.permission.WRITE_EXTERNAL_STORAGE"})
    void gaintWriteExtPermissionForFile(boolean isTransf) {
        if (isTransf) {
            this.forwardPic();
        } else {
            this.savePic();
        }
    }

    @NeedsPermission(value={"android.permission.WRITE_EXTERNAL_STORAGE"})
    void gaintWriteExtPermissionForFile1(int postion) {
        this.mPager.setCurrentItem(postion);
    }

    @OnNeverAskAgain(value={"android.permission.WRITE_EXTERNAL_STORAGE"})
    void onWriteExtNeverAskAgain() {
        this.showPermissionDeniedDialog(R.string.moments_permission_setting);
    }

    protected void showPermissionDeniedDialog(@StringRes int messageResId) {
        this.showAlertDialog("\u53d6\u6d88", "\u786e\u5b9a", this.getResources().getString(messageResId), new View.OnClickListener(){

            public void onClick(View v) {
                GalleryActivity.this.dismissAlertDialog();
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                GalleryActivity.this.dismissAlertDialog();
                Intent intent = new Intent();
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.setData(Uri.fromParts((String)"package", (String)GalleryActivity.this.getPackageName(), null));
                GalleryActivity.this.startActivity(intent);
            }
        }, false, false);
    }

    private class ImagePagerAdapter
    extends FragmentStatePagerAdapter {
        public ArrayList<ImageBean> fileList;
        public SparseArray<Fragment> fragments;

        public ImagePagerAdapter(FragmentManager fm, ArrayList<ImageBean> fileList) {
            super(fm);
            this.fileList = fileList;
            this.fragments = new SparseArray();
        }

        public int getCount() {
            return this.fileList == null ? 0 : this.fileList.size();
        }

        public Fragment getItem(int position) {
            if (this.fragments.get(position) == null) {
                ImageBean imageBean = this.fileList.get(position);
                this.fragments.put(position, (Object)ImageDetailFragment.newInstance(imageBean));
            }
            return (Fragment)this.fragments.get(position);
        }
    }
}

