/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.gallery.fragment;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.orhanobut.logger.Logger;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseFragment;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.flow.detail.gallery.fragment.ImageFileTypeUtil;
import com.xdja.moments.sdk.http.download.DownLoadListener.HttpDownOnNextListener;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownManager;
import com.xdja.moments.sdk.repository.DownInfoRepository;
import com.xdja.moments.sdk.utils.FileProviderUtils;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.widget.CircleProgressBar;
import com.xdja.moments.sdk.widget.photoview.PhotoView;
import com.xdja.moments.sdk.widget.subscaleview.ImageSource;
import com.xdja.moments.sdk.widget.subscaleview.SubsamplingScaleImageView;
import io.reactivex.FlowableTransformer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifImageView;

public class ImageDetailFragment
extends BaseFragment
implements View.OnClickListener,
View.OnLongClickListener {
    public static final String IMAGE_PATTERN = "fileId=(.*)?\\$(\\d{1,9})\\*(\\d{1,9})\\$(.*)?";
    private ImageBean mImageBean;
    private SubsamplingScaleImageView mImageView;
    private ImageView imgVideo;
    private GifImageView mGifView;
    private CircleProgressBar progressBar;
    private Handler hanler;
    private Runnable runnable;
    private GifDrawable gifDrawable;
    private String fileExt;
    private HttpDownManager downloadManager;
    private DownInfo downloadInfo;
    private static final String[] pics = new String[]{"jpg", "png", "bmp", "jpeg", "gif", "mp4", "3gp"};
    private boolean isLocal;

    public static ImageDetailFragment newInstance(ImageBean imageUrl) {
        ImageDetailFragment f = new ImageDetailFragment();
        Bundle args = new Bundle();
        args.putSerializable("url", (Serializable)imageUrl);
        Logger.e((String)("imgUrl:" + imageUrl.getPath() + ""), (Object[])new Object[0]);
        f.setArguments(args);
        return f;
    }

    protected int getRootView() {
        return R.layout.moments_fragment_gallery_item;
    }

    protected void initView(View v, LayoutInflater inflater) {
        v.setOnClickListener((View.OnClickListener)this);
        this.mImageView = (SubsamplingScaleImageView)v.findViewById(R.id.image);
        this.imgVideo = (ImageView)v.findViewById(R.id.img_video);
        this.mGifView = (GifImageView)v.findViewById(R.id.gif);
        this.mImageView.setOnClickListener(this);
        this.mImageView.setOnLongClickListener(this);
        this.mGifView.setOnClickListener((View.OnClickListener)this);
        this.mGifView.setOnLongClickListener((View.OnLongClickListener)this);
        this.imgVideo.setOnClickListener((View.OnClickListener)this);
        this.progressBar = (CircleProgressBar)v.findViewById(R.id.pb_loading);
        this.progressBar.setMaxProgress(100);
        this.mImageView.setTouchDelegate(new PhotoView(this.getContext()).getTouchDelegate());
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        Logger.d((Object)"onActivityCreated");
        this.mImageBean = this.getArguments() != null ? (ImageBean)this.getArguments().getSerializable("url") : null;
        this.downloadManager = HttpDownManager.getInstance();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        boolean isGif;
        super.onActivityCreated(savedInstanceState);
        this.hanler = new Handler();
        if (TextUtils.isEmpty((CharSequence)this.mImageBean.getPath())) {
            return;
        }
        this.fileExt = FileUtil.getFileExtension(this.mImageBean.getPath());
        this.isLocal = FileUtil.isLocalHasFile(this.mImageBean.getPath());
        boolean bl = isGif = this.mImageBean.getPath().toLowerCase(Locale.getDefault()).endsWith("gif") || ImageFileTypeUtil.getImageType(this.mImageBean.getPath()).endsWith("GIF");
        if (!isGif) {
            if (this.isLocal) {
                this.mImageView.setVisibility(0);
                String localFilePaht = FileUtil.getSavePath(this.mImageBean.getPath());
                if (FileUtil.getFileSize(localFilePaht) > 0L) {
                    this.mImageView.setImage(ImageSource.uri(localFilePaht));
                } else {
                    this.mImageView.setImage(ImageSource.resource(R.drawable.moments_img_pic_default));
                }
            } else {
                this.showPlaceHolder();
                this.downloadImage();
            }
        } else {
            this.showPlaceHolder();
            if (this.isLocal) {
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImageDetailFragment.this.gifDrawable = new GifDrawable(ImageDetailFragment.this.mImageBean.getPath());
                            ImageDetailFragment.this.resetLayoutParams((View)ImageDetailFragment.this.mGifView);
                            ImageDetailFragment.this.mGifView.setImageDrawable((Drawable)ImageDetailFragment.this.gifDrawable);
                            ImageDetailFragment.this.sendBroadCast();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.hanler.postDelayed(this.runnable, 1000L);
            } else {
                this.downloadImage();
            }
        }
    }

    private void downloadImage() {
        Disposable disposable = DownInfoRepository.getInstance().getDownloadInfoByFileId(FileUtil.getFastdfsFileId(this.mImageBean.getPath())).compose((FlowableTransformer)this.provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe((Consumer)new Consumer<DownInfo>(){

            public void accept(DownInfo downInfo) throws Exception {
                ImageDetailFragment.this.downloadInfo = downInfo;
                ImageDetailFragment.this.downloadFile();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                ImageDetailFragment.this.showToast(throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    private void downloadFile() {
        try {
            if (this.downloadInfo != null) {
                this.progressBar.setMaxProgress(100);
                this.downloadInfo.setUpdateProgress(true);
                this.downloadInfo.setListener(new HttpDownOnNextListener(){

                    public void onNext(Object o) {
                    }

                    @Override
                    public void onStart() {
                        ImageDetailFragment.this.progressBar.setVisibility(0);
                    }

                    @Override
                    public void onComplete() {
                        ImageDetailFragment.this.refresh();
                    }

                    @Override
                    public void updateProgress(long readLength, long countLength) {
                        Logger.i((String)("readLength:" + readLength + " countLength:" + countLength), (Object[])new Object[0]);
                        ImageDetailFragment.this.progressBar.setProgress((int)(readLength * 100L / countLength));
                        ImageDetailFragment.this.refresh();
                    }
                });
                this.downloadManager.startDown(this.downloadInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDestroy() {
        if (this.hanler != null & this.runnable != null) {
            this.hanler.removeCallbacks(this.runnable);
        }
        if (this.gifDrawable != null) {
            this.gifDrawable.recycle();
        }
        if (this.mImageView != null) {
            this.mImageView.recycle();
        }
        super.onDestroy();
    }

    private void showPlaceHolder() {
        Glide.with((FragmentActivity)this.getActivity()).load(this.mImageBean.getPath()).asBitmap().error(R.drawable.moments_img_pic_default).into((ImageView)this.mGifView);
    }

    private void resetLayoutParams(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        view.setLayoutParams(layoutParams);
    }

    public void refresh() {
        if (this.progressBar != null && this.getActivity() != null) {
            this.progressBar.setVisibility(0);
            if (this.downloadInfo.getCountLength() > 0L) {
                this.progressBar.setProgress((int)(this.downloadInfo.getReadLength() * 100L / this.downloadInfo.getCountLength()));
            } else {
                this.progressBar.setProgress(0);
            }
            DownState state = this.downloadInfo.getState();
            switch (state) {
                case FINISH: {
                    this.progressBar.setVisibility(8);
                    if (!TextUtils.isEmpty((CharSequence)this.fileExt) && (this.fileExt.toLowerCase().equals("gif") || ImageFileTypeUtil.getImageType(this.mImageBean.getPath()).endsWith("GIF"))) {
                        try {
                            this.gifDrawable = new GifDrawable(this.mImageBean.getPath());
                            this.resetLayoutParams((View)this.mGifView);
                            this.mGifView.setImageDrawable((Drawable)this.gifDrawable);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.mGifView.setVisibility(8);
                        this.mImageView.setVisibility(0);
                        if (new File(this.downloadInfo.getSavePath()).length() > 0L) {
                            this.mImageView.setImage(ImageSource.uri(this.downloadInfo.getSavePath()));
                        } else {
                            this.mImageView.setImage(ImageSource.resource(R.drawable.moments_img_pic_default));
                        }
                    }
                    this.sendBroadCast();
                    break;
                }
                case ERROR: {
                    this.mImageView.setImage(ImageSource.resource(R.drawable.moments_img_download_fail));
                    break;
                }
            }
        }
    }

    private void play() {
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            intent.setAction("android.intent.action.VIEW");
            File file = new File(this.mImageBean.getPath());
            FileProviderUtils.setIntentDataAndType((Context)this.getActivity(), intent, "video/mp4", file, true);
            this.startActivity(intent);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.img_video) {
            this.play();
        } else if (this.getActivity() != null) {
            this.getActivity().finish();
        }
    }

    public boolean onLongClick(View v) {
        if (!FileUtil.isFileExist(FileUtil.getSavePath(this.mImageBean.getPath()))) {
            return true;
        }
        if (FileUtil.getFileSize(FileUtil.getSavePath(this.mImageBean.getPath())) <= 0L) {
            return true;
        }
        Intent mIntent = new Intent();
        mIntent.setAction("com.xdja.jxclient.boardcast.imagelongclick");
        this.getContext().sendBroadcast(mIntent);
        return false;
    }

    private void sendBroadCast() {
        Intent mIntent = new Intent();
        mIntent.setAction("com.xdja.jxclient.boardcast.imageloading");
        this.getContext().sendBroadcast(mIntent);
    }

    private static boolean contain(String fileExt, String[] fileExts) {
        String lowerCaseFileExt = fileExt.toLowerCase();
        for (String fileExt1 : fileExts) {
            if (!fileExt1.equals(lowerCaseFileExt)) continue;
            return true;
        }
        return false;
    }
}

