/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.mvp;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.text.TextUtils;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseObserver;
import com.xdja.baselibrary.base.BasePageResponse;
import com.xdja.baselibrary.base.BasePresenter;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.exception.MomentsBaseException;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.FileBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.bean.VideoBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.eventbus.MomentDetailEvent;
import com.xdja.moments.sdk.flow.detail.business.MomentDetailBusiness;
import com.xdja.moments.sdk.flow.detail.business.imp.MomentDetailBusinessImp;
import com.xdja.moments.sdk.flow.detail.mvp.MomentDetailConstruct;
import com.xdja.moments.sdk.flow.detail.mvp.MomentsSaveCommentModel;
import com.xdja.moments.sdk.flow.main.mvp.DeleteCommentModel;
import com.xdja.moments.sdk.flow.main.mvp.MomentsHideModel;
import com.xdja.moments.sdk.flow.main.mvp.MomentsPraiseModel;
import com.xdja.moments.sdk.flow.review.mvp.MomentsDeleteModel;
import com.xdja.moments.sdk.http.bean.request.DeleteCommentParams;
import com.xdja.moments.sdk.http.bean.request.MomentDeleteParams;
import com.xdja.moments.sdk.http.bean.request.MomentHideParams;
import com.xdja.moments.sdk.http.bean.request.MomentPraiseParams;
import com.xdja.moments.sdk.http.bean.request.MomentsSaveComment;
import com.xdja.moments.sdk.http.bean.response.DeleteCommentResponseBean;
import com.xdja.moments.sdk.http.bean.response.PraiseResponseBean;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.utils.DateUtil;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class MomentDetailPresenter
extends BasePresenter
implements MomentDetailConstruct.Presenter {
    private MomentDetailConstruct.View view;
    private MomentDetailBusiness business;
    private MomentsConfig momentsConfig;
    private MomentsDeleteModel deleteModel;
    private MomentsHideModel hideModel;
    private MomentsPraiseModel praiseModel;
    private MomentsSaveCommentModel saveCommentModel;
    private DeleteCommentModel deleteCommentModel;
    private String momentsId;
    private MomentsBean momentsBean;
    private UserInfoBean userInfoBean;
    private String praiseFlag = "2";
    private long timeStamp = 0L;
    private String toUserId;
    private List<BottomMenuBean> bottomMenuBeanList;
    private BottomMenuBean transmitMenuBean;
    private BottomMenuBean deleteMenuBean;
    private BottomMenuBean hideMenuBean;
    private boolean isMomentsOwner;
    private boolean hasPraisePower;
    private boolean hasCommentPower;
    private boolean isRuningAnimation;
    private PraiseResponseBean responseBean;

    public MomentDetailPresenter(MomentDetailConstruct.View view, LifecycleProvider<Lifecycle.Event> provider) {
        super(provider);
        this.view = view;
        this.business = new MomentDetailBusinessImp((LifecycleProvider)provider);
        this.deleteModel = new MomentsDeleteModel();
        this.hideModel = new MomentsHideModel();
        this.praiseModel = new MomentsPraiseModel();
        this.saveCommentModel = new MomentsSaveCommentModel();
        this.deleteCommentModel = new DeleteCommentModel();
        this.momentsConfig = new MomentsConfig();
        this.bottomMenuBeanList = new ArrayList<BottomMenuBean>();
    }

    @Override
    public void getMomentDetail(String momentsId, boolean isShowLoading) {
        this.momentsId = momentsId;
        this.business.getMomentDetailFromNet(momentsId).compose(ObservableTransfor.io_main()).subscribe((Observer)new DetailObserver<MomentsBean>((IBaseView)this.view, isShowLoading){

            public void onNext(MomentsBean momentsBean) {
                super.onNext((Object)momentsBean);
                MomentDetailPresenter.this.momentsBean = momentsBean;
                MomentDetailPresenter.this.fillMomentsView(momentsBean);
            }
        });
    }

    private void fillMomentsView(MomentsBean momentsBean) {
        if (momentsBean == null) {
            return;
        }
        this.userInfoBean = momentsBean.getUserInfo();
        this.praiseFlag = momentsBean.getPraiseFlag();
        this.view.setHeaderView(momentsBean);
        this.isMomentsOwner = TextUtils.equals((CharSequence)momentsBean.getUserInfo().getUserId(), (CharSequence)MomentsManager.getInstance().getLoginer().getUserId());
        if (!this.isMomentsOwner && this.hideMenuBean == null) {
            this.hideMenuBean = new BottomMenuBean(R.drawable.moments_icon_hide, ((Context)this.view).getString(R.string.moments_bottom_menu_hide));
        } else if (this.isMomentsOwner && this.deleteMenuBean == null) {
            this.deleteMenuBean = new BottomMenuBean(R.drawable.moments_icon_delete, ((Context)this.view).getString(R.string.moments_bottom_menu_delete));
        }
        if (this.hideMenuBean != null && !this.bottomMenuBeanList.contains(this.hideMenuBean)) {
            this.bottomMenuBeanList.add(this.hideMenuBean);
        }
        if (this.deleteMenuBean != null && !this.bottomMenuBeanList.contains(this.deleteMenuBean)) {
            this.bottomMenuBeanList.add(this.deleteMenuBean);
        }
        this.view.setBottomMenuList(this.bottomMenuBeanList);
        UserInfoBean userInfoBean = momentsBean.getUserInfo();
        if (userInfoBean != null) {
            this.view.setPublishUserName(userInfoBean.getUserName());
            this.view.setPublishUserAvatar(userInfoBean.getUserAvatar());
            this.view.setPublishTime(DateUtil.getTimeStringFromNow(momentsBean.getCreateTime()));
            this.view.setPublishDept(userInfoBean.getDeptName());
        }
        if (!TextUtils.isEmpty((CharSequence)momentsBean.getMomentContent())) {
            this.view.setTextContent(momentsBean.getMomentContent());
        }
        List<UserInfoBean> atInfoList = momentsBean.getAtInfoList();
        this.view.setAtView(atInfoList);
        switch (momentsBean.getMomentType()) {
            case 2: {
                this.view.setPictureView(momentsBean.getImageBeans());
                break;
            }
            case 3: {
                ImageBean imageBean = momentsBean.getImageBeans().get(0);
                this.view.setVideoView(momentsBean.getMomentFilePath(), imageBean);
                break;
            }
            case 4: {
                this.view.setFileView(momentsBean.getMomentFileName(), momentsBean.getMomentFileType());
                break;
            }
            case 5: {
                this.view.setLinkView(momentsBean.getMomentShareUrl(), momentsBean.getMomentShareContent(), momentsBean.getMomentSharePicture());
            }
        }
        this.view.setLocation(momentsBean.getAddress());
        this.view.setCommentNum(momentsBean.getCommentCount());
        this.view.setPraiseNum(momentsBean.getPraiseCount());
        this.view.setPraiseState(momentsBean.getPraiseFlag());
        List<UserInfoBean> praiseList = momentsBean.getPraiseList();
        this.view.setPraiseDetail(praiseList, momentsBean.getPraiseCount(), "2".equals(this.momentsConfig.getSwitchShowPraiseWay()));
        List<CommentBean> commentList = momentsBean.getCommentList();
        this.view.onRefreshSucess(commentList, momentsBean.isCommentIsLastPage());
        if (!ListUtil.isEmpty(commentList)) {
            this.timeStamp = commentList.get(commentList.size() - 1).getCreateTime();
        }
    }

    @Override
    public void onMomentsPowerChanged(MomentsClassify momentsPower) {
        if (momentsPower == null) {
            return;
        }
        if (!TextUtils.equals((CharSequence)momentsPower.getLookMomentPower(), (CharSequence)"1")) {
            this.view.showToast("\u6ca1\u6709\u67e5\u770b\u6743\u9650");
            this.view.finish();
        }
        if (TextUtils.equals((CharSequence)momentsPower.getPraiseMomentPower(), (CharSequence)"1")) {
            this.hasPraisePower = true;
            this.view.showPraiseView(true);
        } else {
            this.hasPraisePower = false;
            this.view.showPraiseView(false);
        }
        if (TextUtils.equals((CharSequence)momentsPower.getCommentMomentPower(), (CharSequence)"1")) {
            this.hasCommentPower = true;
            this.view.showInputCommentView(true);
        } else {
            this.hasCommentPower = false;
            this.view.showInputCommentView(false);
        }
    }

    @Override
    public void onMomentsConfigChanged(MomentsConfig momentsConfig) {
        this.momentsConfig = momentsConfig;
        if (momentsConfig != null && "on".equals(momentsConfig.getSwitchForwardMoment())) {
            if (this.transmitMenuBean == null) {
                this.transmitMenuBean = new BottomMenuBean(R.drawable.moments_icon_tran, ((Context)this.view).getString(R.string.moments_bottom_menu_transmit));
            }
            if (!this.bottomMenuBeanList.contains(this.transmitMenuBean)) {
                this.bottomMenuBeanList.add(this.transmitMenuBean);
            }
        } else if (this.bottomMenuBeanList.contains(this.transmitMenuBean)) {
            this.bottomMenuBeanList.remove(this.transmitMenuBean);
        }
        this.view.setBottomMenuList(this.bottomMenuBeanList);
        this.view.setPraiseDetail(this.momentsBean.getPraiseList(), this.momentsBean.getPraiseCount(), "2".equals(momentsConfig.getSwitchShowPraiseWay()));
    }

    @Override
    public void onClickComments(CommentBean commentBean) {
        if (!TextUtils.equals((CharSequence)commentBean.getUserInfo().getUserId(), (CharSequence)MomentsManager.getInstance().getLoginer().getUserId())) {
            this.view.setCommentHint("\u56de\u590d " + commentBean.getUserInfo().getUserName());
            this.toUserId = commentBean.getUserInfo().getUserId();
            this.view.showKeyBoard(true);
        } else {
            this.view.setCommentHint(((Context)this.view).getString(R.string.moments_write_comment));
            this.toUserId = "";
            this.view.showKeyBoard(false);
        }
    }

    @Override
    public void onClickCommentsOutSide() {
        if (TextUtils.isEmpty((CharSequence)this.view.getCommentInputText())) {
            this.view.setCommentHint(((Context)this.view).getString(R.string.moments_write_comment));
            this.toUserId = "";
            this.view.showKeyBoard(false);
        }
    }

    @Override
    public void onLocationClick() {
        Navigation.navigationLocationDetailActivity((Activity)this.view, this.momentsBean.getAddress(), this.momentsBean.getAddressDetail(), Double.parseDouble(this.momentsBean.getLongitude()), Double.parseDouble(this.momentsBean.getLatitude()));
    }

    @Override
    public void onFileViewClick() {
        switch (this.momentsBean.getMomentType()) {
            case 4: {
                FileBean fileBean = new FileBean();
                fileBean.setDownLoadUrl(this.momentsBean.getMomentFilePath());
                fileBean.setFileExt(this.momentsBean.getMomentFileType());
                fileBean.setFileName(this.momentsBean.getMomentFileName());
                fileBean.setFileSize(this.momentsBean.getMomentFileSize());
                Navigation.navigationFileDetail(fileBean);
                break;
            }
            case 5: {
                Navigation.navigationUrlDetailActivity((Activity)this.view, this.momentsBean.getMomentShareContent(), this.momentsBean.getMomentShareUrl());
            }
        }
    }

    @Override
    public void onClickPraise() {
        if (!this.hasPraisePower) {
            this.view.showToast("\u6ca1\u6709\u70b9\u8d5e\u6743\u9650");
            this.view.showPraiseView(false);
            return;
        }
        this.startPraiseAnimation();
        MomentPraiseParams praiseParams = new MomentPraiseParams();
        praiseParams.setMomentId(this.momentsId);
        praiseParams.setPraiseFlag(TextUtils.equals((CharSequence)"1", (CharSequence)this.praiseFlag) ? "2" : "1");
        this.view.setLoadingType(LoadingType.LOAD_TYPE_NONE);
        this.praiseModel.praiseMoments(praiseParams).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.getProvider(), praiseParams)).subscribe((Observer)new DetailObserver<PraiseResponseBean>((IBaseView)this.view, "\u52a0\u8f7d\u4e2d..."){

            public void onNext(PraiseResponseBean o) {
                super.onNext((Object)o);
                MomentDetailPresenter.this.responseBean = o;
                if (!MomentDetailPresenter.this.isRuningAnimation) {
                    MomentDetailPresenter.this.updatePraiseResult();
                }
            }
        });
    }

    private void updatePraiseResult() {
        if (this.responseBean == null) {
            return;
        }
        EventBus.getDefault().post((Object)new MomentDetailEvent(MomentDetailEvent.TYPE_PARISE, this.momentsBean.getClassifyId(), this.momentsBean.getMomentId()));
        this.praiseFlag = this.responseBean.getPraiseFlag();
        this.momentsBean.setPraiseFlag(this.praiseFlag);
        List<UserInfoBean> list = this.momentsBean.getPraiseList();
        if (TextUtils.equals((CharSequence)"1", (CharSequence)this.responseBean.getPraiseFlag())) {
            if (list.add(MomentsManager.getInstance().getLoginer())) {
                this.momentsBean.setPraiseCount(this.momentsBean.getPraiseCount() + 1);
            }
        } else if (list.remove(MomentsManager.getInstance().getLoginer())) {
            this.momentsBean.setPraiseCount(this.momentsBean.getPraiseCount() - 1);
        }
        this.view.setPraiseState(this.praiseFlag);
        this.view.setPraiseNum(this.momentsBean.getPraiseCount());
        this.view.setPraiseDetail(list, this.momentsBean.getPraiseCount(), "2".equals(this.momentsConfig.getSwitchShowPraiseWay()));
        this.view.onRefreshSucess(this.momentsBean.getCommentList(), this.momentsBean.isCommentIsLastPage());
        this.responseBean = null;
    }

    private void startPraiseAnimation() {
        Animation animation = AnimationUtils.loadAnimation((Context)((Context)this.view), (int)R.anim.moments_praise_scale);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MomentDetailPresenter.this.isRuningAnimation = true;
            }

            public void onAnimationEnd(Animation animation) {
                MomentDetailPresenter.this.isRuningAnimation = false;
                MomentDetailPresenter.this.updatePraiseResult();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.view.startPraiseAnimation(animation);
    }

    @Override
    public void onClickTransmit() {
        if (this.momentsBean != null) {
            Navigation.shareMomentTo(this.momentsBean);
        }
    }

    @Override
    public void onClickHideMoment() {
        MomentHideParams params = new MomentHideParams();
        params.setMomentId(this.momentsId);
        this.view.setLoadingType(LoadingType.LOAD_TYPE_DIALOG);
        this.hideModel.hideMoments(params).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.getProvider(), params)).subscribe((Observer)new DetailObserver<Object>((IBaseView)this.view, "\u9690\u85cf\u4e2d..."){

            public void onNext(Object o) {
                super.onNext(o);
                EventBus.getDefault().post((Object)new MomentDetailEvent(MomentDetailEvent.TYPE_HIDE, MomentDetailPresenter.this.momentsBean.getClassifyId(), MomentDetailPresenter.this.momentsBean.getMomentId()));
                MomentDetailPresenter.this.view.showToast("\u9690\u85cf\u6210\u529f");
                MomentDetailPresenter.this.view.finish();
            }
        });
    }

    @Override
    public void onClickDeleteMoment() {
        MomentDeleteParams params = new MomentDeleteParams();
        params.setMomentId(this.momentsId);
        this.view.setLoadingType(LoadingType.LOAD_TYPE_DIALOG);
        this.deleteModel.deleteMoments(params).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.getProvider(), params)).subscribe((Observer)new DetailObserver<Object>((IBaseView)this.view, "\u5220\u9664\u4e2d..."){

            public void onNext(Object o) {
                super.onNext(o);
                EventBus.getDefault().post((Object)new MomentDetailEvent(MomentDetailEvent.TYPE_DELETE, MomentDetailPresenter.this.momentsBean.getClassifyId(), MomentDetailPresenter.this.momentsBean.getMomentId()));
                MomentDetailPresenter.this.view.showToast("\u5220\u9664\u6210\u529f");
                MomentDetailPresenter.this.view.finish();
            }
        });
    }

    @Override
    public void onCommentLongClick(CommentBean commentBean) {
        if (commentBean == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)commentBean.getUserInfo().getUserId(), (CharSequence)MomentsManager.getInstance().getLoginer().getUserId())) {
            this.view.showCopyAndDeleteDialog(commentBean);
        } else {
            this.view.showCopyDialog(commentBean.getCommentContent());
        }
    }

    @Override
    public void onClickDeleteComment(final CommentBean commentBean) {
        DeleteCommentParams params = new DeleteCommentParams();
        params.setCommentId(commentBean.getCommentId());
        this.view.setLoadingType(LoadingType.LOAD_TYPE_DIALOG);
        this.deleteCommentModel.deleteComment(params).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.getProvider(), params)).subscribe((Observer)new DetailObserver<DeleteCommentResponseBean>((IBaseView)this.view, "\u5220\u9664\u4e2d..."){

            public void onNext(DeleteCommentResponseBean o) {
                super.onNext((Object)o);
                EventBus.getDefault().post((Object)new MomentDetailEvent(MomentDetailEvent.TYPE_COMMENT, MomentDetailPresenter.this.momentsBean.getClassifyId(), MomentDetailPresenter.this.momentsBean.getMomentId()));
                MomentDetailPresenter.this.view.showToast("\u5220\u9664\u6210\u529f");
                MomentDetailPresenter.this.view.removeComment(commentBean);
                MomentDetailPresenter.this.momentsBean.setCommentCount(MomentDetailPresenter.this.momentsBean.getCommentCount() - 1);
                MomentDetailPresenter.this.view.setCommentNum(MomentDetailPresenter.this.momentsBean.getCommentCount());
                MomentDetailPresenter.this.momentsBean.getCommentList().remove(commentBean);
                MomentDetailPresenter.this.view.onRefreshSucess(MomentDetailPresenter.this.momentsBean.getCommentList(), MomentDetailPresenter.this.momentsBean.isCommentIsLastPage());
            }
        });
    }

    @Override
    public void onMemberClick(UserInfoBean userInfoBean) {
        Navigation.navigationPersonDetail((Context)this.view, userInfoBean.getUserId());
    }

    @Override
    public void onLoadMore() {
        this.business.getCommentDetailFromNet(this.momentsId, this.timeStamp).compose((ObservableTransformer)this.getProvider().bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe((Observer)new DetailObserver<BasePageResponse<List<CommentBean>>>((IBaseView)this.view, false){

            public void onNext(BasePageResponse<List<CommentBean>> listBasePageResponse) {
                super.onNext(listBasePageResponse);
                if (MomentDetailPresenter.this.timeStamp == 0L && !ListUtil.isEmpty((List)((List)listBasePageResponse.getData()))) {
                    MomentDetailPresenter.this.momentsBean.setCommentList((List)listBasePageResponse.getData());
                }
                MomentDetailPresenter.this.view.setLoadingType(LoadingType.LOAD_TYPE_NONE);
                MomentDetailPresenter.this.timeStamp = listBasePageResponse.getTimeStamp();
                MomentDetailPresenter.this.view.onLoadMoreSuccess((List)listBasePageResponse.getData(), TextUtils.equals((CharSequence)listBasePageResponse.getPageNum(), (CharSequence)"1"));
            }

            @Override
            protected void onError(MomentsBaseException ex) {
                MomentDetailPresenter.this.view.onLoadMoreFail();
                MomentDetailPresenter.this.view.showToast(ex.errorMessage);
                switch (ex.code) {
                    case 20003: {
                        MomentDetailPresenter.this.view.finish();
                    }
                }
            }
        });
    }

    @Override
    public void onClickSendComment(String content) {
        if (!this.hasCommentPower) {
            this.view.showToast("\u6ca1\u6709\u8bc4\u8bba\u6743\u9650");
            this.view.showInputCommentView(false);
            return;
        }
        MomentsSaveComment comment = new MomentsSaveComment();
        comment.setCommentContent(content);
        comment.setMomentId(this.momentsId);
        if (!TextUtils.equals((CharSequence)this.toUserId, (CharSequence)MomentsManager.getInstance().getLoginer().getUserId())) {
            comment.setToUserId(this.toUserId);
        }
        this.view.setLoadingType(LoadingType.LOAD_TYPE_DIALOG);
        this.saveCommentModel.saveComment(comment).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.getProvider(), comment)).subscribe((Observer)new DetailObserver<Object>((IBaseView)this.view, "\u53d1\u8868\u8bc4\u8bba\u4e2d..."){

            public void onNext(Object o) {
                super.onNext(o);
                EventBus.getDefault().post((Object)new MomentDetailEvent(MomentDetailEvent.TYPE_COMMENT, MomentDetailPresenter.this.momentsBean.getClassifyId(), MomentDetailPresenter.this.momentsBean.getMomentId()));
                MomentDetailPresenter.this.view.showToast("\u8bc4\u8bba\u6210\u529f");
                MomentDetailPresenter.this.view.setCommentInputViewText("");
                MomentDetailPresenter.this.timeStamp = 0L;
                MomentDetailPresenter.this.momentsBean.setCommentCount(MomentDetailPresenter.this.momentsBean.getCommentCount() + 1);
                MomentDetailPresenter.this.view.setCommentNum(MomentDetailPresenter.this.momentsBean.getCommentCount());
                MomentDetailPresenter.this.onLoadMore();
            }
        });
    }

    @Override
    public void onClickPlayVideo(String videoPath) {
        VideoBean videoBean = new VideoBean();
        videoBean.setTitle(this.momentsBean.getMomentFileName());
        videoBean.setVideoDuration(Integer.parseInt(this.momentsBean.getMomentVideoTime()));
        videoBean.setVideoFileId(this.momentsBean.getMomentFilePath());
        if (!ListUtil.isEmpty(this.momentsBean.getImageBeans())) {
            videoBean.setVideoPrevPath(this.momentsBean.getImageBeans().get(0).getPath());
        }
        Navigation.navigationVideoDetailActivity(videoBean);
    }

    private class DetailObserver<T>
    extends BaseObserver<T> {
        public DetailObserver(IBaseView view, boolean showLoading) {
            super(view, showLoading);
        }

        public DetailObserver(IBaseView view, String loadingText) {
            super(view, loadingText);
        }

        protected void onError(MomentsBaseException ex) {
            if (this.showLoading) {
                MomentDetailPresenter.this.view.hideLoading("DEFAULT");
            } else {
                MomentDetailPresenter.this.view.onRefreshFail();
                MomentDetailPresenter.this.view.onLoadMoreFail();
            }
            if (MomentDetailPresenter.this.momentsBean != null) {
                MomentDetailPresenter.this.view.showToast(ex.errorMessage);
            } else {
                MomentDetailPresenter.this.view.showError(ex);
            }
            switch (ex.code) {
                case 20003: {
                    MomentDetailPresenter.this.view.finish();
                }
            }
        }
    }
}

