/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.url;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.util.SPUtils;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.utils.WebUtils;
import com.xdja.moments.sdk.widget.FontSizeView;
import java.util.ArrayList;
import java.util.List;

@Route(path="/detail/urlDetail")
public class UrlDetailActivity
extends BaseActivity
implements Toolbar.OnMenuItemClickListener,
FontSizeView.OnChangeCallbackListener {
    @Autowired(name="title")
    public String title;
    @Autowired(name="url")
    public String url;
    private static final String FONT_POSITION = "FONT_POSITION";
    private LinearLayout webLayout;
    private WebView mWebView;
    private FontSizeView fontSizeView;
    private RelativeLayout errorLayout;
    private ProgressBar mProgressbar;
    private List<BottomMenuBean> bottomMenuBeanList = new ArrayList<BottomMenuBean>();
    private int defaultPos = 1;
    private int[] textSizes = new int[]{75, 100, 150, 200, 250};
    private WebViewClient webViewClient = new WebViewClient(){

        public void onPageFinished(WebView view, String url) {
            UrlDetailActivity.this.mProgressbar.setVisibility(8);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            UrlDetailActivity.this.mProgressbar.setVisibility(0);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
    };
    private WebChromeClient webChromeClient = new WebChromeClient(){

        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);
            Log.i((String)"ansen", (String)("\u7f51\u9875\u6807\u9898:" + title));
        }

        public void onProgressChanged(WebView view, int newProgress) {
            UrlDetailActivity.this.mProgressbar.setProgress(newProgress);
        }
    };

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        this.defaultPos = (Integer)SPUtils.get((Context)this, (String)FONT_POSITION, (Object)1);
        this.fontSizeView.setDefaultPosition(this.defaultPos);
    }

    protected void preGetRootView(Bundle savedInstanceState) {
        ARouter.getInstance().inject((Object)this);
    }

    protected void initView() {
        this.setMomentsTitle(this.title);
        this.toolbar.setOnMenuItemClickListener((Toolbar.OnMenuItemClickListener)this);
        this.webLayout = (LinearLayout)this.findViewById(R.id.webLayout);
        this.mProgressbar = (ProgressBar)this.findViewById(R.id.progressbar);
        this.mWebView = (WebView)this.findViewById(R.id.webView);
        this.fontSizeView = (FontSizeView)this.findViewById(R.id.font_size);
        this.errorLayout = (RelativeLayout)this.findViewById(R.id.error_layout);
        this.fontSizeView.setChangeCallbackListener(this);
        this.mWebView.setOnTouchListener((view, motionEvent) -> {
            this.fontSizeView.setVisibility(8);
            return false;
        });
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setWebChromeClient(this.webChromeClient);
        this.mWebView.setWebViewClient(this.webViewClient);
        this.mWebView.loadUrl(this.url);
        this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_action_copy, this.getString(R.string.moments_copy_link)));
        this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_action_explorer, this.getString(R.string.moments_explorer)));
        this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_action_fontsetting, this.getString(R.string.moments_set_font_size)));
        this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_action_refresh, this.getString(R.string.moments_refresh)));
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_GIRD;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_url_detail, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    protected int getRootView() {
        return R.layout.moments_activity_url_detail;
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        this.showBottomMenu(this.bottomMenuBeanList);
        return false;
    }

    protected void onBottomMenuItemClick(int position) {
        this.hideBottomMenu();
        if (this.bottomMenuBeanList.get(position).getItemName().equals(this.getString(R.string.moments_copy_link))) {
            WebUtils.clipSimpleText((Context)this, this.url);
        } else if (this.bottomMenuBeanList.get(position).getItemName().equals(this.getString(R.string.moments_explorer))) {
            WebUtils.openWithExplorer((Context)this, this.url);
        } else if (this.bottomMenuBeanList.get(position).getItemName().equals(this.getString(R.string.moments_set_font_size))) {
            this.fontSizeView.setVisibility(0);
        } else if (this.bottomMenuBeanList.get(position).getItemName().equals(this.getString(R.string.moments_refresh))) {
            this.mWebView.reload();
        }
    }

    @Override
    public void onChangeListener(int position) {
        if (position != -1) {
            this.mWebView.getSettings().setTextZoom(this.textSizes[position]);
        } else {
            this.mWebView.getSettings().setTextZoom(this.textSizes[this.defaultPos]);
        }
        this.defaultPos = position;
        SPUtils.put((Context)this, (String)FONT_POSITION, (Object)this.defaultPos);
    }
}

