/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.init.business.impl;

import android.arch.lifecycle.Lifecycle;
import android.text.TextUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseParams;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.baselibrary.exception.ServerException;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.flow.init.business.MomentInitService;
import com.xdja.moments.sdk.flow.init.mvp.InitModel;
import com.xdja.moments.sdk.flow.login.mvp.LoginModel;
import com.xdja.moments.sdk.http.bean.request.LoginParams;
import com.xdja.moments.sdk.http.bean.response.LoginResponseBean;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.repository.MomentsClassifyRepository;
import com.xdja.moments.sdk.repository.MomentsConfigRepository;
import com.xdja.moments.sdk.repository.MomentsPowerRepository;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observable;
import java.util.List;

public class MomentInitServiceImpl
implements MomentInitService {
    private LoginModel loginModel;
    private InitModel initModel;
    private LifecycleProvider<Lifecycle.Event> provider;

    public MomentInitServiceImpl(LifecycleProvider<Lifecycle.Event> provider) {
        this.provider = provider;
        this.loginModel = new LoginModel();
        this.initModel = new InitModel();
    }

    public MomentInitServiceImpl() {
        this.loginModel = new LoginModel();
        this.initModel = new InitModel();
    }

    @Override
    public Observable<List<MomentsClassify>> init(LoginParams requestBean) {
        return this.loginModel.login(requestBean).flatMap(stringBaseResult -> {
            if (stringBaseResult == null || TextUtils.isEmpty((CharSequence)((LoginResponseBean)stringBaseResult.getData()).getAuthorization())) {
                throw new ServerException(2000, "\u83b7\u53d6\u6388\u6743\u5931\u8d25\u2026");
            }
            MomentsConstants.AUTHORIZATION = ((LoginResponseBean)stringBaseResult.getData()).getAuthorization();
            return this.initModel.init(new BaseParams());
        }).compose(this.provider == null ? MomentsRxTransformer.momentsComposeNoLife(requestBean) : MomentsRxTransformer.momentsCompose(this.provider, requestBean)).map(responseBean -> {
            if (responseBean == null || responseBean.getSystemConfig() == null || responseBean.getMomentPower() == null || responseBean.getClassifyList() == null || responseBean.getClassifyList().size() == 0) {
                throw new ServerException(2000, "\u83b7\u53d6\u914d\u7f6e\u6570\u636e\u5931\u8d25");
            }
            responseBean.getMomentPower().setUserId(MomentsManager.getInstance().getLoginer().getUserId());
            responseBean.getSystemConfig().setUserId(MomentsManager.getInstance().getLoginer().getUserId());
            MomentsConfigRepository momentsConfigRepository = new MomentsConfigRepository();
            momentsConfigRepository.clearAsync();
            momentsConfigRepository.insertAsync(responseBean.getSystemConfig());
            MomentsPowerRepository momentsPowerRepository = new MomentsPowerRepository();
            momentsPowerRepository.clearAsync();
            momentsPowerRepository.insertAsync(responseBean.getMomentPower());
            MomentsClassifyRepository momentsClassifyRepository = new MomentsClassifyRepository();
            momentsClassifyRepository.clearAsync();
            momentsClassifyRepository.insertAsync(responseBean.getClassifyList());
            return responseBean.getClassifyList();
        }).compose(ObservableTransfor.io_main());
    }
}

