/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.comment.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.TextView;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.XViewHolder;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MyCommentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MyCommentsAdapter
extends XRecyclerViewAdapter<MyCommentsBean> {
    private Drawable drawablePraise;
    private Activity activity;
    private List<MomentsClassify> momentsClassifyList;
    private MomentsConfig momentsConfig;
    private int imageSize;
    private FaceManager faceManager;
    private boolean longClick;

    public MyCommentsAdapter(@NonNull RecyclerView mRecyclerView, List<MyCommentsBean> dataLists, Activity context) {
        super(mRecyclerView, dataLists, R.layout.moments_comment_item);
        this.activity = context;
        this.drawablePraise = context.getResources().getDrawable(R.drawable.moments_receive_praise);
        this.drawablePraise.setBounds(0, 0, this.drawablePraise.getMinimumWidth(), this.drawablePraise.getMinimumHeight());
        this.imageSize = (int)context.getResources().getDimension(R.dimen.moments_60dp);
        this.faceManager = FaceManager.getInstance();
    }

    protected void bindData(XViewHolder holder, MyCommentsBean data, int position) {
        View.OnClickListener toPersonDetailAdapter = view -> Navigation.navigationPersonDetail((Context)this.activity, data.getUserInfo().getUserId());
        UserInfoBean userInfo = data.getUserInfo();
        holder.setImageUrl((Context)this.activity, R.id.iv_head_image, userInfo.getUserAvatar(), R.drawable.moments_person_default, true, true);
        holder.setVisible(R.id.iv_auxpolice_mark, userInfo.isAuxPolice());
        holder.setText(R.id.tv_topic_user_name, (CharSequence)(TextUtils.isEmpty((CharSequence)userInfo.getUserName()) ? "\u672a\u77e5\u7528\u6237" : userInfo.getUserName()));
        holder.setText(R.id.tv_comment_time, (CharSequence)data.getTimeString());
        holder.setOnClickListener(R.id.tv_topic_user_name, toPersonDetailAdapter);
        holder.setOnClickListener(R.id.iv_head_image, toPersonDetailAdapter);
        if (TextUtils.isEmpty((CharSequence)data.getIfComment()) || "1".equals(data.getIfComment())) {
            if ("1".equals(data.getCommentFlag()) || TextUtils.isEmpty((CharSequence)data.getCommentFlag())) {
                holder.setText(R.id.tv_comment_content, (CharSequence)"\u8be5\u8bc4\u8bba\u5df2\u5220\u9664");
                holder.setBackgroundColor(R.id.tv_comment_content, this.activity.getResources().getColor(R.color.moments_driver_line));
            } else {
                holder.setBackgroundColor(R.id.tv_comment_content, this.activity.getResources().getColor(R.color.moments_transparent));
                holder.setOnClickListener(R.id.tv_comment_content, v -> this.enterToDetail(data));
                TextView textView = (TextView)holder.getView(R.id.tv_comment_content);
                SpannableString spannableString = (SpannableString)this.faceManager.convertNormalStringToSpannableString((Context)this.activity, data.getCommentContent());
                if (spannableString != null) {
                    Pattern mentionsPattern = Pattern.compile("((http|https|rtsp)://)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|([A-Za-z0-9-_]+\\.)+([A-Za-z]{2,6}))(:[0-9]{1,5})?((/[\\S&&[^,;\\s]]+)+)?");
                    Matcher matcher = mentionsPattern.matcher((CharSequence)spannableString);
                    while (matcher.find()) {
                        MyUrlSpan myUrlSpan = new MyUrlSpan(matcher.group());
                        spannableString.setSpan((Object)myUrlSpan, matcher.start(), matcher.end(), 33);
                    }
                }
                textView.setAutoLinkMask(0);
                textView.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
                textView.setOnLongClickListener(arg0 -> {
                    this.longClick = true;
                    return true;
                });
            }
            holder.setCompoundDrawables(R.id.tv_comment_content, null, null, null, null);
        } else {
            holder.setText(R.id.tv_comment_content, (CharSequence)"");
            holder.setCompoundDrawables(R.id.tv_comment_content, null, null, null, this.drawablePraise);
        }
        List<ImageBean> momentPicturePath = data.getMomentPicturePath();
        String imageUrl = "";
        if (momentPicturePath.size() > 0) {
            imageUrl = MomentImageUtil.getThumbnail(momentPicturePath.get(0).getPath(), this.imageSize, this.imageSize);
        }
        switch (data.getMomentType()) {
            case 1: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, true);
                holder.setVisible(R.id.iv_moment_image, false);
                holder.setText(R.id.tv_moments_content, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getMomentContent()) ? "\u5de5\u4f5c\u5708\u5185\u5bb9" : data.getMomentContent()));
                break;
            }
            case 2: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, false);
                holder.setVisible(R.id.iv_moment_image, true);
                holder.setImageUrl((Context)this.activity, R.id.iv_moment_image, imageUrl, R.drawable.moments_img_pic_default, false);
                break;
            }
            case 3: {
                holder.setVisible(R.id.tv_moments_content, false);
                holder.setVisible(R.id.iv_video_play, true);
                holder.setVisible(R.id.iv_moment_image, true);
                holder.setImageUrl((Context)this.activity, R.id.iv_moment_image, imageUrl, R.drawable.moments_img_pic_default, false);
                break;
            }
            case 4: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, false);
                holder.setVisible(R.id.iv_moment_image, true);
                holder.setImageResource(R.id.iv_moment_image, FileUtil.getFileDrawable(data.getMomentFileType()));
                break;
            }
            case 5: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, true);
                holder.setVisible(R.id.iv_moment_image, false);
                holder.setText(R.id.tv_moments_content, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getMomentShareContent()) ? "\u5de5\u4f5c\u5708\u5185\u5bb9" : data.getMomentShareContent()));
                break;
            }
            default: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, true);
                holder.setVisible(R.id.iv_moment_image, false);
                holder.setText(R.id.tv_moments_content, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getMomentContent()) ? "\u5de5\u4f5c\u5708\u5185\u5bb9" : data.getMomentContent()));
            }
        }
        holder.itemView.setOnClickListener(v -> this.enterToDetail(data));
    }

    private void enterToDetail(MyCommentsBean data) {
        if (this.hasReadPower(data.getClassifyId()) && "2".equals(this.momentsConfig.getSwitchShowCommentWay())) {
            Navigation.navigationMomentDetail(data.getMomentId(), data.getCommentId());
        } else {
            Logger.d((Object)"\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u5de5\u4f5c\u5708");
        }
    }

    private boolean hasReadPower(String classifyId) {
        MomentsClassify myMomentsClassify = this.getClassIfyById(classifyId);
        if (myMomentsClassify == null) {
            return false;
        }
        return "1".equals(myMomentsClassify.getLookMomentPower());
    }

    private MomentsClassify getClassIfyById(String classifyId) {
        if (this.momentsClassifyList == null) {
            return null;
        }
        for (MomentsClassify classify : this.momentsClassifyList) {
            if (!classify.getClassifyId().equals(classifyId)) continue;
            return classify;
        }
        return null;
    }

    public void onClassifyPowerChanged(List<MomentsClassify> momentsClassifyList) {
        this.momentsClassifyList = momentsClassifyList;
        this.notifyDataSetChanged();
    }

    public void onMomentConfigChanged(MomentsConfig momentsConfig) {
        this.momentsConfig = momentsConfig;
        this.notifyDataSetChanged();
    }

    private class MyUrlSpan
    extends ClickableSpan {
        private String mUrl;

        MyUrlSpan(String url) {
            this.mUrl = url;
        }

        public void updateDrawState(TextPaint ds) {
            super.updateDrawState(ds);
            ds.setColor(-16743733);
            ds.setUnderlineText(false);
        }

        public void onClick(View widget) {
            if (MyCommentsAdapter.this.longClick) {
                MyCommentsAdapter.this.longClick = false;
                return;
            }
            Navigation.navigationUrlDetailActivity(MyCommentsAdapter.this.activity, "\u8be6\u60c5", this.mUrl);
            widget.clearFocus();
        }
    }
}

