/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.ui;

import android.arch.lifecycle.Lifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.eventbus.MomentDetailEvent;
import com.xdja.moments.sdk.flow.base.fragment.BaseMomentListFragment;
import com.xdja.moments.sdk.flow.base.moments.BaseMomentListPresenter;
import com.xdja.moments.sdk.flow.mine.mvp.MyMomentsListPresenter;
import com.xdja.moments.sdk.http.bean.request.BaseListParams;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class MyMomentsFragment
extends BaseMomentListFragment {
    private MyMomentsListPresenter presenter;
    private List<BottomMenuBean> bottomMenuBeanList = new ArrayList<BottomMenuBean>();

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.presenter == null) {
            this.presenter = new MyMomentsListPresenter(provider, this);
        }
        BaseListParams params = new BaseListParams();
        params.setTimeStamp(this.pageTimeStamp);
        this.presenter.getMomentsData(params);
    }

    @Override
    protected BaseMomentListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void onMoreArrowClick(MomentsBean data) {
        super.onMoreArrowClick(data);
        this.bottomMenuBeanList.clear();
        if (2 == this.currentOperatorMoment.getMomentVerifyStatus() && this.enableTransmit) {
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_tran, this.getString(R.string.moments_bottom_menu_transmit)));
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_delete, this.getString(R.string.moments_bottom_menu_delete)));
        } else {
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_delete, this.getString(R.string.moments_bottom_menu_delete)));
        }
        this.showBottomMenu(this.bottomMenuBeanList);
    }

    protected void onBottomMenuItemClick(BottomMenuBean menuBean) {
        this.hideBottomMenu();
        if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_transmit))) {
            Navigation.shareMomentTo(this.currentOperatorMoment);
        } else if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_delete))) {
            this.showAlertDialog("\u53d6\u6d88", "\u786e\u5b9a", this.getString(R.string.moments_delete_single_tip), v -> this.dismissAlertDialog(), v -> {
                this.dismissAlertDialog();
                this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
                this.presenter.deleteMoments(this.currentOperatorMoment.getMomentId());
            });
        }
    }

    @Override
    protected String getPageListRequestId() {
        return "momentInfo/queryMyMomentInfoList";
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshList(MomentDetailEvent event) {
        this.pageTimeStamp = 0L;
        this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
    }
}

