/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.baselibrary.util.GlideCircleTransform;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.flow.publish.PublishActivityPermissionsDispatcher;
import com.xdja.moments.sdk.flow.publish.enumm.BrowseAuthType;
import com.xdja.moments.sdk.flow.publish.mvp.PublishActivityConstruct;
import com.xdja.moments.sdk.flow.publish.mvp.PublishPresenter;
import com.xdja.moments.sdk.utils.EmojiUtil;
import com.xdja.moments.sdk.widget.faceview.FaceGridView;
import java.util.List;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.OnPermissionDenied;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
@Route(path="/publish/publishMoments")
public class PublishActivity
extends BaseActivity
implements PublishActivityConstruct.View,
View.OnClickListener {
    private View lyBrowseAuth;
    private View lyAddress;
    private View lyFile;
    private CheckBox cbEmoji;
    private EditText etContent;
    private TextView tvBrowseAuth;
    private TextView tvLocation;
    private TextView tvLocationDefault;
    private TextView tvType;
    private TextView tvFileName;
    private TextView tvContentNum;
    private LinearLayout mentionWhoLayout;
    private HorizontalScrollView horizontalScrollView;
    private ImageView ivFile;
    private ImageView ivPerson;
    private ImageView ivPicture;
    private ImageView ivFileIcon;
    private ImageView ivBrowseIcon;
    private ImageView ivDeleteLocation;
    private ImageView ivDeleteFile;
    private View atGroup;
    private FaceGridView faceGridView;
    private RecyclerView recyclerView;
    private PublishPresenter presenter;
    public static final String BROWSEAUTH_TYPE = "android.intent.bundle.BROWSEAUTH_TYPE";
    public static final String BROWSEAUTH_VALUE = "android.intent.bundle.BROWSEAUTH_VALUE";
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            PublishActivity.this.horizontalScrollView.smoothScrollBy(PublishActivity.this.horizontalScrollView.getScrollX() + 99, 0);
        }
    };

    protected int getRootView() {
        return R.layout.moments_activity_publish;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_publish, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_publish) {
            this.presenter.publishMomentsData();
        }
        return super.onOptionsItemSelected(item);
    }

    protected void initView() {
        this.setMomentsTitle(this.getString(R.string.moments_publish_moments));
        this.etContent = (EditText)this.findViewById(R.id.et_content);
        this.cbEmoji = (CheckBox)this.findViewById(R.id.cb_emoji);
        this.faceGridView = (FaceGridView)this.findViewById(R.id.face_grid_view);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.lyBrowseAuth = this.findViewById(R.id.ly_scope);
        this.lyAddress = this.findViewById(R.id.ly_address);
        this.tvBrowseAuth = (TextView)this.findViewById(R.id.tv_browse_auth);
        this.ivBrowseIcon = (ImageView)this.findViewById(R.id.iv_browse_icon);
        this.tvLocation = (TextView)this.findViewById(R.id.tv_location);
        this.tvLocationDefault = (TextView)this.findViewById(R.id.tv_location_default);
        this.tvType = (TextView)this.findViewById(R.id.tv_type);
        this.tvContentNum = (TextView)this.findViewById(R.id.tv_content_num);
        this.ivFile = (ImageView)this.findViewById(R.id.iv_file);
        this.ivPerson = (ImageView)this.findViewById(R.id.iv_person);
        this.ivPicture = (ImageView)this.findViewById(R.id.iv_picture);
        this.ivDeleteLocation = (ImageView)this.findViewById(R.id.iv_delete_location);
        this.lyFile = this.findViewById(R.id.ly_file);
        this.ivFileIcon = (ImageView)this.findViewById(R.id.iv_file_icon);
        this.tvFileName = (TextView)this.findViewById(R.id.tv_file_name);
        this.mentionWhoLayout = (LinearLayout)this.findViewById(R.id.ly_choosed_user);
        this.horizontalScrollView = (HorizontalScrollView)this.findViewById(R.id.ly_mention_who);
        this.ivDeleteFile = (ImageView)this.findViewById(R.id.iv_delete_file);
        this.atGroup = this.findViewById(R.id.at_group);
        this.presenter = new PublishPresenter(this);
        this.initEmojiView();
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this, 3);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.presenter.getPictureAdapter());
        this.ivDeleteLocation.setOnClickListener((View.OnClickListener)this);
        this.ivDeleteFile.setOnClickListener((View.OnClickListener)this);
        this.tvLocation.setOnClickListener((View.OnClickListener)this);
        this.tvLocationDefault.setOnClickListener((View.OnClickListener)this);
        this.ivPicture.setOnClickListener((View.OnClickListener)this);
        this.ivFile.setOnClickListener((View.OnClickListener)this);
        this.ivPerson.setOnClickListener((View.OnClickListener)this);
        this.lyBrowseAuth.setOnClickListener((View.OnClickListener)this);
        this.tvType.setOnClickListener((View.OnClickListener)this);
        this.presenter.initDefaultData(this.getIntent());
    }

    private void initEmojiView() {
        this.cbEmoji.setOnCheckedChangeListener((buttonView, isChecked) -> this.presenter.onFaceIconClick(isChecked));
        this.faceGridView.setOnFaceGridViewItemClick(new FaceGridView.OnFaceGridViewItemClick(){

            @Override
            public void onItemClick(int facesPos) {
                PublishActivity.this.presenter.onEmojiInput(facesPos);
            }

            @Override
            public void onClear() {
                PublishActivity.this.presenter.onEmojiDelete();
            }
        });
        this.faceGridView.setAdapter();
        this.etContent.setOnClickListener(v -> {
            if (this.cbEmoji.isChecked()) {
                this.cbEmoji.setChecked(false);
            }
        });
        this.etContent.addTextChangedListener(this.presenter.getContentTextWatcher());
    }

    protected void onToolBarNavigationClick() {
        this.presenter.onBackPressed();
    }

    public void onBackPressed() {
        this.presenter.onBackPressed();
    }

    protected LoadingType getLoadingType() {
        return LoadingType.LOAD_TYPE_DIALOG;
    }

    @NeedsPermission(value={"android.permission.CAMERA"})
    public void takeMedia() {
        this.presenter.onCameraIconClick();
    }

    @OnNeverAskAgain(value={"android.permission.CAMERA"})
    void showNeverAskForPermissions() {
        this.showPermissionDeniedDialog(R.string.moments_permission_setting);
    }

    @OnPermissionDenied(value={"android.permission.CAMERA"})
    void showDeniedForPermissions() {
        this.showPermissionDeniedDialog(R.string.moments_permission_setting);
    }

    @NeedsPermission(value={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    void gaintLocationPermission() {
        this.presenter.onLocationIconClick();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PublishActivityPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode != -1) {
            return;
        }
        this.presenter.onActivityResult(requestCode, data);
    }

    @Override
    public void showKeyBoard() {
        EmojiUtil.showKeyboard((View)this.etContent);
    }

    @Override
    public void hideKeyBoard() {
        EmojiUtil.hidKeyboard((View)this.etContent);
    }

    @Override
    public EditText getInputView() {
        return this.etContent;
    }

    @Override
    public void showDefaultLocationView(boolean isShow) {
        this.tvLocationDefault.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public void showLocationView(boolean isShow) {
        this.lyAddress.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public void setLocation(String address) {
        if (!TextUtils.isEmpty((CharSequence)address)) {
            this.showLocationView(true);
            this.showDefaultLocationView(false);
            this.tvLocation.setText((CharSequence)address);
        } else {
            this.showLocationView(false);
            this.showDefaultLocationView(true);
        }
    }

    @Override
    public void showFileView(boolean isShow) {
        this.lyFile.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public void setFileView(AppendixBean fileBean) {
        if (fileBean == null) {
            this.lyFile.setVisibility(8);
            this.tvFileName.setText((CharSequence)"");
        } else {
            this.lyFile.setVisibility(0);
            this.ivFileIcon.setImageResource(fileBean.getResId());
            this.tvFileName.setText((CharSequence)FileUtils.getFileName((String)fileBean.getPath()));
        }
    }

    @Override
    public void setLinkView(String thumbPath, String url, String description) {
        this.lyFile.setVisibility(0);
        Glide.with((FragmentActivity)this).load(thumbPath).fitCenter().error(R.drawable.moments_img_pic_default).placeholder(R.drawable.moments_img_pic_default).diskCacheStrategy(DiskCacheStrategy.ALL).into(this.ivFileIcon);
        this.tvFileName.setText((CharSequence)description);
    }

    @Override
    public void showAtView(boolean isShow) {
        this.atGroup.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public void setAtView(List<UserInfoBean> users) {
        if (!ListUtil.isEmpty(users)) {
            this.showAtView(true);
            this.mentionWhoLayout.removeAllViews();
            for (UserInfoBean personBean : users) {
                View view = LayoutInflater.from((Context)this).inflate(R.layout.moments_layout_publish_mention, null);
                ImageView imageView = (ImageView)view.findViewById(R.id.moments_jingyuan_choosed_img);
                if (personBean != null) {
                    Glide.with((FragmentActivity)this).load(personBean.getUserAvatar()).transform(new BitmapTransformation[]{new GlideCircleTransform((Context)this)}).placeholder(R.drawable.moments_person_default).error(R.drawable.moments_person_default).diskCacheStrategy(DiskCacheStrategy.ALL).into(imageView);
                    view.setTag((Object)personBean.getUserId());
                    this.mentionWhoLayout.addView(view);
                }
                Message message = this.mHandler.obtainMessage();
                this.mHandler.sendMessageDelayed(message, 300L);
            }
        } else {
            this.showAtView(false);
        }
    }

    @Override
    public void showFaceGridView(boolean isShow) {
        this.faceGridView.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public void mStartActivityForResult(Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode);
    }

    @Override
    public LifecycleProvider<Lifecycle.Event> getLifecycleProvider() {
        return this.provider;
    }

    @Override
    public void setBrowseAuthTypeView(int browseAuthType) {
        this.tvBrowseAuth.setText((CharSequence)BrowseAuthType.getType(browseAuthType).getBrowseAuth());
        int resourceId = R.drawable.moments_topic_browseauth_public;
        if (browseAuthType == BrowseAuthType.FRIEND.getKey()) {
            resourceId = R.drawable.moments_topic_browseauth_friend;
        } else if (browseAuthType == BrowseAuthType.DEPTMENT.getKey()) {
            resourceId = R.drawable.moments_topic_browseauth_deptment;
        }
        this.ivBrowseIcon.setImageResource(resourceId);
    }

    @Override
    public void setClassifyView(String classifyName) {
        this.tvType.setText((CharSequence)classifyName);
    }

    @Override
    public void setTvUnmView(String s) {
        this.tvContentNum.setText((CharSequence)s);
    }

    @Override
    public void showSaveDraftDialog() {
        this.showAlertDialog(this.getString(0x1040000), this.getString(R.string.moments_save), this.getString(R.string.moments_save_moment), new View.OnClickListener(){

            public void onClick(View v) {
                PublishActivity.this.dismissAlertDialog();
                PublishActivity.this.finish();
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                PublishActivity.this.dismissAlertDialog();
                PublishActivity.this.presenter.saveDraft();
            }
        });
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.iv_delete_file) {
            this.presenter.onDeleteFileClick();
        } else if (i == R.id.tv_location || i == R.id.tv_location_default) {
            PublishActivityPermissionsDispatcher.gaintLocationPermissionWithPermissionCheck(this);
        } else if (i == R.id.iv_picture) {
            this.takeMedia();
        } else if (i == R.id.iv_file) {
            this.presenter.onFolderIconClick();
        } else if (i == R.id.ly_scope) {
            this.presenter.onBrowseAuthClick();
        } else if (i == R.id.iv_person) {
            this.presenter.onAtIconClick();
        } else if (i == R.id.tv_type) {
            this.presenter.onClassifyClick();
        } else if (i == R.id.iv_delete_location) {
            this.presenter.onDeleteLocationClick();
        }
    }

    protected void onDestroy() {
        this.presenter.release();
        super.onDestroy();
    }
}

