/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.baselibrary.base.adapter.BaseRecyclerViewAdapter;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.moments.sdk.R;

public class PublishFileAdapter
extends BaseRecyclerViewAdapter<AppendixBean, ViewHolder> {
    private Context context;
    private OnItemClickListener listener;

    public PublishFileAdapter(Context context) {
        this.context = context;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.moments_item_media, null));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        if (i + 1 <= this.dataLists.size()) {
            AppendixBean bean = (AppendixBean)this.dataLists.get(i);
            viewHolder.delete.setVisibility(0);
            Glide.with((Context)this.context).load(bean.getPath()).fitCenter().error(R.drawable.moments_img_pic_default).placeholder(R.drawable.moments_img_pic_default).diskCacheStrategy(bean.getType() == AppendixBean.TYPE.IMAGE ? DiskCacheStrategy.ALL : DiskCacheStrategy.RESULT).into(viewHolder.content);
            viewHolder.content.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onViewClick(bean);
                }
            });
            viewHolder.delete.setOnClickListener(v -> {
                AppendixBean deleteBean = (AppendixBean)this.getItem(i);
                this.remove(deleteBean);
                if (this.listener != null) {
                    this.listener.onDeleteClick(deleteBean);
                }
            });
            if (bean.getType() == AppendixBean.TYPE.VIDEO) {
                viewHolder.play.setVisibility(0);
            } else {
                viewHolder.play.setVisibility(8);
            }
        } else {
            viewHolder.delete.setVisibility(8);
            viewHolder.content.setImageResource(R.drawable.moments_picture_add);
            viewHolder.content.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onAddClick();
                }
            });
        }
    }

    public int getItemCount() {
        if (this.dataLists.size() == 0) {
            return 0;
        }
        if (this.dataLists.size() == 1) {
            AppendixBean appendixBean = (AppendixBean)this.dataLists.get(0);
            switch (appendixBean.getType()) {
                case IMAGE: {
                    return 2;
                }
                case VIDEO: {
                    return 1;
                }
            }
            return 0;
        }
        if (this.dataLists.size() < 9) {
            return this.dataLists.size() + 1;
        }
        return 9;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public static interface OnItemClickListener {
        public void onViewClick(AppendixBean var1);

        public void onAddClick();

        public void onDeleteClick(AppendixBean var1);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView content;
        Button delete;
        ImageView play;

        public ViewHolder(View itemView) {
            super(itemView);
            this.content = (ImageView)itemView.findViewById(R.id.iv_content);
            this.delete = (Button)itemView.findViewById(R.id.btn_delete);
            this.play = (ImageView)itemView.findViewById(R.id.iv_video_play);
        }
    }
}

