/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.business.imp;

import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.moments.sdk.bean.fastDfs.UploadFastDfsParameter;
import com.xdja.moments.sdk.flow.publish.business.FastdfsBusiness;
import com.xdja.moments.sdk.http.upload.FastDfsFileUpload;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class FastdfsBusinessImp
implements FastdfsBusiness {
    @Override
    public String uploadFile(String path) {
        UploadFastDfsParameter parameter = this.generateUploadParamter(path);
        try {
            return new FastDfsFileUpload(parameter).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private UploadFastDfsParameter generateUploadParamter(String s) {
        UploadFastDfsParameter parameter = new UploadFastDfsParameter();
        File file = new File(s);
        try {
            parameter.setFilePath(s);
            parameter.setFileSize(String.valueOf(file.length()));
            parameter.setUrl(this.getUploadUrl());
            parameter.setPerm("1");
            parameter.setFileName(URLEncoder.encode(file.getName(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parameter;
    }

    private String getUploadUrl() {
        long ts = System.currentTimeMillis() + 600000L;
        String sign = "";
        try {
            sign = FastdfsBusinessImp.hamcsha1(ConstantUrl.FASTDFS_USER_ID + ts, ConstantUrl.FASTDFS_USER_SECRET);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return ConstantUrl.getFastdfsUrl() + "trunkupload?userid=" + ConstantUrl.FASTDFS_USER_ID + "&ts=" + ts + "&sign=" + sign;
    }

    public static String hamcsha1(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        return FastdfsBusinessImp.byteArrayToHex(mac.doFinal(data.getBytes()));
    }

    private static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray).toLowerCase();
    }
}

