/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.mvp;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AlertDialog;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.EditText;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseObserver;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.location.LocationBean;
import com.xdja.baselibrary.location.LocationCallback;
import com.xdja.baselibrary.location.MomentsLocationHelper;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.PublishMomentsParam;
import com.xdja.moments.sdk.bean.SelectMomentsClassifyBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.bean.share.BaseShareBean;
import com.xdja.moments.sdk.bean.share.ShareFileBean;
import com.xdja.moments.sdk.bean.share.ShareImageBean;
import com.xdja.moments.sdk.bean.share.ShareLinkBean;
import com.xdja.moments.sdk.bean.share.ShareVideoBean;
import com.xdja.moments.sdk.database.domain.MomentDraft;
import com.xdja.moments.sdk.flow.publish.adapter.PublishFileAdapter;
import com.xdja.moments.sdk.flow.publish.business.PublishBusiness;
import com.xdja.moments.sdk.flow.publish.business.imp.PublishBusinessImp;
import com.xdja.moments.sdk.flow.publish.mvp.PublishActivityConstruct;
import com.xdja.moments.sdk.manager.FileTypeManager;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.manager.location.MomentsLocationManager;
import com.xdja.moments.sdk.utils.DeviceUtil;
import com.xdja.moments.sdk.utils.EmojiUtil;
import com.xdja.moments.sdk.utils.GetPathFromUri4kitkat;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import com.xdja.moments.sdk.utils.PublishShareUtil;
import io.reactivex.FlowableTransformer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class PublishPresenter
implements PublishActivityConstruct.Presenter,
LocationCallback {
    @NonNull
    private PublishActivityConstruct.View view;
    private LifecycleProvider<Lifecycle.Event> lifecycleProvider;
    private EditText inputView;
    private Context context;
    private AlertDialog choseMediaTypeDialog;
    private AlertDialog addPictureDialog;
    private static final int INPUT_MAX_LENGTH = 500;
    private String takePicturePath;
    private AppendixBean fileBean;
    private LocationBean location;
    private PublishBusiness publishBusiness;
    private PublishFileAdapter adapter;
    private List<SelectMomentsClassifyBean> classifyBeanList;
    private List<UserInfoBean> atUsers;
    private MomentDraft momentDraft;
    private MomentsLocationHelper locationHelper;
    private BaseShareBean shareBean = null;
    private int browseAuthType = 1;
    private String browseAuthValue;
    private String classifyId;
    private int momentType = 1;

    public PublishPresenter(@NonNull PublishActivityConstruct.View view) {
        this.view = view;
        this.lifecycleProvider = view.getLifecycleProvider();
        this.inputView = view.getInputView();
        this.context = this.inputView.getContext();
        this.publishBusiness = new PublishBusinessImp(this.lifecycleProvider);
    }

    @Override
    public void initDefaultData(Intent intent) {
        this.getDefaultLocation();
        this.getClassifyInfos();
        if (intent.getAction() != null && intent.getAction().equals("android.intent.action.SEND")) {
            String shareFilePath = null;
            String stringExtra = intent.getStringExtra("android.intent.extra.TEXT");
            Uri imageUri = (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
            if (imageUri != null) {
                shareFilePath = GetPathFromUri4kitkat.getPath(this.context.getApplicationContext(), imageUri);
            }
            this.shareBean = PublishShareUtil.convertToShareBean(stringExtra, shareFilePath);
        } else {
            this.shareBean = (BaseShareBean)intent.getSerializableExtra("publish_share_bean");
        }
        if (this.shareBean == null) {
            this.getDraft();
        } else {
            this.initShareData(this.shareBean);
        }
    }

    private void initShareData(BaseShareBean bean) {
        if (bean == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)bean.getContent())) {
            this.inputView.setText((CharSequence)bean.getContent());
        }
        if (bean.getType() == 1) {
            this.momentType = 1;
        } else if (bean.getType() == 2) {
            String[] filePaths;
            this.momentType = 2;
            for (String tempFilePath : filePaths = ((ShareImageBean)bean).getPath().split(",")) {
                this.handleFile(tempFilePath);
            }
        } else if (bean.getType() == 3) {
            this.momentType = 3;
            this.handleFile(((ShareVideoBean)bean).getPath());
        } else if (bean.getType() == 4) {
            this.momentType = 4;
            this.handleFile(((ShareFileBean)bean).getPath());
            this.view.showFileView(true);
            this.view.setFileView(this.fileBean);
        } else if (bean.getType() == 5) {
            this.momentType = 5;
            String url = ((ShareLinkBean)bean).getShareUrl();
            String description = ((ShareLinkBean)bean).getDescription();
            String thumbPath = ((ShareLinkBean)bean).getThumbPath();
            this.view.setLinkView(thumbPath, url, description);
        }
    }

    private void getDraft() {
        Disposable disposable = this.publishBusiness.getMomentDraft().compose((FlowableTransformer)this.lifecycleProvider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe((Consumer)new Consumer<MomentDraft>(){

            public void accept(MomentDraft momentDraft) throws Exception {
                PublishPresenter.this.initMomentDraft(momentDraft);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                throwable.printStackTrace();
                PublishPresenter.this.view.showToast(throwable.getMessage());
            }
        });
    }

    private void initMomentDraft(MomentDraft momentDraft) {
        if (momentDraft == null) {
            return;
        }
        this.momentDraft = momentDraft;
        this.classifyId = momentDraft.getClassifyId();
        this.momentType = momentDraft.getMomentType();
        this.browseAuthType = momentDraft.getBrowseAuth();
        this.browseAuthValue = momentDraft.getBrowseAuthValue();
        if (!TextUtils.isEmpty((CharSequence)momentDraft.getMomentContent())) {
            this.inputView.setText((CharSequence)momentDraft.getMomentContent());
            this.inputView.setSelection(momentDraft.getMomentContent().length());
        }
        this.view.setBrowseAuthTypeView(this.browseAuthType);
        this.view.setClassifyView(momentDraft.getClassifyName());
        String picListStr = momentDraft.getMomentPicturePath();
        if (!TextUtils.isEmpty((CharSequence)picListStr)) {
            String[] picArray = picListStr.split(",");
            ArrayList<AppendixBean> list = new ArrayList<AppendixBean>();
            for (String s : picArray) {
                AppendixBean bean = new AppendixBean();
                bean.setType(AppendixBean.TYPE.IMAGE);
                bean.setPath(s);
                list.add(bean);
            }
            this.adapter.addAll(list);
        }
        if (!TextUtils.isEmpty((CharSequence)momentDraft.getMomentFilePath())) {
            this.fileBean = new AppendixBean();
            this.fileBean.setType(AppendixBean.TYPE.FILE);
            this.fileBean.setPath(momentDraft.getMomentFilePath());
            this.fileBean.setFileId(momentDraft.getMomentFileId());
            this.view.setFileView(this.fileBean);
        }
    }

    private String getClassifyName(String classifyId) {
        for (SelectMomentsClassifyBean bean : this.classifyBeanList) {
            if (!TextUtils.equals((CharSequence)classifyId, (CharSequence)bean.getClassifyId())) continue;
            return bean.getClassifyName();
        }
        return "";
    }

    private void getDefaultLocation() {
        this.locationHelper = MomentsLocationManager.getInstance().getHelper();
        if (this.locationHelper == null) {
            return;
        }
        this.locationHelper.init(((Activity)this.context).getApplication());
        this.locationHelper.setLocationCallback((LocationCallback)this);
        this.locationHelper.startLocation();
    }

    private void getClassifyInfos() {
        Disposable disposable = this.publishBusiness.getCanPublishClassifyBean().subscribe(items -> {
            if (items != null && items.size() > 0) {
                ((SelectMomentsClassifyBean)items.get(0)).setClassifyName("\u9ed8\u8ba4(" + ((SelectMomentsClassifyBean)items.get(0)).getClassifyName() + ")");
                this.classifyBeanList = items;
                if (TextUtils.isEmpty((CharSequence)this.classifyId)) {
                    this.classifyId = ((SelectMomentsClassifyBean)items.get(0)).getClassifyId();
                }
            } else {
                this.view.showToast(this.context.getString(R.string.moments_no_publish_power_classify));
            }
        }, throwable -> {
            throwable.printStackTrace();
            this.view.showToast(throwable.getMessage());
        });
    }

    @Override
    public void publishMomentsData() {
        if (TextUtils.isEmpty((CharSequence)this.inputView.getText()) && this.mediaIsEmpty()) {
            this.view.showToast(this.context.getString(R.string.moments_input_first));
            this.inputView.requestFocus();
            return;
        }
        if (this.classifyBeanList == null) {
            this.view.showToast(this.context.getString(R.string.moments_no_publish_power_classify));
            return;
        }
        ArrayList<AppendixBean> uploadList = null;
        switch (this.momentType) {
            case 2: 
            case 3: {
                uploadList = this.adapter.getDataLists();
                break;
            }
            case 4: {
                uploadList = new ArrayList<AppendixBean>();
                uploadList.add(this.fileBean);
            }
        }
        this.publishBusiness.publicMoments(this.generatePublishMomentParam(), uploadList).subscribe((Observer)new BaseObserver<Object>((IBaseView)this.view, this.context.getString(R.string.moments_publish_loading), "momentHide/hideMomentInfo"){

            public void onNext(Object o) {
                PublishPresenter.this.view.showToast(PublishPresenter.this.context.getString(R.string.moments_publish_sucess));
                if (PublishPresenter.this.momentDraft != null) {
                    PublishPresenter.this.publishBusiness.deleteDraft(PublishPresenter.this.momentDraft);
                }
                PublishPresenter.this.view.finish();
            }
        });
    }

    private boolean mediaIsEmpty() {
        switch (this.momentType) {
            case 2: 
            case 3: {
                return ListUtil.isEmpty((List)this.adapter.getDataLists());
            }
            case 4: {
                return this.fileBean == null;
            }
            case 5: {
                return this.shareBean == null;
            }
        }
        return true;
    }

    private PublishMomentsParam generatePublishMomentParam() {
        PublishMomentsParam publishParam = new PublishMomentsParam();
        publishParam.setMomentContent(this.inputView.getText().toString());
        if (this.location != null) {
            publishParam.setAddress(this.location.getAddress());
            publishParam.setLatitude(this.location.getLatitude() + "");
            publishParam.setLongitude(this.location.getLongitude() + "");
            publishParam.setAddressDetail(this.location.getAddressDetail());
        }
        publishParam.setClassifyId(this.classifyId);
        switch (this.momentType) {
            case 2: {
                break;
            }
            case 3: {
                AppendixBean bean = (AppendixBean)this.adapter.getItem(0);
                publishParam.setMomentFileSize(FileUtils.getFileSize((String)bean.getPath()));
                publishParam.setMomentFileName(FileUtils.getFileName((String)bean.getPath()));
                publishParam.setMomentVideoTime(String.valueOf(bean.getVieoTime()));
                publishParam.setMomentFileType(FileUtils.getFileExtension((String)bean.getPath()));
                break;
            }
            case 4: {
                publishParam.setMomentFileSize(FileUtils.getFileSize((String)this.fileBean.getPath()));
                publishParam.setMomentFileName(FileUtils.getFileName((String)this.fileBean.getPath()));
                publishParam.setMomentFileType(FileUtils.getFileExtension((String)this.fileBean.getPath()));
                break;
            }
            case 5: {
                if (this.shareBean == null || !(this.shareBean instanceof ShareLinkBean)) break;
                publishParam.setMomentSharePicture(((ShareLinkBean)this.shareBean).getThumbPath());
                publishParam.setMomentShareUrl(((ShareLinkBean)this.shareBean).getShareUrl());
                publishParam.setMomentShareContent(((ShareLinkBean)this.shareBean).getDescription());
            }
        }
        publishParam.setMomentType(String.valueOf(this.momentType));
        publishParam.setAtIds(this.generateAtIds());
        publishParam.setBrowseAuth(String.valueOf(this.browseAuthType));
        publishParam.setBrowseAuthValue(this.browseAuthValue);
        return publishParam;
    }

    private String generatePicturePath() {
        List appendixBeans = this.adapter.getDataLists();
        if (ListUtil.isEmpty((List)appendixBeans)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (AppendixBean bean : appendixBeans) {
            stringBuilder.append(bean.getPath());
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private List<String> generatePicturePathToList() {
        List appendixBeans = this.adapter.getDataLists();
        ArrayList<String> list = new ArrayList<String>();
        for (AppendixBean bean : appendixBeans) {
            list.add(bean.getPath());
        }
        return list;
    }

    private String generateAtIds() {
        if (ListUtil.isEmpty(this.atUsers)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (UserInfoBean atUser : this.atUsers) {
            stringBuilder.append(atUser.getUserId());
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public PublishFileAdapter getPictureAdapter() {
        if (this.adapter == null) {
            this.adapter = new PublishFileAdapter(this.context);
            this.adapter.setOnItemClickListener(new PublishFileAdapter.OnItemClickListener(){

                @Override
                public void onViewClick(AppendixBean bean) {
                    if (bean.getType() == AppendixBean.TYPE.IMAGE) {
                        PublishPresenter.this.viewPictureDetail(bean.getPath());
                    } else if (bean.getType() == AppendixBean.TYPE.VIDEO) {
                        PublishPresenter.this.playVideo(bean.getPath());
                    }
                }

                @Override
                public void onAddClick() {
                    PublishPresenter.this.onAddPictureClick();
                }

                @Override
                public void onDeleteClick(AppendixBean item) {
                    if (ListUtil.isEmpty((List)PublishPresenter.this.adapter.getDataLists())) {
                        PublishPresenter.this.browseAuthType = 1;
                    }
                }
            });
        }
        return this.adapter;
    }

    @Override
    public void onFaceIconClick(boolean isCheck) {
        if (isCheck) {
            this.view.hideKeyBoard();
            Disposable disposable = Observable.timer((long)200L, (TimeUnit)TimeUnit.MILLISECONDS).compose(MomentsRxTransformer.momentsComposeIoAndError(this.lifecycleProvider)).subscribe(aLong -> this.view.showFaceGridView(true));
        } else {
            this.view.showKeyBoard();
            this.view.showFaceGridView(false);
        }
    }

    @Override
    public void onCameraIconClick() {
        if (!this.checkCanAddMedia()) {
            return;
        }
        if (this.choseMediaTypeDialog == null) {
            this.choseMediaTypeDialog = new AlertDialog.Builder(this.context).setItems((CharSequence[])this.context.getResources().getStringArray(R.array.moments_medias), (dialogInterface, i) -> {
                switch (i) {
                    case 0: {
                        this.takePicture();
                        break;
                    }
                    case 1: {
                        this.takeVideo();
                        break;
                    }
                    case 2: {
                        this.selectPictureFromMobile();
                        break;
                    }
                    case 3: {
                        this.selectVideoFromMobile();
                    }
                }
            }).create();
        }
        this.choseMediaTypeDialog.show();
    }

    @Override
    public void onAddPictureClick() {
        if (this.addPictureDialog == null) {
            this.addPictureDialog = new AlertDialog.Builder(this.context).setItems((CharSequence[])this.context.getResources().getStringArray(R.array.moments_medias_picture), (dialogInterface, i) -> {
                switch (i) {
                    case 0: {
                        this.takePicture();
                        break;
                    }
                    case 1: {
                        this.selectPictureFromMobile();
                    }
                }
            }).create();
        }
        this.addPictureDialog.show();
    }

    @Override
    public void viewPictureDetail(String path) {
    }

    private void playVideo(String path) {
    }

    @Override
    public void onDeleteFileClick() {
        this.fileBean = null;
        this.view.showFileView(false);
        this.view.setFileView(null);
        this.browseAuthType = 1;
    }

    @Override
    public void onBrowseAuthClick() {
        Navigation.navigationSelectBrowseAuthActivity((Activity)this.view, this.classifyId, this.browseAuthType, this.browseAuthValue);
    }

    @Override
    public TextWatcher getContentTextWatcher() {
        return new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PublishPresenter.this.view.setTvUnmView(s.length() + "/" + 500);
            }
        };
    }

    @Override
    public void onBackPressed() {
        if (!TextUtils.isEmpty((CharSequence)this.inputView.getText())) {
            this.view.showSaveDraftDialog();
        } else {
            this.view.finish();
        }
    }

    @Override
    public void onFolderIconClick() {
        if (!this.checkCanAddFile()) {
            return;
        }
        Navigation.navigationFilePicker((Activity)this.context, 1, 50, R.style.moments_AppTheme);
    }

    @Override
    public void onAtIconClick() {
        Navigation.navigationSelectPerson((Activity)this.view, this.atUsers, 9);
    }

    @Override
    public void onLocationIconClick() {
        if (this.location != null) {
            Navigation.navigationLocationActivity((Activity)this.view, true, this.location.getAddress(), this.location.getAddressDetail(), this.location.getLongitude(), this.location.getLatitude(), this.location.getCityCode());
        } else {
            Navigation.navigationLocationActivity((Activity)this.view, true);
        }
    }

    @Override
    public void onDeleteLocationClick() {
        this.view.setLocation("");
    }

    @Override
    public void onClassifyClick() {
        Navigation.navigationSelectClassify((Activity)this.view, this.classifyBeanList, this.classifyId);
    }

    @Override
    public void onEmojiInput(int pos) {
        if (this.inputView == null) {
            return;
        }
        try {
            if (this.inputView.getVisibility() == 0) {
                if (this.inputView.getText().length() + 11 > 500) {
                    return;
                }
                int index = this.inputView.getSelectionStart();
                Editable editable = this.inputView.getEditableText();
                if (index < 0 || index >= editable.length()) {
                    editable.append((CharSequence)EmojiUtil.getSpannableStr(this.inputView.getContext(), pos));
                } else {
                    editable.insert(index, (CharSequence)EmojiUtil.getSpannableStr(this.inputView.getContext(), pos));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onEmojiDelete() {
        if (this.view.getInputView() == null) {
            return;
        }
        EmojiUtil.deleteSpannableStr(this.view.getInputView());
    }

    private void takePicture() {
        if (!this.checkCanAddPicture()) {
            return;
        }
        StringBuilder fileName = new StringBuilder();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        fileName.append(UUID.randomUUID()).append(".png");
        File tempFile = new File(this.context.getExternalFilesDir(Environment.DIRECTORY_PICTURES), fileName.toString());
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setFlags(3);
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)(this.context.getPackageName() + ".fileProvider"), (File)tempFile);
            intent.putExtra("output", (Parcelable)uri);
        } else {
            Uri uri = Uri.fromFile((File)tempFile);
            intent.putExtra("output", (Parcelable)uri);
        }
        this.takePicturePath = tempFile.getAbsolutePath();
        this.view.mStartActivityForResult(intent, 257);
    }

    private void takeVideo() {
        if (!this.checkCanAddVideo()) {
            return;
        }
        if (!DeviceUtil.isExitsSdcard()) {
            this.view.showToast(this.context.getString(R.string.moments_no_sdcard_no_take_picture));
            return;
        }
        Navigation.navigationTakeVideo((Activity)this.view);
    }

    private void selectPictureFromMobile() {
        if (!this.checkCanAddPicture()) {
            return;
        }
        Navigation.navigationSelectPictureActivity((Activity)this.view, this.generatePicturePathToList());
    }

    private void selectVideoFromMobile() {
        if (!this.checkCanAddVideo()) {
            return;
        }
        Navigation.navigationSelectPictureActivity((Activity)this.view, this.generatePicturePathToList());
    }

    public void onLocationChange(LocationBean bean) {
        if (null != bean) {
            this.location = bean;
            this.view.showLocationView(true);
            this.view.showDefaultLocationView(false);
            this.view.setLocation(this.location.getAddress());
            this.locationHelper.release();
        }
    }

    private boolean checkCanAddMedia() {
        if (this.fileBean != null) {
            this.view.showToast(this.context.getString(R.string.moments_pic_file_video_conflict));
            return false;
        }
        if (!ListUtil.isEmpty((List)this.adapter.getDataLists())) {
            if (((AppendixBean)this.adapter.getDataLists().get(0)).getType() == AppendixBean.TYPE.VIDEO) {
                this.view.showToast(this.context.getString(R.string.moments_pic_video_conflict));
                return false;
            }
            if (this.adapter.getDataLists().size() >= 9) {
                this.view.showToast(this.context.getString(R.string.moments_pic_max_num));
                return false;
            }
        }
        return true;
    }

    private boolean checkCanAddPicture() {
        List list = this.adapter.getDataLists();
        if (ListUtil.isEmpty((List)list)) {
            return true;
        }
        if (list.size() >= 9) {
            this.view.showToast(this.context.getString(R.string.moments_pic_max_num));
            return false;
        }
        AppendixBean bean = (AppendixBean)list.get(0);
        if (bean.getType() == AppendixBean.TYPE.VIDEO) {
            this.view.showToast(this.context.getString(R.string.moments_pic_video_conflict));
            return false;
        }
        return true;
    }

    private boolean checkCanAddVideo() {
        List list = this.adapter.getDataLists();
        if (ListUtil.isEmpty((List)list)) {
            return true;
        }
        AppendixBean bean = (AppendixBean)list.get(0);
        if (bean.getType() == AppendixBean.TYPE.VIDEO) {
            this.view.showToast(this.context.getString(R.string.moments_video_max_num));
            return false;
        }
        this.view.showToast(this.context.getString(R.string.moments_pic_video_conflict));
        return false;
    }

    private boolean checkCanAddFile() {
        if (this.fileBean != null) {
            this.view.showToast(this.context.getString(R.string.moments_file_max_num));
            return false;
        }
        List list = this.adapter.getDataLists();
        if (!ListUtil.isEmpty((List)list)) {
            this.view.showToast(this.context.getString(R.string.moments_pic_file_video_conflict));
            return false;
        }
        return true;
    }

    @Override
    public void onActivityResult(int requestCode, Intent data) {
        switch (requestCode) {
            case 257: {
                this.momentType = 2;
                this.handleFile(this.takePicturePath);
                break;
            }
            case 258: {
                this.momentType = 3;
                String videoPath = data.getStringExtra("com.jmolsmobile.extraoutputfilename");
                this.handleFile(videoPath);
                break;
            }
            case 261: {
                this.momentType = 3;
                ArrayList videoList = data.getStringArrayListExtra("selected_media");
                if (ListUtil.isEmpty((List)videoList)) break;
                this.handleSelcetList(videoList);
                break;
            }
            case 260: {
                this.momentType = 2;
                ArrayList selectedPicPaths = data.getStringArrayListExtra("selected_media");
                if (ListUtil.isEmpty((List)selectedPicPaths)) break;
                this.handleSelcetList(selectedPicPaths);
                break;
            }
            case 259: {
                this.momentType = 4;
                ArrayList fileList = (ArrayList)data.getSerializableExtra("selected_file");
                if (ListUtil.isEmpty((List)fileList)) break;
                this.handleSelcetList(fileList);
                break;
            }
            case 263: {
                this.browseAuthType = data.getIntExtra("android.intent.bundle.BROWSEAUTH_TYPE", 1);
                this.browseAuthValue = data.getStringExtra("android.intent.bundle.BROWSEAUTH_VALUE");
                this.view.setBrowseAuthTypeView(this.browseAuthType);
                break;
            }
            case 264: {
                this.classifyId = data.getStringExtra("classifyId");
                String classifyName = data.getStringExtra("classifyName");
                this.view.setClassifyView(classifyName);
                break;
            }
            case 265: {
                ArrayList atUsersIdList = (ArrayList)data.getSerializableExtra("select_users");
                this.atUsers = MomentsDataManager.getInstance().queryUserList(atUsersIdList);
                this.view.setAtView(this.atUsers);
                break;
            }
            case 262: {
                if (this.location == null) {
                    this.location = new LocationBean();
                }
                String address = data.getStringExtra("address");
                String addressDetail = data.getStringExtra("addressdetail");
                double longitude = data.getDoubleExtra("longitude", 0.0);
                double latitude = data.getDoubleExtra("latitude", 0.0);
                String cityCode = data.getStringExtra("cityCode");
                this.location.setAddress(address);
                this.location.setAddressDetail(addressDetail);
                this.location.setLatitude(latitude);
                this.location.setLongitude(longitude);
                this.location.setCityCode(cityCode);
                this.view.setLocation(address);
            }
        }
    }

    @Override
    public void saveDraft() {
        MomentDraft momentDraft = new MomentDraft();
        momentDraft.setAtIds(this.generateAtIds());
        momentDraft.setBrowseAuth(this.browseAuthType);
        momentDraft.setBrowseAuthValue(this.browseAuthValue);
        momentDraft.setCreateTime(System.currentTimeMillis());
        momentDraft.setMomentContent(this.inputView.getText().toString());
        momentDraft.setMomentType(this.momentType);
        if (this.fileBean != null) {
            switch (this.fileBean.getType()) {
                case FILE: {
                    momentDraft.setMomentFileType(FileUtils.getFileExtension((String)this.fileBean.getPath()));
                }
            }
            momentDraft.setMomentFileName(FileUtils.getFileName((String)this.fileBean.getPath()));
            momentDraft.setMomentFilePath(this.fileBean.getPath());
            momentDraft.setMomentFileSize(FileUtils.getFileSize((String)this.fileBean.getPath()));
        }
        if (!ListUtil.isEmpty((List)this.adapter.getDataLists())) {
            momentDraft.setMomentPicturePath(this.generatePicturePath());
        }
        if (this.shareBean != null && this.shareBean instanceof ShareLinkBean) {
            momentDraft.setMomentShareContent(this.shareBean.getContent());
            momentDraft.setMomentSharePicture(((ShareLinkBean)this.shareBean).getThumbPath());
            momentDraft.setMomentShareUrl(((ShareLinkBean)this.shareBean).getShareUrl());
        }
        momentDraft.setUserId(MomentsManager.getInstance().getLoginer().getUserId());
        momentDraft.setClassifyId(this.classifyId);
        momentDraft.setClassifyName(this.getClassifyName(this.classifyId));
        Disposable disposable = this.publishBusiness.saveMomentDraft(momentDraft).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.view.showToast(this.context.getString(R.string.moments_draft_save_success));
                this.view.finish();
            } else {
                this.view.showToast(this.context.getString(R.string.moments_draft_save_fail));
            }
        }, throwable -> {
            throwable.printStackTrace();
            this.view.showToast(this.context.getString(R.string.moments_draft_save_fail));
        });
    }

    @Override
    public void release() {
        this.view.hideKeyBoard();
        if (this.locationHelper != null) {
            this.locationHelper.release();
        }
    }

    private void handleFile(String filePath) {
        FileTypeManager.FileType fileType = FileTypeManager.getType(FileUtils.getFileExtension((String)filePath));
        if (fileType == FileTypeManager.FileType.IMAGE) {
            if (FileUtils.getFileSize((String)filePath) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddPicture()) {
                this.operateFile(filePath, (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u56fe\u7247\u538b\u7f29\u4e2d..."){

                    public void onNext(AppendixBean o) {
                        super.onNext((Object)o);
                        PublishPresenter.this.adapter.add(o);
                    }
                });
            }
        } else if (fileType == FileTypeManager.FileType.VIDEO) {
            if (FileUtils.getFileSize((String)filePath) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddVideo()) {
                this.operateFile(filePath, (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u89c6\u9891\u5904\u7406\u4e2d..."){

                    public void onNext(AppendixBean o) {
                        super.onNext((Object)o);
                        PublishPresenter.this.adapter.add(o);
                    }
                });
            }
        } else {
            if (FileUtils.getFileSize((String)filePath) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddFile()) {
                this.fileBean = FileTypeManager.fileAppendixBean(filePath);
            }
        }
    }

    private void handleSelcetList(List<String> selectedPathList) {
        if (ListUtil.isEmpty(selectedPathList)) {
            return;
        }
        if (FileTypeManager.getFileType(selectedPathList.get(0)) == FileTypeManager.FileType.IMAGE) {
            if (selectedPathList.size() > 9) {
                this.view.showToast(this.context.getString(R.string.moments_pic_max_num));
                return;
            }
            this.adapter.clear();
            for (String selectedPicture : selectedPathList) {
                if (FileUtils.getFileSize((String)selectedPicture) >= 0x3200000L) {
                    this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                    continue;
                }
                this.operateFile(selectedPicture, (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u56fe\u7247\u538b\u7f29\u4e2d\u2026\u2026"){

                    public void onNext(AppendixBean appendixBean) {
                        super.onNext((Object)appendixBean);
                        PublishPresenter.this.adapter.add(appendixBean);
                    }
                });
            }
        } else if (FileTypeManager.getFileType(selectedPathList.get(0)) == FileTypeManager.FileType.VIDEO) {
            if (selectedPathList.size() > 1) {
                this.view.showToast(this.context.getString(R.string.moments_video_max_num));
                return;
            }
            if (FileUtils.getFileSize((String)selectedPathList.get(0)) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            this.adapter.clear();
            this.operateFile(selectedPathList.get(0), (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u89c6\u9891\u5904\u7406\u4e2d..."){

                public void onNext(AppendixBean o) {
                    super.onNext((Object)o);
                    PublishPresenter.this.adapter.add(o);
                }
            });
        } else {
            if (selectedPathList.size() > 1) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_num));
                return;
            }
            if (FileUtils.getFileSize((String)selectedPathList.get(0)) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddFile()) {
                this.fileBean = FileTypeManager.fileAppendixBean(selectedPathList.get(0));
                this.view.showFileView(true);
                this.view.setFileView(this.fileBean);
            }
        }
    }

    private void operateFile(String filePath, Observer<AppendixBean> observer) {
        Observable.just((Object)filePath).map(s -> FileTypeManager.fileAppendixBean(filePath)).compose(MomentsRxTransformer.momentsComposeIoAndError(this.lifecycleProvider)).subscribe(observer);
    }
}

