/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.http.download.DownLoadListener;

import com.xdja.moments.sdk.http.download.DownLoadListener.DownloadProgressListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class DownloadResponseBody
extends ResponseBody {
    private ResponseBody responseBody;
    private DownloadProgressListener progressListener;
    private BufferedSource bufferedSource;

    public DownloadResponseBody(ResponseBody responseBody, DownloadProgressListener progressListener) {
        this.responseBody = responseBody;
        this.progressListener = progressListener;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (null != DownloadResponseBody.this.progressListener) {
                    DownloadResponseBody.this.progressListener.update(this.totalBytesRead, DownloadResponseBody.this.responseBody.contentLength(), bytesRead == -1L);
                }
                return bytesRead;
            }
        };
    }
}

