/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.manager;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.utils.ImageCache;
import com.xdja.moments.sdk.widget.easemob.EaseEmojicon;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FaceManager {
    private static FaceManager mInstance;
    public static final String DELETE_KEY = "em_delete_delete_expression";
    public static final String PRAISE = "[emoji_060]";
    public static final Pattern EMOTION_URL;
    private static final int emojSize = 72;
    private Map<String, Integer> mFaceMap = new LinkedHashMap<String, Integer>();
    private ArrayList<String> faceKeys;
    private List<EaseEmojicon> emojiconList;

    private FaceManager() {
        this.initFaceMap();
    }

    public static synchronized FaceManager getInstance() {
        if (null == mInstance) {
            mInstance = new FaceManager();
        }
        return mInstance;
    }

    public Map<String, Integer> getFaceMap() {
        return this.mFaceMap;
    }

    public ArrayList<String> getFaceKeys() {
        return this.faceKeys;
    }

    public void initFaceMap() {
        this.mFaceMap.put("[emoji_001]", R.drawable.emoji_001);
        this.mFaceMap.put("[emoji_002]", R.drawable.emoji_002);
        this.mFaceMap.put("[emoji_003]", R.drawable.emoji_003);
        this.mFaceMap.put("[emoji_004]", R.drawable.emoji_004);
        this.mFaceMap.put("[emoji_005]", R.drawable.emoji_005);
        this.mFaceMap.put("[emoji_006]", R.drawable.emoji_006);
        this.mFaceMap.put("[emoji_007]", R.drawable.emoji_007);
        this.mFaceMap.put("[emoji_008]", R.drawable.emoji_008);
        this.mFaceMap.put("[emoji_009]", R.drawable.emoji_009);
        this.mFaceMap.put("[emoji_010]", R.drawable.emoji_010);
        this.mFaceMap.put("[emoji_011]", R.drawable.emoji_011);
        this.mFaceMap.put("[emoji_012]", R.drawable.emoji_012);
        this.mFaceMap.put("[emoji_013]", R.drawable.emoji_013);
        this.mFaceMap.put("[emoji_014]", R.drawable.emoji_014);
        this.mFaceMap.put("[emoji_015]", R.drawable.emoji_015);
        this.mFaceMap.put("[emoji_016]", R.drawable.emoji_016);
        this.mFaceMap.put("[emoji_017]", R.drawable.emoji_017);
        this.mFaceMap.put("[emoji_018]", R.drawable.emoji_018);
        this.mFaceMap.put("[emoji_019]", R.drawable.emoji_019);
        this.mFaceMap.put("[emoji_020]", R.drawable.emoji_020);
        this.mFaceMap.put("[emoji_021]", R.drawable.emoji_021);
        this.mFaceMap.put("[emoji_022]", R.drawable.emoji_022);
        this.mFaceMap.put("[emoji_023]", R.drawable.emoji_023);
        this.mFaceMap.put("[emoji_024]", R.drawable.emoji_024);
        this.mFaceMap.put("[emoji_025]", R.drawable.emoji_025);
        this.mFaceMap.put("[emoji_026]", R.drawable.emoji_026);
        this.mFaceMap.put("[emoji_027]", R.drawable.emoji_027);
        this.mFaceMap.put("[emoji_028]", R.drawable.emoji_028);
        this.mFaceMap.put("[emoji_029]", R.drawable.emoji_029);
        this.mFaceMap.put("[emoji_030]", R.drawable.emoji_030);
        this.mFaceMap.put("[emoji_031]", R.drawable.emoji_031);
        this.mFaceMap.put("[emoji_032]", R.drawable.emoji_032);
        this.mFaceMap.put("[emoji_033]", R.drawable.emoji_033);
        this.mFaceMap.put("[emoji_034]", R.drawable.emoji_034);
        this.mFaceMap.put("[emoji_035]", R.drawable.emoji_035);
        this.mFaceMap.put("[emoji_036]", R.drawable.emoji_036);
        this.mFaceMap.put("[emoji_037]", R.drawable.emoji_037);
        this.mFaceMap.put("[emoji_038]", R.drawable.emoji_038);
        this.mFaceMap.put("[emoji_039]", R.drawable.emoji_039);
        this.mFaceMap.put("[emoji_040]", R.drawable.emoji_040);
        this.mFaceMap.put("[emoji_041]", R.drawable.emoji_041);
        this.mFaceMap.put("[emoji_042]", R.drawable.emoji_042);
        this.mFaceMap.put("[emoji_043]", R.drawable.emoji_043);
        this.mFaceMap.put("[emoji_044]", R.drawable.emoji_044);
        this.mFaceMap.put("[emoji_045]", R.drawable.emoji_045);
        this.mFaceMap.put("[emoji_046]", R.drawable.emoji_046);
        this.mFaceMap.put("[emoji_047]", R.drawable.emoji_047);
        this.mFaceMap.put("[emoji_048]", R.drawable.emoji_048);
        this.mFaceMap.put("[emoji_049]", R.drawable.emoji_049);
        this.mFaceMap.put("[emoji_050]", R.drawable.emoji_050);
        this.mFaceMap.put("[emoji_051]", R.drawable.emoji_051);
        this.mFaceMap.put("[emoji_052]", R.drawable.emoji_052);
        this.mFaceMap.put("[emoji_053]", R.drawable.emoji_053);
        this.mFaceMap.put("[emoji_054]", R.drawable.emoji_054);
        this.mFaceMap.put("[emoji_055]", R.drawable.emoji_055);
        this.mFaceMap.put("[emoji_056]", R.drawable.emoji_056);
        this.mFaceMap.put("[emoji_057]", R.drawable.emoji_057);
        this.mFaceMap.put("[emoji_058]", R.drawable.emoji_058);
        this.mFaceMap.put("[emoji_059]", R.drawable.emoji_059);
        this.mFaceMap.put(PRAISE, R.drawable.emoji_060);
        this.mFaceMap.put("[emoji_061]", R.drawable.emoji_061);
        this.mFaceMap.put("[emoji_062]", R.drawable.emoji_062);
        this.mFaceMap.put("[emoji_063]", R.drawable.emoji_063);
        this.mFaceMap.put("[emoji_064]", R.drawable.emoji_064);
        this.mFaceMap.put("[emoji_065]", R.drawable.emoji_065);
        this.mFaceMap.put("[emoji_066]", R.drawable.emoji_066);
        this.mFaceMap.put("[emoji_067]", R.drawable.emoji_067);
        this.mFaceMap.put("[emoji_068]", R.drawable.emoji_068);
        this.mFaceMap.put("[emoji_069]", R.drawable.emoji_069);
        this.mFaceMap.put("[emoji_070]", R.drawable.emoji_070);
        this.mFaceMap.put("[emoji_071]", R.drawable.emoji_071);
        this.mFaceMap.put("[emoji_072]", R.drawable.emoji_072);
        Set<String> keySet = this.getFaceMap().keySet();
        this.faceKeys = new ArrayList();
        this.faceKeys.addAll(keySet);
        this.mFaceMap.put("[\u5fae\u7b11]", R.drawable.emoji_001);
        this.mFaceMap.put("[\u50b2\u6162]", R.drawable.emoji_002);
        this.mFaceMap.put("[\u8272]", R.drawable.emoji_003);
        this.mFaceMap.put("[\u5472\u7259]", R.drawable.emoji_004);
        this.mFaceMap.put("[\u53d1\u6012]", R.drawable.emoji_005);
        this.mFaceMap.put("[\u60ca\u8bb6]", R.drawable.emoji_006);
        this.mFaceMap.put("[\u6cea]", R.drawable.emoji_007);
        this.mFaceMap.put("[\u5077\u7b11]", R.drawable.emoji_008);
        this.mFaceMap.put("[\u98de\u543b]", R.drawable.emoji_009);
        this.mFaceMap.put("[\u60ca\u6050]", R.drawable.emoji_010);
        this.mFaceMap.put("[\u7591\u95ee]", R.drawable.emoji_011);
        this.mFaceMap.put("[\u597d\u5947]", R.drawable.emoji_012);
        this.mFaceMap.put("[\u6655]", R.drawable.emoji_013);
        this.mFaceMap.put("[\u6c57]", R.drawable.emoji_014);
        this.mFaceMap.put("[\u62a0\u9f3b]", R.drawable.emoji_015);
        this.mFaceMap.put("[\u5658\u5634]", R.drawable.emoji_016);
        this.mFaceMap.put("[\u9ed1\u7ebf]", R.drawable.emoji_017);
        this.mFaceMap.put("[\u9119\u89c6]", R.drawable.emoji_018);
        this.mFaceMap.put("[\u9634\u9669]", R.drawable.emoji_019);
        this.mFaceMap.put("[\u5bb3\u7f9e]", R.drawable.emoji_020);
        this.mFaceMap.put("[\u5927\u54ed]", R.drawable.emoji_021);
        this.mFaceMap.put("[\u9177]", R.drawable.emoji_022);
        this.mFaceMap.put("[\u54c8\u6b20]", R.drawable.emoji_023);
        this.mFaceMap.put("[\u751f\u75c5]", R.drawable.emoji_024);
        this.mFaceMap.put("[\u6253\u547c]", R.drawable.emoji_025);
        this.mFaceMap.put("[\u94b1]", R.drawable.emoji_026);
        this.mFaceMap.put("[\u611f\u5192]", R.drawable.emoji_027);
        this.mFaceMap.put("[\u54fc]", R.drawable.emoji_028);
        this.mFaceMap.put("[\u7f9e\u6127]", R.drawable.emoji_029);
        this.mFaceMap.put("[\u5410]", R.drawable.emoji_030);
        this.mFaceMap.put("[\u5492\u9a82]", R.drawable.emoji_031);
        this.mFaceMap.put("[\u6324\u773c]", R.drawable.emoji_032);
        this.mFaceMap.put("[\u601d\u8003]", R.drawable.emoji_033);
        this.mFaceMap.put("[\u5927\u7b11]", R.drawable.emoji_034);
        this.mFaceMap.put("[\u65e0\u8bed]", R.drawable.emoji_035);
        this.mFaceMap.put("[\u9b3c\u8138]", R.drawable.emoji_036);
        this.mFaceMap.put("[\u4e00]", R.drawable.emoji_037);
        this.mFaceMap.put("[\u9f13\u638c]", R.drawable.emoji_038);
        this.mFaceMap.put("[\u6028\u5ff5]", R.drawable.emoji_039);
        this.mFaceMap.put("[\u5618]", R.drawable.emoji_040);
        this.mFaceMap.put("[\u96be\u8fc7]", R.drawable.emoji_041);
        this.mFaceMap.put("[\u56e7]", R.drawable.emoji_042);
        this.mFaceMap.put("[\u5413\u5446]", R.drawable.emoji_043);
        this.mFaceMap.put("[\u4fdd\u91cd]", R.drawable.emoji_044);
        this.mFaceMap.put("[\u518d\u89c1]", R.drawable.emoji_045);
        this.mFaceMap.put("[\u8870]", R.drawable.emoji_046);
        this.mFaceMap.put("[\u9876]", R.drawable.emoji_047);
        this.mFaceMap.put("[\u7231\u4f60]", R.drawable.emoji_048);
        this.mFaceMap.put("[\u998b\u5634]", R.drawable.emoji_049);
        this.mFaceMap.put("[\u6ee1\u8db3]", R.drawable.emoji_050);
        this.mFaceMap.put("[\u59d4\u5c48]", R.drawable.emoji_051);
        this.mFaceMap.put("[\u7761]", R.drawable.emoji_052);
        this.mFaceMap.put("[\u62dc\u6258]", R.drawable.emoji_053);
        this.mFaceMap.put("[\u54fc\u6b4c]", R.drawable.emoji_054);
        this.mFaceMap.put("[\u5f00\u5fc3]", R.drawable.emoji_055);
        this.mFaceMap.put("[\u9c9c\u82b1]", R.drawable.emoji_056);
        this.mFaceMap.put("[\u62b1\u62b1]", R.drawable.emoji_057);
        this.mFaceMap.put("[\u8d5e]", R.drawable.emoji_058);
        this.mFaceMap.put("[\u63e1\u624b]", R.drawable.emoji_059);
        this.mFaceMap.put("[\u5f3a]", R.drawable.emoji_060);
        this.mFaceMap.put("[\u5f31]", R.drawable.emoji_061);
        this.mFaceMap.put("[\u80dc\u5229]", R.drawable.emoji_062);
        this.mFaceMap.put("[\u62b1\u62f3]", R.drawable.emoji_063);
        this.mFaceMap.put("[\u52fe\u5f15]", R.drawable.emoji_064);
        this.mFaceMap.put("[\u8868\u767d]", R.drawable.emoji_065);
        this.mFaceMap.put("[\u5dee\u52b2]", R.drawable.emoji_066);
        this.mFaceMap.put("[\u62f3\u5934]", R.drawable.emoji_067);
        this.mFaceMap.put("[no]", R.drawable.emoji_068);
        this.mFaceMap.put("[ok]", R.drawable.emoji_069);
        this.mFaceMap.put("[\u7231\u5fc3]", R.drawable.emoji_070);
        this.mFaceMap.put("[\u5fc3\u788e]", R.drawable.emoji_071);
        this.mFaceMap.put("[\u6492\u82b1]", R.drawable.emoji_072);
    }

    private List<EaseEmojicon> initEmojiconList() {
        ArrayList<EaseEmojicon> emojiconList = new ArrayList<EaseEmojicon>();
        for (String emojiconKeyString : this.faceKeys) {
            EaseEmojicon emojicon = new EaseEmojicon(this.mFaceMap.get(emojiconKeyString), emojiconKeyString, EaseEmojicon.Type.NORMAL);
            emojiconList.add(emojicon);
        }
        return emojiconList;
    }

    public List<EaseEmojicon> getEmojiconList() {
        if (this.emojiconList != null) {
            return this.emojiconList;
        }
        this.emojiconList = this.initEmojiconList();
        return this.emojiconList;
    }

    public CharSequence convertNormalStringToSpannableString(Context mContext, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        SpannableString value = SpannableString.valueOf((CharSequence)message);
        Matcher localMatcher = EMOTION_URL.matcher((CharSequence)value);
        while (localMatcher.find()) {
            String str2 = localMatcher.group(0);
            int k = localMatcher.start();
            int m = localMatcher.end();
            if (m - k >= 12 || !this.getFaceMap().containsKey(str2)) continue;
            ImageCache imageCache = ImageCache.getInstance();
            Bitmap newBitmap = null;
            if (imageCache.get(str2) != null) {
                newBitmap = imageCache.get(str2);
            } else {
                int face = this.getFaceMap().get(str2);
                Bitmap bitmap = BitmapFactory.decodeResource((Resources)mContext.getResources(), (int)face);
                int edittext_emojicon_size = (int)mContext.getResources().getDimension(R.dimen.moments_emotion_edittext_size);
                if (bitmap != null) {
                    int rawHeigh = bitmap.getHeight();
                    int rawWidth = bitmap.getHeight();
                    int newHeight = edittext_emojicon_size;
                    int newWidth = edittext_emojicon_size;
                    float heightScale = (float)newHeight / (float)rawHeigh;
                    float widthScale = (float)newWidth / (float)rawWidth;
                    Matrix matrix = new Matrix();
                    matrix.postScale(heightScale, widthScale);
                    newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)rawWidth, (int)rawHeigh, (Matrix)matrix, (boolean)true);
                    imageCache.put(str2, newBitmap);
                    bitmap.recycle();
                }
            }
            ImageSpan imageSpan = new ImageSpan(mContext, newBitmap);
            value.setSpan((Object)imageSpan, k, m, 33);
        }
        return value;
    }

    static {
        EMOTION_URL = Pattern.compile("\\[(\\S+?)\\]");
    }
}

