/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.manager;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.os.Environment;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.utils.BitmapUtils;

public class FileTypeManager {
    private static final String[] pics = new String[]{"jpg", "png", "bmp", "jpeg", "gif"};
    private static final String[] videos = new String[]{"avi", "rmvb", "rm", "asf", "divx", "mpg", "mpeg", "mpe", "wmv", "mp4", "mkv", "vob"};
    private static final String[] musics = new String[]{"mp3", "wma", "aac", "wav", "flac", "ogg", "ape", "amr", "m4a"};
    private static final String[] zips = new String[]{"zip", "rar", "7z"};
    private static final String[] txts = new String[]{"txt"};
    private static final String[] doc = new String[]{"doc", "docx", "dot", "dotx"};
    private static final String[] ppt = new String[]{"ppt", "pptx"};
    private static final String[] xls = new String[]{"xls", "xlsx"};
    private static final String[] pdf = new String[]{"pdf"};
    private static final String[] apk = new String[]{"apk"};

    public static FileType getFileType(String fileName) {
        String fileExt = FileUtils.getFileExtension((String)fileName);
        return FileTypeManager.getType(fileExt);
    }

    public static AppendixBean fileAppendixBean(String path) {
        AppendixBean bean = new AppendixBean();
        bean.setPath(path);
        FileType fileType = FileTypeManager.getFileType(path);
        switch (fileType) {
            case IMAGE: {
                bean.setType(AppendixBean.TYPE.IMAGE);
                String scalePath = BitmapUtils.compPicture(path);
                if (scalePath != null) {
                    bean.setScalePath(scalePath);
                }
                bean.setMiniMap(BitmapUtils.getMiniMap(path));
                break;
            }
            case VIDEO: {
                bean.setType(AppendixBean.TYPE.VIDEO);
                bean.setVideoTime(FileTypeManager.getLocalVideoDuration(path));
                bean.setThumbPath(FileTypeManager.getVideoThumbBitmap(path));
                break;
            }
            default: {
                bean.setType(AppendixBean.TYPE.FILE);
                bean.setResId(FileTypeManager.getFileIconRes(fileType));
            }
        }
        return bean;
    }

    public static FileType getType(String fileExt) {
        if (FileTypeManager.contain(fileExt, pics)) {
            return FileType.IMAGE;
        }
        if (FileTypeManager.contain(fileExt, videos)) {
            return FileType.VIDEO;
        }
        if (FileTypeManager.contain(fileExt, zips)) {
            return FileType.ZIP;
        }
        if (FileTypeManager.contain(fileExt, txts)) {
            return FileType.TXT;
        }
        if (FileTypeManager.contain(fileExt, musics)) {
            return FileType.MUSIC;
        }
        if (FileTypeManager.contain(fileExt, doc)) {
            return FileType.DOC;
        }
        if (FileTypeManager.contain(fileExt, ppt)) {
            return FileType.PPT;
        }
        if (FileTypeManager.contain(fileExt, xls)) {
            return FileType.XLS;
        }
        if (FileTypeManager.contain(fileExt, pdf)) {
            return FileType.PDF;
        }
        if (FileTypeManager.contain(fileExt, apk)) {
            return FileType.APK;
        }
        return FileType.OTHER;
    }

    private static boolean contain(String fileExt, String[] fileExts) {
        String lowerCaseFileExt = fileExt.toLowerCase();
        for (String fileExt1 : fileExts) {
            if (!fileExt1.equalsIgnoreCase(lowerCaseFileExt)) continue;
            return true;
        }
        return false;
    }

    public static String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    @DrawableRes
    public static int getFileIconRes(String fileExt) {
        if (TextUtils.isEmpty((CharSequence)fileExt)) {
            return R.drawable.moments_icon_file_unknown;
        }
        if (FileTypeManager.contain(fileExt, pics)) {
            return R.drawable.moments_icon_file_image;
        }
        if (FileTypeManager.contain(fileExt, videos)) {
            return R.drawable.moments_icon_file_video;
        }
        if (FileTypeManager.contain(fileExt, zips)) {
            return R.drawable.moments_icon_file_zip;
        }
        if (FileTypeManager.contain(fileExt, txts)) {
            return R.drawable.moments_icon_file_txt;
        }
        if (FileTypeManager.contain(fileExt, musics)) {
            return R.drawable.moments_icon_file_audio;
        }
        if (FileTypeManager.contain(fileExt, doc)) {
            return R.drawable.moments_icon_file_doc;
        }
        if (FileTypeManager.contain(fileExt, ppt)) {
            return R.drawable.moments_icon_file_ppt;
        }
        if (FileTypeManager.contain(fileExt, xls)) {
            return R.drawable.moments_icon_file_xls;
        }
        if (FileTypeManager.contain(fileExt, pdf)) {
            return R.drawable.moments_icon_file_pdf;
        }
        if (FileTypeManager.contain(fileExt, apk)) {
            return R.drawable.moments_icon_file_apk;
        }
        return R.drawable.moments_icon_file_unknown;
    }

    public static int getFileIconRes(FileType fileType) {
        switch (fileType) {
            case VIDEO: {
                return R.drawable.moments_icon_file_video;
            }
            case IMAGE: {
                return R.drawable.moments_icon_file_image;
            }
            case TXT: {
                return R.drawable.moments_icon_file_txt;
            }
            case PPT: {
                return R.drawable.moments_icon_file_ppt;
            }
            case PDF: {
                return R.drawable.moments_icon_file_pdf;
            }
            case APK: {
                return R.drawable.moments_icon_file_apk;
            }
            case DOC: {
                return R.drawable.moments_icon_file_doc;
            }
            case XLS: {
                return R.drawable.moments_icon_file_xls;
            }
            case ZIP: {
                return R.drawable.moments_icon_file_zip;
            }
            case MUSIC: {
                return R.drawable.moments_icon_file_audio;
            }
            case OTHER: {
                return R.drawable.moments_icon_file_unknown;
            }
        }
        return R.drawable.moments_icon_file_unknown;
    }

    public static String getVideoThumbBitmap(String fullPath) {
        String thumbPath = "";
        Bitmap thumbnail = ThumbnailUtils.createVideoThumbnail((String)fullPath, (int)2);
        if (thumbnail == null) {
            Log.d((String)"AppendixBeanUtil", (String)"Failed to generate video preview");
        } else {
            thumbPath = BitmapUtils.saveBitmap(thumbnail, Environment.getExternalStorageDirectory().getAbsolutePath() + "/moments/thumb/");
            Log.d((String)"AppendixBeanUtil", (String)("getVideoThumbBitmap video path:" + thumbPath));
            thumbnail.recycle();
        }
        return thumbPath;
    }

    public static int getLocalVideoDuration(String videoPath) {
        int duration;
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(videoPath);
            duration = Integer.parseInt(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return duration;
    }

    public static enum FileType {
        IMAGE,
        VIDEO,
        ZIP,
        TXT,
        MUSIC,
        DOC,
        PPT,
        XLS,
        PDF,
        APK,
        OTHER;

    }
}

