/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.manager.data;

import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.database.domain.MomentsPower;
import com.xdja.moments.sdk.database.domain.NewCommentsNotification;
import com.xdja.moments.sdk.repository.MomentsClassifyRepository;
import com.xdja.moments.sdk.repository.MomentsConfigRepository;
import com.xdja.moments.sdk.repository.MomentsPowerRepository;
import com.xdja.moments.sdk.repository.MomentsReviewRepository;
import com.xdja.moments.sdk.repository.NewCommentsRepository;
import com.xdja.moments.sdk.repository.NewMomentsRepository;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.List;

public class MomentOutsideDataManager {
    private static MomentOutsideDataManager mInstance;
    private NewCommentsRepository newCommentsRepository = new NewCommentsRepository();
    private NewMomentsRepository newMomentsRepository = new NewMomentsRepository();
    private MomentsReviewRepository momentsReviewRepository = new MomentsReviewRepository();
    private MomentsConfigRepository momentsConfigRepository = new MomentsConfigRepository();
    private MomentsPowerRepository momentsPowerRepository = new MomentsPowerRepository();
    private MomentsClassifyRepository momentsClassifyRepository = new MomentsClassifyRepository();

    private MomentOutsideDataManager() {
    }

    public static synchronized MomentOutsideDataManager getInstance() {
        if (null == mInstance) {
            mInstance = new MomentOutsideDataManager();
        }
        return mInstance;
    }

    public Flowable<List<NewCommentsNotification>> getNewComments() {
        return this.newCommentsRepository.getNewComments();
    }

    public Maybe<Boolean> clearNewComments() {
        return this.newCommentsRepository.clear();
    }

    public Flowable<Integer> getNewMommentsCount() {
        return this.newMomentsRepository.getNewMomentsCount();
    }

    public Flowable<Integer> getNewMommentsCount(String classifyId) {
        return this.newMomentsRepository.getNewMomentsCount(classifyId);
    }

    public Flowable<Integer> getRevidewCount() {
        return this.momentsReviewRepository.getMomentsReviewCount();
    }

    public Flowable<Integer> getRevidewCount(String type) {
        return this.momentsReviewRepository.getMomentsReviewCount(type);
    }

    public Maybe<Boolean> removeRevidewCount(String type) {
        return this.momentsReviewRepository.removeMomentsReview(type);
    }

    public Maybe<Boolean> clearRevidewCount() {
        return this.momentsReviewRepository.clear();
    }

    public Flowable<MomentsConfig> getMomentConfig() {
        return this.momentsConfigRepository.getMomentsConfig();
    }

    public Flowable<MomentsPower> getMomentPower() {
        return this.momentsPowerRepository.getMomentsPower();
    }

    public Flowable<List<MomentsClassify>> getMomentClassify() {
        return this.momentsClassifyRepository.getCanPublishClassifyList();
    }
}

