/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.repository;

import android.support.annotation.NonNull;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.rx.MaybeTransfor;
import com.xdja.moments.sdk.database.dao.BaseDao;
import io.reactivex.Maybe;
import java.util.List;

public abstract class BaseRepository<T> {
    @NonNull
    abstract BaseDao<T> getDao();

    public Maybe<Boolean> insert(T t) {
        return Maybe.create(emitter -> {
            this.getDao().insertItem(t);
            emitter.onSuccess((Object)true);
            Logger.d((Object)("\u5f02\u6b65\u63d2\u5165\u6570\u636e\u6210\u529f\uff1a" + t.getClass().getSimpleName()));
        }).compose(MaybeTransfor.io_main());
    }

    public void insertAsync(T t) {
        this.getDao().insertItem(t);
        Logger.d((Object)("\u540c\u6b65\u63d2\u5165\u6570\u636e\u6210\u529f\uff1a" + t.getClass().getSimpleName()));
    }

    public Maybe<Boolean> insert(List<T> t) {
        return Maybe.create(emitter -> {
            this.getDao().insertItems(t);
            emitter.onSuccess((Object)true);
            if (t != null && t.size() > 0) {
                Logger.d((Object)String.format("\u5f02\u6b65\u63d2\u5165\u6570\u636e\u6210\u529f\uff1aList<%s>", t.get(0).getClass().getSimpleName()));
            }
        }).compose(MaybeTransfor.io_main());
    }

    public void insertAsync(List<T> t) {
        this.getDao().insertItems(t);
        if (t != null && t.size() > 0) {
            Logger.d((Object)String.format("\u540c\u6b65\u63d2\u5165\u6570\u636e\u6210\u529f\uff1aList<%s>", t.get(0).getClass().getSimpleName()));
        }
    }

    public Maybe<Boolean> update(T t) {
        return Maybe.create(emitter -> {
            this.getDao().updateItem(t);
            emitter.onSuccess((Object)true);
            Logger.d((Object)("\u5f02\u6b65\u66f4\u65b0\u6570\u636e\u6210\u529f\uff1a" + t.getClass().getSimpleName()));
        }).compose(MaybeTransfor.io_main());
    }

    public void updateAsync(T t) {
        this.getDao().updateItem(t);
        Logger.d((Object)("\u540c\u6b65\u66f4\u65b0\u6570\u636e\u6210\u529f\uff1a" + t.getClass().getSimpleName()));
    }

    public Maybe<Boolean> delete(T t) {
        return Maybe.create(emitter -> {
            this.getDao().deleteItem(t);
            emitter.onSuccess((Object)true);
            Logger.d((Object)("\u5f02\u6b65\u5220\u9664\u6570\u636e\u6210\u529f\uff1a" + t.getClass().getSimpleName()));
        }).compose(MaybeTransfor.io_main());
    }

    public void deleteAsync(T t) {
        this.getDao().deleteItem(t);
        Logger.d((Object)("\u540c\u6b65\u5220\u9664\u6570\u636e\u6210\u529f\uff1a" + t.getClass().getSimpleName()));
    }
}

