/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.repository;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.database.dao.BaseDao;
import com.xdja.moments.sdk.database.dao.DownInfoDao;
import com.xdja.moments.sdk.database.db.MomentsRoomDatabase;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.repository.BaseRepository;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;

public class DownInfoRepository
extends BaseRepository<DownInfo> {
    DownInfoDao dao = MomentsRoomDatabase.getDatabase().momentDownInfoDao();
    private static DownInfoRepository instance;

    private DownInfoRepository() {
    }

    public static DownInfoRepository getInstance() {
        if (instance == null) {
            instance = new DownInfoRepository();
        }
        return instance;
    }

    @Override
    @NonNull
    BaseDao<DownInfo> getDao() {
        return this.dao;
    }

    public Flowable<DownInfo> getDownloadInfoByFileId(String fileId) {
        if (!TextUtils.isEmpty((CharSequence)fileId) && !fileId.contains("http://")) {
            fileId = this.generateUrl(fileId);
        }
        String finalFileId = fileId;
        return Flowable.create(emitter -> {
            DownInfo downInfo = this.dao.getDownInfo(finalFileId);
            if (downInfo == null) {
                downInfo = new DownInfo();
                downInfo.setFileId(finalFileId);
                downInfo.setUrl(finalFileId);
                downInfo.setSavePath(FileUtil.getSavePath(finalFileId));
                this.dao.insertItem(downInfo);
            } else if (!FileUtil.isFileExist(downInfo.getSavePath())) {
                downInfo.setState(DownState.START);
                downInfo.setReadLength(0L);
            }
            emitter.onNext((Object)downInfo);
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).compose(FlowableTransfor.io_main());
    }

    private String generateUrl(String imageFileId) {
        return MomentImageUtil.getImageUrl(imageFileId);
    }
}

