/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.repository;

import com.xdja.baselibrary.rx.MaybeTransfor;
import com.xdja.moments.sdk.database.dao.BaseDao;
import com.xdja.moments.sdk.database.dao.MomentsReviewDao;
import com.xdja.moments.sdk.database.db.MomentsRoomDatabase;
import com.xdja.moments.sdk.database.domain.MomentsReviewNotification;
import com.xdja.moments.sdk.repository.BaseRepository;
import io.reactivex.Flowable;
import io.reactivex.Maybe;

public class MomentsReviewRepository
extends BaseRepository<MomentsReviewNotification> {
    private MomentsReviewDao momentsReviewDao;

    public MomentsReviewRepository() {
        MomentsRoomDatabase momentsRoomDatabase = MomentsRoomDatabase.getDatabase();
        this.momentsReviewDao = momentsRoomDatabase.momentsReviewDao();
    }

    public Flowable<Integer> getMomentsReviewCount() {
        return this.momentsReviewDao.getMomentsReviewCount();
    }

    public Flowable<Integer> getMomentsReviewCount(String type) {
        return this.momentsReviewDao.getMomentsReviewCount(type);
    }

    public Maybe<Boolean> clear() {
        return Maybe.create(emitter -> {
            this.momentsReviewDao.deleteAll();
            emitter.onSuccess((Object)true);
        }).compose(MaybeTransfor.io_main());
    }

    public void clearAsync() {
        this.momentsReviewDao.deleteAll();
    }

    public Maybe<Boolean> removeMomentsReview(String type) {
        return Maybe.create(emitter -> {
            this.momentsReviewDao.deleteMomentsReviewByType(type);
            emitter.onSuccess((Object)true);
        }).compose(MaybeTransfor.io_main());
    }

    @Override
    BaseDao<MomentsReviewNotification> getDao() {
        return this.momentsReviewDao;
    }
}

