/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.baselibrary.util.StringUtils;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.manager.FileTypeManager;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

public class FileUtil {
    private static String kB_UNIT_NAME = "KB";
    private static String B_UNIT_NAME = "B";
    private static String MB_UNIT_NAME = "MB";

    @DrawableRes
    public static int getFileDrawable(String fileExtension) {
        if (TextUtils.isEmpty((CharSequence)fileExtension)) {
            return R.drawable.moments_icon_file_unknown;
        }
        if (FileUtil.isExcelFile(fileExtension)) {
            return R.drawable.moments_icon_file_xls;
        }
        if (FileUtil.isDocFile(fileExtension)) {
            return R.drawable.moments_icon_file_doc;
        }
        if (FileUtil.isPPTFile(fileExtension)) {
            return R.drawable.moments_icon_file_ppt;
        }
        if (FileUtil.isPDFFile(fileExtension)) {
            return R.drawable.moments_icon_file_pdf;
        }
        if (FileUtil.isTxtFile(fileExtension)) {
            return R.drawable.moments_icon_file_txt;
        }
        if (FileUtil.isImageFile(fileExtension)) {
            return R.drawable.moments_icon_file_image;
        }
        if (FileUtil.isVoiceFile(fileExtension)) {
            return R.drawable.moments_icon_file_audio;
        }
        if (FileUtil.isVideoFile(fileExtension)) {
            return R.drawable.moments_icon_file_video;
        }
        if (FileUtil.isRarFile(fileExtension)) {
            return R.drawable.moments_icon_file_rar;
        }
        if (FileUtil.isAPkFile(fileExtension)) {
            return R.drawable.moments_icon_file_apk;
        }
        return R.drawable.moments_icon_file_unknown;
    }

    public static boolean isAllDoucmentFile(String path) {
        String[] types = new String[]{"xls", "xlsx", "doc", "docx", "dot", "dotx", "ppt", "pptx", "pdf", "txt"};
        return FileUtil.contains(types, path);
    }

    public static boolean isRarFile(String path) {
        String[] types = new String[]{"zip", "rar"};
        return FileUtil.contains(types, path);
    }

    public static boolean isExcelFile(String path) {
        String[] types = new String[]{"xls", "xlsx"};
        return FileUtil.contains(types, path);
    }

    public static boolean isDocFile(String path) {
        String[] types = new String[]{"doc", "docx", "dot", "dotx"};
        return FileUtil.contains(types, path);
    }

    public static boolean isPPTFile(String path) {
        String[] types = new String[]{"ppt", "pptx"};
        return FileUtil.contains(types, path);
    }

    public static boolean isPDFFile(String path) {
        String[] types = new String[]{"pdf"};
        return FileUtil.contains(types, path);
    }

    public static boolean isTxtFile(String path) {
        String[] types = new String[]{"txt"};
        return FileUtil.contains(types, path);
    }

    public static boolean isVoiceFile(String path) {
        String[] types = new String[]{"mp3", "wav", "aac", "amr", "ogg", "m4a"};
        return FileUtil.contains(types, path);
    }

    public static boolean isVideoFile(String path) {
        String[] types = new String[]{"mp4", "3gp", "avi"};
        return FileUtil.contains(types, path);
    }

    public static boolean isImageFile(String path) {
        String[] types = new String[]{"png", "jpeg", "jpg", "gif", "bmp"};
        return FileUtil.contains(types, path);
    }

    public static boolean isAPkFile(String path) {
        String[] types = new String[]{"apk"};
        return FileUtil.contains(types, path);
    }

    public static boolean isFileExist(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static long getFileSize(String path) {
        int temp = 0;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return 0L;
        }
        File file = new File(path);
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        if (!file.isDirectory()) {
            return 0L;
        }
        for (File f : file.listFiles()) {
            if (f.isFile()) {
                temp = (int)((long)temp + f.length());
                continue;
            }
            if (!f.isDirectory()) continue;
            temp = (int)((long)temp + FileUtil.getFileSize(f.getAbsolutePath()));
        }
        return temp;
    }

    public static boolean contains(String[] types, String path) {
        for (String string2 : types) {
            if (!path.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getSizeString(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + B_UNIT_NAME;
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + kB_UNIT_NAME;
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + (size % 100L < 10L ? "0" : "") + String.valueOf(size % 100L) + MB_UNIT_NAME;
    }

    public static String getFileExtension(String filePath) {
        try {
            return filePath.substring(filePath.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getFileMD5(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        if (bigInt.toString(16).length() < 32) {
            String s = "";
            for (int i = 0; i < 32 - bigInt.toString(16).length(); ++i) {
                s = s + "0";
            }
            return s + bigInt.toString(16);
        }
        return bigInt.toString(16);
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        return filePosi == -1 ? filePath : filePath.substring(filePosi + 1);
    }

    public static String getFastdfsFileId(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        return url.replace(ConstantUrl.getFastdfsUrl(), "");
    }

    public static boolean isLocalHasFile(String url) {
        return FileUtil.isFileExist(FileUtil.getSavePath(FileUtil.getFastdfsFileId(url)));
    }

    public static String getSavePath(String fileId) {
        FileTypeManager.FileType fileType = FileTypeManager.getType(FileUtil.getFileExtension(fileId));
        StringBuilder stringBuilder = new StringBuilder();
        switch (fileType) {
            case IMAGE: {
                stringBuilder.append(MomentsConstants.PICTURE_FOLDER);
                break;
            }
            case VIDEO: {
                stringBuilder.append(MomentsConstants.VIDEO_FOLDER);
                break;
            }
            default: {
                stringBuilder.append(MomentsConstants.FILE_FOLDER);
            }
        }
        return stringBuilder.append(FileUtil.getFileName(fileId)).toString();
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileExtension(file.getPath());
    }

    public static String getFileMineType(File file) {
        String end = FileUtil.getFileExtension(file);
        if (end.equals("m4a") || end.equals("mp3") || end.equals("mid") || end.equals("xmf") || end.equals("ogg") || end.equals("wav")) {
            return "audio/*";
        }
        if (end.equals("3gp") || end.equals("mp4")) {
            return "video/*";
        }
        if (end.equals("jpg") || end.equals("gif") || end.equals("png") || end.equals("jpeg") || end.equals("bmp")) {
            return "image/*";
        }
        if (end.equals("apk")) {
            return "application/vnd.android.package-archive";
        }
        if (end.equals("html") || end.equals("htm")) {
            return "text/html/*";
        }
        if (end.equals("ppt") || end.equals("pptx")) {
            return "application/vnd.ms-powerpoint";
        }
        if (end.equals("xls") || end.equals("xlsx")) {
            return "application/vnd.ms-excel";
        }
        if (end.equals("doc") || end.equals("docx")) {
            return "application/msword";
        }
        if (end.equals("pdf")) {
            return "application/pdf";
        }
        if (end.equals("chm")) {
            return "application/x-chm";
        }
        if (end.equals("txt")) {
            return "text/plain";
        }
        return "*/*";
    }
}

