/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.app.Activity;
import android.support.annotation.StyleRes;
import com.orhanobut.logger.Logger;
import java.lang.reflect.Method;
import java.util.List;

public class MomentComponentUtil {
    private static final String MOMENT_FILE_COMPONENT_CLASS_NAME = "com.moments.filepicker.FilePickerComponent";
    private static final String MOMENT_COMPONENT_METHOD_PICK_FILE = "selectFile";
    private static final String MOMENT_VIDEO_COMPONENT_CLASS_NAME = "com.moments.landscapevideocapture.VideoComponent";
    private static final String MOMENT_COMPONENT_METHOD_CAPTURE_VIDEO = "captureVideo";
    private static final String MOMENT_LOCATION_COMPONENT_CLASS_NAME = "com.moments.location.LocationComponent";
    private static final String MOMENT_COMPONENT_METHOD_START_LOCATE = "startLocationActivity";
    private static final String MOMENT_COMPONENT_METHOD_LOCATION_DETAIL = "startLocationDetailActivity";
    private static final String MOMENT_COMPONENT_METHOD_LOCTION_HELPER = "getLocationHelper";
    private static final String MOMENT_IMAGE_PICKER_COMPONENT_CLASS_NAME = "com.moments.imagepicker.ImagePickerComponent";
    private static final String MOMENT_COMPONENT_METHOD_PICK_PICTURE = "pickImage";
    private static final String MOMENT_COMPONENT_METHOD_PICK_VIDEO = "pickVideo";
    private static MomentComponentUtil mInstance;

    private MomentComponentUtil() {
    }

    public static synchronized MomentComponentUtil getInstance() {
        if (null == mInstance) {
            mInstance = new MomentComponentUtil();
        }
        return mInstance;
    }

    public boolean isVideoComponentExit() {
        return this.isClassExit(MOMENT_VIDEO_COMPONENT_CLASS_NAME);
    }

    public boolean captureVideo(Activity activity, int requestCode) {
        try {
            Class<?> obj = Class.forName(MOMENT_VIDEO_COMPONENT_CLASS_NAME);
            if (obj == null) {
                return false;
            }
            Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_CAPTURE_VIDEO, Activity.class, Integer.TYPE);
            method.invoke(obj.newInstance(), activity, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isFilePickerComponentExit() {
        return this.isClassExit(MOMENT_FILE_COMPONENT_CLASS_NAME);
    }

    public boolean pickFile(Activity activity, int requestCode, int maxChoose, int maxSingleFileSize, @StyleRes int style2) {
        try {
            Class<?> obj = Class.forName(MOMENT_FILE_COMPONENT_CLASS_NAME);
            if (obj == null) {
                return false;
            }
            Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_PICK_FILE, Activity.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.invoke(obj.newInstance(), activity, maxChoose, maxSingleFileSize, requestCode, style2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isLocationComponentExit() {
        return this.isClassExit(MOMENT_LOCATION_COMPONENT_CLASS_NAME);
    }

    public boolean startLocation(Activity context, boolean isFromPublish, String address, String addressDetail, double longitude, double latitude, String cityCode, int requestCode) {
        try {
            Class<?> obj = Class.forName(MOMENT_LOCATION_COMPONENT_CLASS_NAME);
            if (obj == null) {
                return false;
            }
            Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_START_LOCATE, Activity.class, Boolean.TYPE, String.class, String.class, Double.TYPE, Double.TYPE, String.class, Integer.TYPE);
            method.invoke(obj.newInstance(), context, isFromPublish, address, addressDetail, longitude, latitude, cityCode, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean startLocationDetail(Activity context, String address, String addressDetail, double longitude, double latitude) {
        try {
            Class<?> obj = Class.forName(MOMENT_LOCATION_COMPONENT_CLASS_NAME);
            if (obj == null) {
                return false;
            }
            Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_LOCATION_DETAIL, Activity.class, String.class, String.class, Double.TYPE, Double.TYPE);
            method.invoke(obj.newInstance(), context, address, addressDetail, longitude, latitude);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Object getLocationHelper() {
        try {
            Class<?> obj = Class.forName(MOMENT_LOCATION_COMPONENT_CLASS_NAME);
            if (obj != null) {
                Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_LOCTION_HELPER, new Class[0]);
                return method.invoke(obj.newInstance(), new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isImagePickerComponentExit() {
        return this.isClassExit(MOMENT_IMAGE_PICKER_COMPONENT_CLASS_NAME);
    }

    public boolean pickPicture(Activity context, List<String> selectedImagePaths, int maxLimit, int requestCode) {
        try {
            Class<?> obj = Class.forName(MOMENT_IMAGE_PICKER_COMPONENT_CLASS_NAME);
            if (obj == null) {
                return false;
            }
            Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_PICK_PICTURE, Activity.class, List.class, Integer.TYPE, Integer.TYPE);
            method.invoke(obj.newInstance(), context, selectedImagePaths, maxLimit, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean pickVideo(Activity context, List<String> selectedVideoPath, int maxLimit, int requestCode) {
        try {
            Class<?> obj = Class.forName(MOMENT_IMAGE_PICKER_COMPONENT_CLASS_NAME);
            if (obj == null) {
                return false;
            }
            Method method = obj.getMethod(MOMENT_COMPONENT_METHOD_PICK_VIDEO, Activity.class, List.class, Integer.TYPE, Integer.TYPE);
            method.invoke(obj.newInstance(), context, selectedVideoPath, maxLimit, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean isClassExit(String className) {
        Class<?> obj;
        try {
            obj = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Logger.d((Object)("moment " + className + " not exist"));
            return false;
        }
        return obj != null;
    }
}

