/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.view.View;
import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.manager.MomentsManager;

public class MomentImageUtil {
    public static String getImageUrl(String orgUrl) {
        String[] imageUrlSplit = orgUrl.split("&");
        return ConstantUrl.getFastdfsUrl() + imageUrlSplit[0];
    }

    public static String getThumbnail(String orgUrl, int width, int height) {
        return orgUrl + "_" + width + "x" + height + ".jpg";
    }

    private static int getImageWidth(String url, int maxSize) {
        int width = 0;
        String[] imageUrlSplit = url.split("&");
        if (imageUrlSplit.length >= 2) {
            String imageSize = imageUrlSplit[1];
            String[] sizeSplit = imageSize.split("\\*");
            width = sizeSplit.length == 2 ? Integer.parseInt(sizeSplit[0]) : maxSize;
        }
        if (width == 0) {
            width = maxSize;
        }
        return width;
    }

    public static int getImageWidth(String url) {
        int maxPhotoWidth = (int)MomentsManager.getInstance().getContext().getResources().getDimension(R.dimen.moments_max_photo_width);
        return MomentImageUtil.getImageWidth(url, maxPhotoWidth);
    }

    private static int getImageHeight(String url, int maxSize) {
        int height = 0;
        String[] imageUrlSplit = url.split("&");
        if (imageUrlSplit.length >= 2) {
            String imageSize = imageUrlSplit[1];
            String[] sizeSplit = imageSize.split("\\*");
            height = sizeSplit.length == 2 ? Integer.parseInt(sizeSplit[1]) : maxSize;
        }
        if (height == 0) {
            height = maxSize;
        }
        return height;
    }

    public static int getImageHeight(String url) {
        int maxPhotoWidth = (int)MomentsManager.getInstance().getContext().getResources().getDimension(R.dimen.moments_max_photo_width);
        return MomentImageUtil.getImageHeight(url, maxPhotoWidth);
    }

    public static void resetLayoutParams(View iv, ImageBean imageBean) {
        if (iv == null || imageBean == null) {
            return;
        }
        int maxPhotoWidth = (int)MomentsManager.getInstance().getContext().getResources().getDimension(R.dimen.moments_max_photo_width);
        int minPhotoWidth = (int)MomentsManager.getInstance().getContext().getResources().getDimension(R.dimen.moments_min_photo_width);
        int imageWith = imageBean.getWidth();
        int imageHeight = imageBean.getHeight();
        if (imageHeight < imageWith) {
            iv.getLayoutParams().width = imageWith > maxPhotoWidth ? maxPhotoWidth : imageWith;
            iv.getLayoutParams().height = imageHeight * iv.getLayoutParams().width / imageWith;
        } else {
            iv.getLayoutParams().height = imageHeight > maxPhotoWidth ? maxPhotoWidth : imageHeight;
            iv.getLayoutParams().width = imageWith * iv.getLayoutParams().height / imageHeight;
        }
        float scale = (float)iv.getLayoutParams().height / (float)iv.getLayoutParams().width;
        if (scale > 4.0f) {
            iv.getLayoutParams().width = minPhotoWidth;
        } else if ((double)scale < 0.25) {
            iv.getLayoutParams().height = minPhotoWidth;
        }
    }
}

