/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.text.TextUtils;
import com.xdja.moments.sdk.bean.share.BaseShareBean;
import com.xdja.moments.sdk.bean.share.ShareFileBean;
import com.xdja.moments.sdk.bean.share.ShareImageBean;
import com.xdja.moments.sdk.bean.share.ShareVideoBean;
import com.xdja.moments.sdk.manager.FileTypeManager;

public class PublishShareUtil {
    public static BaseShareBean convertToShareBean(String content, String filePath) {
        BaseShareBean result;
        if (TextUtils.isEmpty((CharSequence)content) && TextUtils.isEmpty((CharSequence)filePath)) {
            return new BaseShareBean();
        }
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            FileTypeManager.FileType fileType = PublishShareUtil.getFileType(filePath);
            if (fileType != null) {
                switch (fileType) {
                    case IMAGE: {
                        ShareImageBean result2 = new ShareImageBean();
                        result2.setPath(filePath);
                        return result2;
                    }
                    case VIDEO: {
                        ShareVideoBean result3 = new ShareVideoBean();
                        result3.setPath(filePath);
                        return result3;
                    }
                }
                result = new ShareFileBean();
                ((ShareFileBean)result).setPath(filePath);
                ((ShareFileBean)result).setResId(FileTypeManager.getFileIconRes(fileType));
            } else {
                result = new BaseShareBean();
            }
        } else {
            result = new BaseShareBean();
        }
        result.setContent(content);
        return result;
    }

    private static FileTypeManager.FileType getFileType(String filePath) {
        return FileTypeManager.getFileType(filePath);
    }
}

