/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.utils.spannable.SpannableClickable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtils {
    public static SpannableStringBuilder formatUrlString(String contentStr) {
        SpannableStringBuilder sp;
        if (!TextUtils.isEmpty((CharSequence)contentStr)) {
            FaceManager faceManager = MomentsManager.getInstance().getFaceManager();
            SpannableString content = (SpannableString)faceManager.convertNormalStringToSpannableString(MomentsManager.getInstance().getContext(), contentStr);
            sp = new SpannableStringBuilder((CharSequence)content);
            try {
                Pattern urlPattern = Pattern.compile("(http|https|ftp|svn)://([a-zA-Z0-9]+[/?.?])+[a-zA-Z0-9]*\\??([a-zA-Z0-9]*=[a-zA-Z0-9]*&?)*");
                Matcher urlMatcher = urlPattern.matcher(contentStr);
                while (urlMatcher.find()) {
                    final String url = urlMatcher.group();
                    if (TextUtils.isEmpty((CharSequence)url)) continue;
                    sp.setSpan((Object)new SpannableClickable(){

                        public void onClick(View widget) {
                            Uri uri = Uri.parse((String)url);
                            Context context = widget.getContext();
                            Intent intent = new Intent("android.intent.action.VIEW", uri);
                            intent.putExtra("com.android.browser.application_id", context.getPackageName());
                            context.startActivity(intent);
                        }
                    }, urlMatcher.start(), urlMatcher.end(), 33);
                }
                Pattern phonePattern = Pattern.compile("[1][34578][0-9]{9}");
                Matcher phoneMatcher = phonePattern.matcher(contentStr);
                while (phoneMatcher.find()) {
                    final String phone = phoneMatcher.group();
                    if (TextUtils.isEmpty((CharSequence)phone)) continue;
                    sp.setSpan((Object)new SpannableClickable(){

                        public void onClick(View widget) {
                            Context context = widget.getContext();
                            Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phone)));
                            intent.setFlags(0x10000000);
                            context.startActivity(intent);
                        }
                    }, phoneMatcher.start(), phoneMatcher.end(), 33);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sp = new SpannableStringBuilder();
        }
        return sp;
    }

    public static String buildRequestPath(String path, String type) {
        return path + "?type=" + type;
    }
}

