/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.repository.MomentsConfigRepository;
import io.reactivex.disposables.CompositeDisposable;

public class MomentsConfigViewModel
extends AndroidViewModel {
    private MutableLiveData<MomentsConfig> momentsConfigMutableLiveData = new MutableLiveData();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private MomentsConfigRepository momentsConfigRepository = new MomentsConfigRepository();

    public MomentsConfigViewModel(Application application) {
        super(application);
        this.loadMomentsConfig();
    }

    private void loadMomentsConfig() {
        this.disposables.add(this.momentsConfigRepository.getMomentsConfig(MomentsManager.getInstance().getLoginer().getUserId()).compose(FlowableTransfor.io_main()).subscribe(value -> this.momentsConfigMutableLiveData.setValue(value), t -> Logger.e((String)"get momentsConfig error", (Object[])new Object[0])));
    }

    public MutableLiveData<MomentsConfig> getMomentsConfig() {
        return this.momentsConfigMutableLiveData;
    }

    public void clearMomentsConfig() {
        this.disposables.add(this.momentsConfigRepository.clear().subscribe(aBoolean -> Logger.d((Object)"\u6e05\u7a7a\u5de5\u4f5c\u5708\u914d\u7f6e\u6210\u529f"), throwable -> Logger.d((Object)"\u6e05\u7a7a\u5de5\u4f5c\u5708\u914d\u7f6e\u5931\u8d25")));
    }

    public void onCleared() {
        super.onCleared();
        this.disposables.clear();
    }
}

