/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.repository.NewMomentsRepository;
import io.reactivex.disposables.CompositeDisposable;
import java.util.List;

public class NewMomentsViewModel
extends AndroidViewModel {
    private MutableLiveData<Integer> newMomentsCount = new MutableLiveData();
    private MutableLiveData<List<String>> newMomentClassifyId = new MutableLiveData();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private NewMomentsRepository newMomentsRepository = new NewMomentsRepository();

    public NewMomentsViewModel(Application application) {
        super(application);
        this.loadNewMomentsCount();
        this.loadMomentClassifyId();
    }

    private void loadMomentClassifyId() {
        this.disposables.add(this.newMomentsRepository.getNewMomentClasifyId().compose(FlowableTransfor.io_main()).subscribe(value -> this.newMomentClassifyId.postValue(value), t -> Logger.e((String)"\u83b7\u53d6\u65b0\u5de5\u4f5c\u5708\u5206\u7c7bid", (Object[])new Object[0])));
    }

    private void loadNewMomentsCount() {
        this.disposables.add(this.newMomentsRepository.getNewMomentsCount().compose(FlowableTransfor.io_main()).subscribe(value -> this.newMomentsCount.setValue(value), t -> Logger.e((String)"\u83b7\u53d6\u65b0\u5de5\u4f5c\u5708\u6570\u76ee\u5931\u8d25", (Object[])new Object[0])));
    }

    public MutableLiveData<Integer> getNewMomentsCount() {
        return this.newMomentsCount;
    }

    public MutableLiveData<List<String>> getNewMomentClassifyId() {
        return this.newMomentClassifyId;
    }

    public void clearUnReadNumber() {
        this.disposables.add(this.newMomentsRepository.clear().subscribe(aBoolean -> Logger.d((Object)"\u6e05\u7a7a\u6240\u6709\u672a\u8bfb\u5de5\u4f5c\u5708\u6210\u529f"), throwable -> Logger.d((Object)"\u6e05\u7a7a\u6240\u6709\u672a\u8bfb\u5de5\u4f5c\u5708\u5931\u8d25")));
    }

    public void clearUnReadNumber(String classify) {
        this.disposables.add(this.newMomentsRepository.clear(classify).subscribe(aBoolean -> Logger.d((Object)String.format("\u6e05\u7a7a%s\u672a\u8bfb\u5de5\u4f5c\u5708\u6210\u529f", classify)), throwable -> Logger.d((Object)String.format("\u6e05\u7a7a%s\u672a\u8bfb\u5de5\u4f5c\u5708\u662f\u5931\u8d25", classify))));
    }

    public void onCleared() {
        super.onCleared();
        this.disposables.clear();
    }
}

