/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class CircleProgressBar
extends View {
    private int maxProgress = 100;
    private int progress = 0;
    private static final int PINDING = 16;
    RectF oval = new RectF();
    Paint paint = new Paint();

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != height) {
            int min;
            width = min = Math.min(width, height);
            height = min;
        }
        this.paint.setAntiAlias(true);
        this.paint.setColor(Color.argb((int)127, (int)0, (int)0, (int)0));
        this.paint.setStyle(Paint.Style.FILL);
        this.oval.left = 0.0f;
        this.oval.top = 0.0f;
        this.oval.right = width;
        this.oval.bottom = height;
        canvas.drawArc(this.oval, -90.0f, 360.0f, false, this.paint);
        this.paint.setColor(-1);
        int progressStrokeWidth = 10;
        this.paint.setStrokeWidth((float)progressStrokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.oval.left = 16 + progressStrokeWidth / 2;
        this.oval.top = 16 + progressStrokeWidth / 2;
        this.oval.right = width - 16 - progressStrokeWidth / 2;
        this.oval.bottom = height - 16 - progressStrokeWidth / 2;
        canvas.drawArc(this.oval, -90.0f, (float)this.progress / (float)this.maxProgress * 360.0f, false, this.paint);
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.postInvalidate();
    }
}

