/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.utils.UrlUtils;
import com.xdja.moments.sdk.utils.spannable.CircleMovementMethod;
import com.xdja.moments.sdk.utils.spannable.SpannableClickable;
import java.util.ArrayList;
import java.util.List;

public class CommentListView
extends LinearLayout {
    private static final int NEW_COMMENT_MAX_COUNT = 10;
    private int itemColor;
    private int itemSelectorColor;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private List<CommentBean> mDatas;
    private LayoutInflater layoutInflater;
    private Context mContext;
    private boolean showNewComment = true;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public void setDatas(List<CommentBean> datas, boolean showNewComment) {
        if (datas == null) {
            datas = new ArrayList<CommentBean>();
        }
        this.mDatas = datas;
        this.showNewComment = showNewComment;
        this.notifyDataSetChanged();
    }

    public List<CommentBean> getDatas() {
        return this.mDatas;
    }

    public CommentListView(Context context) {
        super(context);
        this.mContext = context;
    }

    public CommentListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    public CommentListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    protected void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.MomentsCommentListView, 0, 0);
        try {
            this.itemColor = typedArray.getColor(R.styleable.MomentsCommentListView_moments_item_color, this.getResources().getColor(R.color.moments_text_blue));
            this.itemSelectorColor = typedArray.getColor(R.styleable.MomentsCommentListView_moments_item_selector_color, this.getResources().getColor(R.color.moments_clickable_color));
        }
        finally {
            typedArray.recycle();
        }
    }

    public void notifyDataSetChanged() {
        this.removeAllViews();
        if (this.mDatas == null || this.mDatas.size() == 0) {
            return;
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        int i = 0;
        while (i < this.mDatas.size()) {
            int index;
            View view;
            if ((view = this.getView(index = i++)) == null) {
                throw new NullPointerException("listview item layout is null, please check getView()...");
            }
            this.addView(view, index, (ViewGroup.LayoutParams)layoutParams);
        }
        if (this.showNewComment && this.mDatas.size() >= 10) {
            LinearLayout.LayoutParams newCommentLayoutParams = new LinearLayout.LayoutParams(-1, -2);
            if (this.layoutInflater == null) {
                this.layoutInflater = LayoutInflater.from((Context)this.getContext());
            }
            View convertView = this.layoutInflater.inflate(R.layout.moments_item_comment_new_bottom, null, false);
            this.addView(convertView, this.mDatas.size(), (ViewGroup.LayoutParams)newCommentLayoutParams);
        }
    }

    private View getView(int position) {
        View convertView = this.getCommentRootView();
        TextView commentTv = (TextView)convertView.findViewById(R.id.commentTv);
        final CircleMovementMethod circleMovementMethod = new CircleMovementMethod(this.itemSelectorColor, this.itemSelectorColor);
        final CommentBean bean = this.mDatas.get(position);
        UserInfoBean userInfo = bean.getUserInfo();
        if (userInfo == null || TextUtils.isEmpty((CharSequence)userInfo.getUserName()) || TextUtils.isEmpty((CharSequence)userInfo.getUserId())) {
            userInfo = new UserInfoBean();
            userInfo.setUserId("");
            userInfo.setUserName("\u5df2\u5220\u9664\u7684\u7528\u6237");
        }
        String name = userInfo.getUserName();
        String id2 = userInfo.getUserId();
        UserInfoBean toUserInfo = bean.getToUserInfo();
        String toReplyName = "";
        String toReplyId = "";
        if (toUserInfo != null) {
            toReplyName = toUserInfo.getUserName();
            toReplyId = toUserInfo.getUserId();
        }
        SpannableStringBuilder builder = new SpannableStringBuilder();
        builder.append((CharSequence)this.setClickableSpan(name, id2));
        if (!TextUtils.isEmpty((CharSequence)toReplyName) && !TextUtils.isEmpty((CharSequence)toReplyId)) {
            builder.append((CharSequence)" \u56de\u590d ");
            builder.append((CharSequence)this.setClickableSpan(toReplyName, toReplyId));
        }
        builder.append((CharSequence)": ");
        String contentBodyStr = bean.getCommentContent();
        if (!TextUtils.isEmpty((CharSequence)contentBodyStr)) {
            builder.append((CharSequence)UrlUtils.formatUrlString(contentBodyStr));
        }
        commentTv.setText((CharSequence)builder);
        commentTv.setMovementMethod((MovementMethod)circleMovementMethod);
        commentTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (circleMovementMethod.isPassToTv() && CommentListView.this.onItemClickListener != null) {
                    CommentListView.this.onItemClickListener.onItemClick(bean);
                }
            }
        });
        commentTv.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (circleMovementMethod.isPassToTv()) {
                    if (CommentListView.this.onItemLongClickListener != null) {
                        CommentListView.this.onItemLongClickListener.onItemLongClick(bean);
                    }
                    return true;
                }
                return false;
            }
        });
        return convertView;
    }

    private View getCommentRootView() {
        if (this.layoutInflater == null) {
            this.layoutInflater = LayoutInflater.from((Context)this.getContext());
        }
        return this.layoutInflater.inflate(R.layout.moments_item_comment_list, null, false);
    }

    @NonNull
    private SpannableString setClickableSpan(String textStr, final String id2) {
        SpannableString subjectSpanText = new SpannableString((CharSequence)textStr);
        subjectSpanText.setSpan((Object)new SpannableClickable(this.itemColor){

            public void onClick(View widget) {
                Navigation.navigationPersonDetail(CommentListView.this.mContext, id2);
            }
        }, 0, subjectSpanText.length(), 33);
        return subjectSpanText;
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(CommentBean var1);
    }

    public static interface OnItemClickListener {
        public void onItemClick(CommentBean var1);
    }
}

