/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.xdja.baselibrary.util.DensityUtil;
import com.xdja.moments.sdk.R;
import java.util.ArrayList;
import java.util.List;

public class FontSizeView
extends View {
    private int defaultLineColor = Color.rgb((int)33, (int)33, (int)33);
    private int defaultLineWidth;
    private int defaultMax = 5;
    private int defaultCircleColor = -1;
    private int defaultCircleRadius;
    private int currentProgress;
    private int defaultPosition = 1;
    private int max = 4;
    private int lineColor = -16777216;
    private int lineWidth;
    private int textColor = -16777216;
    private int smallSize = 14;
    private int standerSize = 16;
    private int bigSize = 28;
    private int circleRadius;
    private int circleColor = -1;
    private int itemWidth;
    private int height;
    private int width;
    private Paint mLinePaint;
    private Paint mTextPaint;
    private Paint mText1Paint;
    private Paint mText2Paint;
    private Paint mCirclePaint;
    private float currentX = 0.0f;
    private List<Point> points = new ArrayList<Point>();
    private float circleY;
    private float textScaleX;
    private float text1ScaleX;
    private float text2ScaleX;
    private OnChangeCallbackListener onChangeCallbackListener;

    public FontSizeView(Context context) {
        this(context, null);
    }

    public FontSizeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.defaultLineWidth = DensityUtil.dip2px((Context)context, (float)2.0f);
        this.defaultCircleRadius = DensityUtil.dip2px((Context)context, (float)35.0f);
        this.lineWidth = DensityUtil.dip2px((Context)context, (float)1.0f) / 2;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MomentsFontSizeView);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
        this.mLinePaint = new Paint(1);
        this.mLinePaint.setColor(this.getResources().getColor(R.color.moments_color_666));
        this.mLinePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLinePaint.setStrokeWidth((float)this.lineWidth);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(this.getResources().getColor(R.color.moments_text_black));
        this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mTextPaint.setTextSize((float)DensityUtil.dip2px((Context)context, (float)this.smallSize));
        this.textScaleX = this.mTextPaint.measureText("A");
        this.mText1Paint = new Paint(1);
        this.mText1Paint.setColor(this.getResources().getColor(R.color.moments_text_black));
        this.mText1Paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mText1Paint.setTextSize((float)DensityUtil.dip2px((Context)context, (float)this.bigSize));
        this.text1ScaleX = this.mText1Paint.measureText("A");
        this.mText2Paint = new Paint(1);
        this.mText2Paint.setColor(this.getResources().getColor(R.color.moments_text_gray));
        this.mText2Paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mText2Paint.setTextSize((float)DensityUtil.dip2px((Context)context, (float)this.standerSize));
        this.text2ScaleX = this.mText2Paint.measureText("\u6807\u51c6");
        this.mCirclePaint = new Paint(1);
        this.mCirclePaint.setColor(this.circleColor);
        this.mCirclePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.setLayerType(1, null);
        this.mCirclePaint.setShadowLayer(2.0f, 0.0f, 0.0f, Color.rgb((int)33, (int)33, (int)33));
    }

    private void initCustomAttr(int attr2, TypedArray typedArray) {
        if (attr2 == R.styleable.MomentsFontSizeView_moments_lineColor) {
            this.lineColor = typedArray.getColor(attr2, this.defaultLineColor);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_circleColor) {
            this.circleColor = typedArray.getColor(attr2, this.defaultCircleColor);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_lineWidth1) {
            this.lineWidth = typedArray.getDimensionPixelSize(attr2, this.defaultLineWidth);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_circleRadius) {
            this.circleRadius = typedArray.getDimensionPixelSize(attr2, this.defaultCircleRadius);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_totalCount) {
            this.max = typedArray.getInteger(attr2, this.defaultMax);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_textFontColor) {
            this.textColor = typedArray.getColor(attr2, this.textColor);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_smallSize) {
            this.smallSize = typedArray.getInteger(attr2, this.smallSize);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_standerSize) {
            this.standerSize = typedArray.getInteger(attr2, this.standerSize);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_bigSize) {
            this.bigSize = typedArray.getInteger(attr2, this.bigSize);
        } else if (attr2 == R.styleable.MomentsFontSizeView_moments_defaultPosition) {
            this.defaultPosition = typedArray.getInteger(attr2, this.defaultPosition);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = h;
        this.width = w;
        this.circleY = this.height / 2;
        this.itemWidth = (w - 2 * this.circleRadius) / this.max;
        for (int i = 0; i <= this.max; ++i) {
            this.points.add(new Point(this.circleRadius + i * this.itemWidth, this.height / 2));
        }
        this.currentX = this.points.get((int)this.defaultPosition).x;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawText("A", (float)this.points.get((int)0).x - this.textScaleX / 2.0f, (float)(this.height / 2 - 50), this.mTextPaint);
        canvas.drawText("\u6807\u51c6", (float)this.points.get((int)1).x - this.text2ScaleX / 2.0f, (float)(this.height / 2 - 50), this.mText2Paint);
        canvas.drawText("A", (float)this.points.get((int)(this.points.size() - 1)).x - this.text1ScaleX / 2.0f, (float)(this.height / 2 - 50), this.mText1Paint);
        canvas.drawLine((float)this.points.get((int)0).x, (float)(this.height / 2 + 32), (float)this.points.get((int)(this.points.size() - 1)).x, (float)(this.height / 2 + 32), this.mLinePaint);
        for (Point point : this.points) {
            canvas.drawLine((float)(point.x + 1), (float)(this.height / 2 + 20), (float)(point.x + 1), (float)(this.height / 2 + 50), this.mLinePaint);
        }
        if (this.currentX < (float)this.circleRadius) {
            this.currentX = this.circleRadius;
        }
        if (this.currentX > (float)(this.width - this.circleRadius)) {
            this.currentX = this.width - this.circleRadius;
        }
        canvas.drawCircle(this.currentX + 1.0f, this.circleY + 32.0f, (float)this.circleRadius, this.mCirclePaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.currentX = event.getX();
        switch (event.getAction()) {
            case 0: {
                this.invalidate();
                break;
            }
            case 2: {
                this.invalidate();
                break;
            }
            case 1: {
                Point targetPoint = this.getNearestPoint(this.currentX);
                if (targetPoint != null) {
                    this.currentX = this.points.get((int)this.currentProgress).x;
                    this.invalidate();
                }
                if (this.onChangeCallbackListener == null) break;
                this.onChangeCallbackListener.onChangeListener(this.currentProgress);
            }
        }
        return true;
    }

    private Point getNearestPoint(float x) {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = this.points.get(i);
            if (!(Math.abs((float)point.x - x) < (float)(this.itemWidth / 2))) continue;
            this.currentProgress = i;
            return point;
        }
        return null;
    }

    public void setChangeCallbackListener(OnChangeCallbackListener listener) {
        this.onChangeCallbackListener = listener;
    }

    public void setDefaultPosition(int position) {
        this.defaultPosition = position;
        if (this.onChangeCallbackListener != null) {
            this.onChangeCallbackListener.onChangeListener(this.defaultPosition);
        }
        this.invalidate();
    }

    public static interface OnChangeCallbackListener {
        public void onChangeListener(int var1);
    }
}

