/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.support.v7.widget.AppCompatTextView;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import java.util.ArrayList;
import java.util.List;

public class MomentsSpanTextView
extends AppCompatTextView {
    private boolean dontConsumeNonUrlClicks = true;
    public static final int DEFAULT_SHOW_PRAISE_SIZE = 10;
    private boolean linkHit;

    public MomentsSpanTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setMold() {
        this.setMovementMethod((MovementMethod)new LocalLinkMovementMethod(null));
    }

    public void setCommentText(CommentBean commentBean, MemberClickListener onMemberClickListener) {
        this.setText("");
        if (commentBean.getToUserInfo() != null && !TextUtils.isEmpty((CharSequence)commentBean.getToUserInfo().getUserId())) {
            this.append("\u56de\u590d ");
            String toUserName = commentBean.getToUserInfo().getUserName();
            this.append((CharSequence)this.initCellSpanString(this.getResources().getColor(R.color.moments_text_blue), !TextUtils.isEmpty((CharSequence)toUserName) ? toUserName : "\u5df2\u5220\u9664\u7528\u6237", commentBean.getToUserInfo(), onMemberClickListener));
            this.append("\uff1a");
        }
        this.setMovementMethod((MovementMethod)new LocalLinkMovementMethod(null));
    }

    public void setUserList(List<UserInfoBean> praiseList, MemberClickListener onMemberClickListener) {
        this.setText("");
        if (praiseList == null) {
            return;
        }
        int size = praiseList.size();
        for (int i = 0; i < size; ++i) {
            UserInfoBean userInfoBean = praiseList.get(i);
            if (userInfoBean == null || TextUtils.isEmpty((CharSequence)userInfoBean.getUserName()) || TextUtils.isEmpty((CharSequence)userInfoBean.getUserId())) {
                userInfoBean = new UserInfoBean();
                userInfoBean.setUserId("");
                userInfoBean.setUserName("\u5df2\u5220\u9664\u7528\u6237");
            }
            if (userInfoBean.getUserName() == null) continue;
            this.append((CharSequence)this.initCellSpanString(this.getResources().getColor(R.color.moments_text_blue), userInfoBean.getUserName(), userInfoBean, onMemberClickListener));
            if (i == size - 1) continue;
            this.append("\uff0c");
        }
        this.setMovementMethod((MovementMethod)new LocalLinkMovementMethod(null));
    }

    public void setBasePraiseText(List<UserInfoBean> praiseList, int realPraiseSize, boolean showNewPraise, MemberClickListener onMemberClickListener) {
        this.setText("");
        if (praiseList == null) {
            return;
        }
        ArrayList<UserInfoBean> newPraiseList = new ArrayList<UserInfoBean>();
        int newPraiseSize = 0;
        if (showNewPraise) {
            newPraiseSize = praiseList.size() >= 10 ? 10 : praiseList.size();
            for (int i = 0; i < newPraiseSize; ++i) {
                newPraiseList.add(praiseList.get(i));
            }
        } else {
            newPraiseList.addAll(praiseList);
        }
        int size = newPraiseList.size();
        for (int i = 0; i < size; ++i) {
            UserInfoBean userInfoBean = (UserInfoBean)newPraiseList.get(i);
            if (userInfoBean == null || TextUtils.isEmpty((CharSequence)userInfoBean.getUserName()) || TextUtils.isEmpty((CharSequence)userInfoBean.getUserId())) {
                userInfoBean = new UserInfoBean();
                userInfoBean.setUserName("\u5df2\u5220\u9664\u7528\u6237");
                userInfoBean.setUserId("");
            }
            this.append((CharSequence)this.initCellSpanString(this.getResources().getColor(R.color.moments_text_blue), userInfoBean.getUserName(), userInfoBean, onMemberClickListener));
            if (i == size - 1) continue;
            this.append("\uff0c");
        }
        if (realPraiseSize > 0 && realPraiseSize <= 10) {
            this.append(" " + realPraiseSize + "\u4eba\u70b9\u8d5e");
        } else if (realPraiseSize > 10) {
            this.append("...");
            this.append("\u7b49" + realPraiseSize + "\u4eba\u70b9\u8d5e");
        }
        this.setMovementMethod((MovementMethod)new LocalLinkMovementMethod(null));
    }

    private SpannableString initCellSpanString(final int color2, String content, final UserInfoBean commentBean, final MemberClickListener onMemberClickListener) {
        SpannableString spanText = new SpannableString((CharSequence)content);
        Object span = onMemberClickListener == null ? new ForegroundColorSpan(color2) : new ClickableSpan(){

            public void onClick(View widget) {
                onMemberClickListener.onMemberClick(commentBean);
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(color2);
                ds.setUnderlineText(false);
                ds.setFakeBoldText(false);
            }
        };
        spanText.setSpan(span, 0, content.length(), 33);
        return spanText;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.linkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.dontConsumeNonUrlClicks) {
            return this.linkHit;
        }
        return res;
    }

    public static interface MemberClickListener {
        public void onMemberClick(UserInfoBean var1);
    }

    public static interface BodyClickListener {
        public void onBodyClick();
    }

    public class LocalLinkMovementMethod
    extends LinkMovementMethod {
        private BodyClickListener onBodyClickListener;

        public LocalLinkMovementMethod(BodyClickListener onBodyClickListener) {
            this.onBodyClickListener = onBodyClickListener;
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            int action = event.getAction();
            if (action == 1 || action == 0) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout2 = widget.getLayout();
                int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
                ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
                if (link.length != 0) {
                    if (action == 1) {
                        link[0].onClick((View)widget);
                    } else if (action == 0) {
                        Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                    }
                    if (widget instanceof MomentsSpanTextView) {
                        ((MomentsSpanTextView)widget).linkHit = true;
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)buffer);
                Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
                if (action == 1 && this.onBodyClickListener != null) {
                    this.onBodyClickListener.onBodyClick();
                }
                return false;
            }
            return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
        }
    }
}

