/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.moments.sdk.R;

public class MyProgressWheel
extends View {
    private Paint mPaints;
    private RectF mOval;
    private int layout_height = 0;
    private int layout_width = 0;
    private int barColor = 0x66000000;
    private int spinSpeed = 2;
    private int delayMillis = 0;
    int progress = 0;
    boolean isSpinning = false;

    public MyProgressWheel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributes(context.obtainStyledAttributes(attrs, R.styleable.MyProgressWheel));
    }

    public int getSpinSpeed() {
        return this.spinSpeed;
    }

    public void setSpinSpeed(int spinSpeed) {
        this.spinSpeed = spinSpeed;
    }

    private void parseAttributes(TypedArray a) {
        this.spinSpeed = (int)a.getDimension(R.styleable.MyProgressWheel_spinSpeed, (float)this.spinSpeed);
        this.delayMillis = a.getInteger(R.styleable.MyProgressWheel_delayMillis, this.delayMillis);
        if (this.delayMillis < 0) {
            this.delayMillis = 0;
        }
        this.barColor = a.getColor(R.styleable.MyProgressWheel_barColor, this.barColor);
        a.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.layout_width = w;
        this.layout_height = h;
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    private void setupPaints() {
        this.mPaints = new Paint();
        this.mPaints.setAntiAlias(true);
        this.mPaints.setStyle(Paint.Style.FILL);
        this.mPaints.setColor(this.barColor);
    }

    private void setupBounds() {
        int minValue = Math.min(this.layout_width, this.layout_height);
        int xOffset = this.layout_width - minValue;
        int yOffset = this.layout_height - minValue;
        int paddingTop = this.getPaddingTop() + yOffset / 2;
        int paddingBottom = this.getPaddingBottom() + yOffset / 2;
        int paddingLeft = this.getPaddingLeft() + xOffset / 2;
        int paddingRight = this.getPaddingRight() + xOffset / 2;
        int width = this.getWidth();
        int height = this.getHeight();
        this.mOval = new RectF((float)paddingLeft, (float)paddingTop, (float)(width - paddingRight), (float)(height - paddingBottom));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = 0;
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heigthWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        size = widthWithoutPadding > heigthWithoutPadding ? heigthWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isSpinning) {
            int barLength = 60;
            canvas.drawArc(this.mOval, (float)(this.progress - 90), (float)barLength, false, this.mPaints);
        } else {
            canvas.drawArc(this.mOval, -90.0f, (float)(this.progress - 360), true, this.mPaints);
        }
        if (this.isSpinning) {
            this.scheduleRedraw();
        }
    }

    private void scheduleRedraw() {
        this.progress += this.spinSpeed;
        if (this.progress > 360) {
            this.progress = 0;
        }
        this.postInvalidateDelayed(this.delayMillis);
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public void resetCount() {
        this.progress = 0;
        this.invalidate();
    }

    public void stopSpinning() {
        this.isSpinning = false;
        this.progress = 0;
        this.postInvalidate();
    }

    public void spin() {
        this.isSpinning = true;
        this.postInvalidate();
    }

    public void incrementProgress() {
        this.isSpinning = false;
        ++this.progress;
        if (this.progress > 360) {
            this.progress = 0;
        }
        this.postInvalidate();
    }

    public void setProgress(int i) {
        this.isSpinning = false;
        this.progress = i;
        this.postInvalidate();
    }
}

