/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.xdja.moments.sdk.R;

public class MomentsReviewDialog {
    private Dialog dialog = null;
    private EditText editText;
    private static final int MAX_LENGTH = 40;

    public void show(Context context, View.OnClickListener left, View.OnClickListener right, boolean cancelOnTouchOutside, boolean cancelable) {
        if (this.dialog == null) {
            this.dialog = new AlertDialog.Builder(context).create();
        }
        this.dialog.setCanceledOnTouchOutside(cancelOnTouchOutside);
        this.dialog.setCancelable(cancelable);
        if (context instanceof Activity) {
            this.dialog.setOwnerActivity((Activity)context);
        }
        this.dialog.setOnCancelListener(null);
        if (context instanceof Activity) {
            if (!((Activity)context).isFinishing()) {
                this.dialog.show();
            }
        } else {
            this.dialog.getWindow().setType(2003);
            this.dialog.show();
        }
        Window window = this.dialog.getWindow();
        window.setContentView(R.layout.moments_dialog_review_fail);
        window.addFlags(2);
        window.clearFlags(131080);
        window.setSoftInputMode(4);
        TextView leftBtn = (TextView)window.findViewById(R.id.dialog_left_btn);
        final TextView rightBtn = (TextView)window.findViewById(R.id.dialog_right_btn);
        final TextView remindCount = (TextView)window.findViewById(R.id.tv_remind_count);
        rightBtn.setEnabled(false);
        this.editText = (EditText)window.findViewById(R.id.et_content);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (editable.toString().length() <= 0) {
                    rightBtn.setEnabled(false);
                } else {
                    rightBtn.setEnabled(true);
                }
                remindCount.setText((CharSequence)(40 - editable.toString().length() + ""));
            }
        });
        if (left != null) {
            leftBtn.setOnClickListener(left);
        }
        if (right != null) {
            rightBtn.setOnClickListener(right);
        }
        this.showKeyboard(this.editText);
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    private void showKeyboard(final EditText editText) {
        if (editText != null) {
            editText.post(new Runnable(){

                @Override
                public void run() {
                    editText.setFocusable(true);
                    editText.setFocusableInTouchMode(true);
                    editText.requestFocus();
                    InputMethodManager inputManager = (InputMethodManager)editText.getContext().getSystemService("input_method");
                    inputManager.showSoftInput((View)editText, 0);
                }
            });
        }
    }

    public String getReviewFailReason() {
        if (this.editText != null) {
            return TextUtils.isEmpty((CharSequence)this.editText.getText().toString()) ? "" : this.editText.getText().toString();
        }
        return "";
    }

    public void hideKeyBoard(View view) {
        if (this.dialog.getWindow().getAttributes().softInputMode != 2) {
            InputMethodManager inputManager = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (view != null) {
                view = this.dialog.getCurrentFocus();
            }
            if (view != null) {
                inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
            }
        }
    }

    public void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }
}

