/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.easemob;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.widget.easemob.EaseEmojicon;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconGroupEntity;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconIndicatorView;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconMenuBase;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconPagerView;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconScrollTabBar;
import java.util.ArrayList;
import java.util.List;

public class EaseEmojiconMenu
extends EaseEmojiconMenuBase {
    private int emojiconColumns;
    private int bigEmojiconColumns;
    private final int defaultBigColumns = 4;
    private final int defaultColumns = 7;
    private EaseEmojiconScrollTabBar tabBar;
    private EaseEmojiconIndicatorView indicatorView;
    private EaseEmojiconPagerView pagerView;
    private List<EaseEmojiconGroupEntity> emojiconGroupList = new ArrayList<EaseEmojiconGroupEntity>();

    @TargetApi(value=11)
    public EaseEmojiconMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public EaseEmojiconMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public EaseEmojiconMenu(Context context) {
        super(context);
        this.init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.moments_emotion_widget_emojicon, (ViewGroup)this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MomentsEaseEmojiconMenu);
        this.emojiconColumns = ta.getInt(R.styleable.MomentsEaseEmojiconMenu_momentsEmojiconColumns, 7);
        this.bigEmojiconColumns = ta.getInt(R.styleable.MomentsEaseEmojiconMenu_momentsBigEmojiconRows, 4);
        ta.recycle();
        this.pagerView = (EaseEmojiconPagerView)this.findViewById(R.id.pager_view);
        this.indicatorView = (EaseEmojiconIndicatorView)this.findViewById(R.id.indicator_view);
        this.tabBar = (EaseEmojiconScrollTabBar)this.findViewById(R.id.tab_bar);
    }

    public void init(List<EaseEmojiconGroupEntity> groupEntities) {
        if (groupEntities == null || groupEntities.size() == 0) {
            return;
        }
        for (EaseEmojiconGroupEntity groupEntity : groupEntities) {
            this.emojiconGroupList.add(groupEntity);
            this.tabBar.addTab(groupEntity.getIcon());
        }
        this.pagerView.setPagerViewListener(new EmojiconPagerViewListener());
        this.pagerView.init(this.emojiconGroupList, this.emojiconColumns, this.bigEmojiconColumns);
        this.tabBar.setTabBarItemClickListener(new EaseEmojiconScrollTabBar.EaseScrollTabBarItemClickListener(){

            @Override
            public void onItemClick(int position) {
                EaseEmojiconMenu.this.pagerView.setGroupPostion(position);
            }
        });
    }

    public void addEmojiconGroup(EaseEmojiconGroupEntity groupEntity) {
        this.emojiconGroupList.add(groupEntity);
        this.pagerView.addEmojiconGroup(groupEntity, true);
        this.tabBar.addTab(groupEntity.getIcon());
    }

    public void addEmojiconGroup(List<EaseEmojiconGroupEntity> groupEntitieList) {
        for (int i = 0; i < groupEntitieList.size(); ++i) {
            EaseEmojiconGroupEntity groupEntity = groupEntitieList.get(i);
            this.emojiconGroupList.add(groupEntity);
            this.pagerView.addEmojiconGroup(groupEntity, i == groupEntitieList.size() - 1);
            this.tabBar.addTab(groupEntity.getIcon());
        }
    }

    public void removeEmojiconGroup(int position) {
        this.emojiconGroupList.remove(position);
        this.pagerView.removeEmojiconGroup(position);
        this.tabBar.removeTab(position);
    }

    public void setTabBarVisibility(boolean isVisible) {
        if (!isVisible) {
            this.tabBar.setVisibility(8);
        } else {
            this.tabBar.setVisibility(0);
        }
    }

    private class EmojiconPagerViewListener
    implements EaseEmojiconPagerView.EaseEmojiconPagerViewListener {
        private EmojiconPagerViewListener() {
        }

        @Override
        public void onPagerViewInited(int groupMaxPageSize, int firstGroupPageSize) {
            EaseEmojiconMenu.this.indicatorView.init(groupMaxPageSize);
            EaseEmojiconMenu.this.indicatorView.updateIndicator(firstGroupPageSize);
            EaseEmojiconMenu.this.tabBar.selectedTo(0);
        }

        @Override
        public void onGroupPositionChanged(int groupPosition, int pagerSizeOfGroup) {
            EaseEmojiconMenu.this.indicatorView.updateIndicator(pagerSizeOfGroup);
            EaseEmojiconMenu.this.tabBar.selectedTo(groupPosition);
        }

        @Override
        public void onGroupInnerPagePostionChanged(int oldPosition, int newPosition) {
            EaseEmojiconMenu.this.indicatorView.selectTo(oldPosition, newPosition);
        }

        @Override
        public void onGroupPagePostionChangedTo(int position) {
            EaseEmojiconMenu.this.indicatorView.selectTo(position);
        }

        @Override
        public void onGroupMaxPageSizeChanged(int maxCount) {
            EaseEmojiconMenu.this.indicatorView.updateIndicator(maxCount);
        }

        @Override
        public void onDeleteImageClicked() {
            if (EaseEmojiconMenu.this.listener != null) {
                EaseEmojiconMenu.this.listener.onDeleteImageClicked();
            }
        }

        @Override
        public void onExpressionClicked(EaseEmojicon emojicon) {
            if (EaseEmojiconMenu.this.listener != null) {
                EaseEmojiconMenu.this.listener.onExpressionClicked(emojicon);
            }
        }
    }
}

