/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.input;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import com.xdja.moments.sdk.widget.input.EmotionEditText;

public class InputControlEditText
extends EmotionEditText {
    private int maxInputLength;
    public InputLengthHintListener mInputLengthHintListener;
    public FilterChineseListener mfChineseListener;
    public GetInputLengthListener mGetInputLengthListener;
    public TextChangedListener mTextChangedListener;
    private MyWatcher mWatcher;

    public InputControlEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public InputControlEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InputControlEditText(Context context) {
        super(context);
    }

    public void setOnFilterChineseListener(FilterChineseListener listener) {
        this.mfChineseListener = listener;
        if (this.mWatcher == null) {
            this.mWatcher = new MyWatcher();
        }
        this.addTextChangedListener(this.mWatcher);
    }

    public void setOnMaxInputListener(int maxInputLength, InputLengthHintListener Listener) {
        this.maxInputLength = maxInputLength;
        this.mInputLengthHintListener = Listener;
        if (this.mWatcher == null) {
            this.mWatcher = new MyWatcher();
        }
        this.addTextChangedListener(this.mWatcher);
    }

    public void setOnGetInputLengthListener(GetInputLengthListener listener) {
        this.mGetInputLengthListener = listener;
        if (this.mWatcher == null) {
            this.mWatcher = new MyWatcher();
        }
        this.addTextChangedListener(this.mWatcher);
    }

    public void setTextChangedListener(TextChangedListener listener) {
        this.mTextChangedListener = listener;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    private class MyWatcher
    implements TextWatcher {
        private CharSequence temp;
        private int editEnd;
        private int editStart;
        private int lastFocusIndex;

        private MyWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.temp = s;
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (InputControlEditText.this.mTextChangedListener != null) {
                InputControlEditText.this.mTextChangedListener.textChanged(s);
            }
        }

        public void afterTextChanged(Editable s) {
            this.editStart = InputControlEditText.this.getSelectionStart();
            this.editEnd = InputControlEditText.this.getSelectionEnd();
            if (s.toString().length() > InputControlEditText.this.maxInputLength && InputControlEditText.this.mInputLengthHintListener != null) {
                InputControlEditText.this.mInputLengthHintListener.onOverFlowHint();
                if (this.lastFocusIndex > 1) {
                    if (this.lastFocusIndex > this.editEnd) {
                        this.lastFocusIndex = this.editEnd;
                        s.delete(this.lastFocusIndex, this.editEnd + (s.toString().length() - InputControlEditText.this.maxInputLength));
                    } else {
                        s.delete(this.lastFocusIndex, this.editEnd);
                    }
                } else {
                    s.delete(InputControlEditText.this.maxInputLength, s.length());
                }
                int tempSelection = this.editStart;
                InputControlEditText.this.setText((CharSequence)s);
                InputControlEditText.this.setSelection(tempSelection);
            }
            if (InputControlEditText.this.mGetInputLengthListener != null) {
                InputControlEditText.this.mGetInputLengthListener.getInputLength(this.temp.length());
            }
            if (InputControlEditText.this.mfChineseListener != null) {
                for (int i = 0; i < this.temp.length(); ++i) {
                    if (!InputControlEditText.isChinese(this.temp.charAt(i))) continue;
                    InputControlEditText.this.mfChineseListener.inputChineseHint();
                    s.delete(this.editStart - 1, this.editEnd);
                    int tempSelection = this.editStart;
                    InputControlEditText.this.setText((CharSequence)s);
                    InputControlEditText.this.setSelection(tempSelection);
                }
            }
            this.lastFocusIndex = this.editStart;
        }
    }

    public static interface TextChangedListener {
        public void textChanged(CharSequence var1);
    }

    public static interface GetInputLengthListener {
        public void getInputLength(int var1);
    }

    public static interface InputLengthHintListener {
        public void onOverFlowHint();
    }

    public static interface FilterChineseListener {
        public void inputChineseHint();
    }
}

