/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.input;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.utils.EmojiUtil;
import com.xdja.moments.sdk.widget.easemob.EaseEmojicon;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconGroupEntity;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconMenu;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconMenuBase;
import com.xdja.moments.sdk.widget.input.AnimationYoYo;
import com.xdja.moments.sdk.widget.input.InputControlEditText;
import java.util.ArrayList;

public class InputLinearLayout
extends LinearLayout
implements InputControlEditText.InputLengthHintListener,
InputControlEditText.TextChangedListener {
    private int maxlength = 200;
    private boolean isChat;
    private InputControlEditText chat_et;
    private Button send_btn;
    private ImageButton add_btn;
    private SendClickListener onSendClickListener;
    private Activity context;
    private FrameLayout emojiconMenuContainer;
    private Handler handler = new Handler();

    public InputLinearLayout(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.moments_review_layout, (ViewGroup)this, true);
    }

    public InputLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.moments_review_layout, (ViewGroup)this, true);
    }

    public void initView(final Activity context, boolean isChat, final SendClickListener onSendClickListener) {
        this.context = context;
        this.isChat = isChat;
        this.send_btn = (Button)this.findViewById(R.id.send_btn);
        this.add_btn = (ImageButton)this.findViewById(R.id.add_btn);
        this.send_btn.setEnabled(false);
        if (!isChat) {
            this.send_btn.setVisibility(0);
            this.add_btn.setVisibility(8);
        }
        final ImageButton face_btn = (ImageButton)this.findViewById(R.id.face_btn);
        this.chat_et = (InputControlEditText)this.findViewById(R.id.chat_et);
        this.chat_et.setOnMaxInputListener(this.maxlength, this);
        this.chat_et.setTextChangedListener(this);
        this.emojiconMenuContainer = (FrameLayout)this.findViewById(R.id.emojicon_menu_container);
        EaseEmojiconMenu emojiconMenu = (EaseEmojiconMenu)LayoutInflater.from((Context)context).inflate(R.layout.moments_ease_layout_emojicon_menu, null);
        ArrayList<EaseEmojiconGroupEntity> emojiconGroupList = new ArrayList<EaseEmojiconGroupEntity>();
        emojiconGroupList.add(new EaseEmojiconGroupEntity(R.drawable.emoji_001, FaceManager.getInstance().getEmojiconList()));
        emojiconMenu.init(emojiconGroupList);
        this.emojiconMenuContainer.addView((View)emojiconMenu);
        emojiconMenu.setEmojiconMenuListener(new EaseEmojiconMenuBase.EaseEmojiconMenuListener(){

            @Override
            public void onExpressionClicked(EaseEmojicon emojicon) {
                InputLinearLayout.this.chat_et.insertEmotion((Context)context, emojicon);
            }

            @Override
            public void onDeleteImageClicked() {
                InputLinearLayout.this.chat_et.onEmojiconDeleteEvent();
            }
        });
        this.chat_et.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(final Editable s) {
                InputLinearLayout.this.send_btn.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        InputLinearLayout.this.send_btn.setEnabled(!TextUtils.isEmpty((CharSequence)s.toString()));
                        InputLinearLayout.this.send_btn.setTextColor(!TextUtils.isEmpty((CharSequence)s.toString()) ? InputLinearLayout.this.getResources().getColor(R.color.moments_white) : InputLinearLayout.this.getResources().getColor(R.color.moments_text_gray));
                    }
                }, 100L);
            }
        });
        this.chat_et.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                InputLinearLayout.this.chat_et.requestFocus();
                EmojiUtil.showKeyboard((View)InputLinearLayout.this.chat_et);
                InputLinearLayout.this.emojiconMenuContainer.setVisibility(8);
                face_btn.setImageResource(R.drawable.moments_message_face);
                return false;
            }
        });
        face_btn.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View v) {
                if (InputLinearLayout.this.emojiconMenuContainer.getVisibility() != 0) {
                    InputLinearLayout.this.chat_et.requestFocus();
                    EmojiUtil.hidKeyboard((View)InputLinearLayout.this.chat_et);
                    InputLinearLayout.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            InputLinearLayout.this.emojiconMenuContainer.setVisibility(0);
                            ((ImageButton)v).setImageResource(R.drawable.moments_message_keyboard);
                        }
                    }, 90L);
                } else {
                    InputLinearLayout.this.chat_et.requestFocus();
                    EmojiUtil.showKeyboard((View)InputLinearLayout.this.chat_et);
                    InputLinearLayout.this.emojiconMenuContainer.setVisibility(8);
                    ((ImageButton)v).setImageResource(R.drawable.moments_message_face);
                }
            }
        });
        this.send_btn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onSendClickListener != null) {
                    onSendClickListener.onSendClick(InputLinearLayout.this.chat_et.getText().toString());
                }
            }
        });
    }

    public void hideEmoji() {
        this.emojiconMenuContainer.setVisibility(8);
        ImageButton face_btn = (ImageButton)this.findViewById(R.id.face_btn);
        face_btn.setImageResource(R.drawable.moments_message_face);
    }

    public void hideKeyboardAndEmoji() {
        EmojiUtil.hidKeyboard((View)this.chat_et);
        this.emojiconMenuContainer.setVisibility(8);
        ImageButton face_btn = (ImageButton)this.findViewById(R.id.face_btn);
        face_btn.setImageResource(R.drawable.moments_message_face);
    }

    public void hideKeyboard() {
        EmojiUtil.hidKeyboard((View)this.chat_et);
    }

    public void clear() {
        this.chat_et.setText("");
    }

    public String getInputText() {
        return this.chat_et.getText().toString();
    }

    public void setHint(String hint) {
        this.chat_et.setHint(hint);
    }

    public EditText getEditText() {
        return this.chat_et;
    }

    public void setOnSendClickListener(SendClickListener onSendClickListener) {
        this.onSendClickListener = onSendClickListener;
    }

    @Override
    public void onOverFlowHint() {
        Toast.makeText((Context)this.context, (CharSequence)this.getResources().getString(R.string.moments_add_text_over_comment_hint), (int)0).show();
        AnimationYoYo.shakeView((View)this.chat_et);
    }

    @Override
    public void textChanged(CharSequence s) {
        if (!this.isChat) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)s)) {
            this.add_btn.setVisibility(8);
            this.send_btn.setVisibility(0);
        } else {
            this.add_btn.setVisibility(0);
            this.send_btn.setVisibility(8);
        }
    }

    public static interface SendClickListener {
        public void onSendClick(String var1);
    }
}

