/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture;

import android.os.Environment;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VideoFile {
    private static final String DIRECTORY_SEPARATOR = "/";
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmss";
    private static final String DEFAULT_PREFIX = "video_";
    private static final String DEFAULT_EXTENSION = ".mp4";
    private static final String TAG = "VideoFile";
    private final String mFilename;
    private Date mDate;

    public VideoFile(String filename) {
        this.mFilename = filename;
    }

    public VideoFile(String filename, Date date) {
        this(filename);
        this.mDate = date;
    }

    public String getFullPath() {
        return this.getFile().getAbsolutePath();
    }

    public File getFile() {
        String filename = this.generateFilename();
        if (filename.contains(DIRECTORY_SEPARATOR)) {
            return new File(filename);
        }
        File path = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/moments/video");
        path.mkdirs();
        return new File(path, this.generateFilename());
    }

    private String generateFilename() {
        if (this.isValidFilename()) {
            return this.mFilename;
        }
        String dateStamp = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault()).format(this.getDate());
        return DEFAULT_PREFIX + dateStamp + DEFAULT_EXTENSION;
    }

    private boolean isValidFilename() {
        if (this.mFilename == null) {
            return false;
        }
        return !this.mFilename.isEmpty();
    }

    private Date getDate() {
        if (this.mDate == null) {
            this.mDate = new Date();
        }
        return this.mDate;
    }
}

