/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.camera;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.os.Build;
import android.view.SurfaceHolder;
import com.moments.landscapevideocapture.CLog;
import com.moments.landscapevideocapture.camera.OpenCameraException;
import com.moments.landscapevideocapture.camera.PrepareCameraException;
import com.moments.landscapevideocapture.camera.RecordingSize;
import java.io.IOException;
import java.util.List;

public class CameraWrapper {
    private Camera mCamera = null;
    private Camera.Parameters mParameters = null;
    private static boolean isBackOrFront = true;

    public static boolean getBackOrFront() {
        return isBackOrFront;
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public void openCamera() throws OpenCameraException {
        this.mCamera = null;
        try {
            this.mCamera = this.openCameraFromSystem();
            this.mCamera.setDisplayOrientation(90);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new OpenCameraException(OpenCameraException.OpenType.INUSE);
        }
        if (this.mCamera == null) {
            throw new OpenCameraException(OpenCameraException.OpenType.NOCAMERA);
        }
    }

    public void prepareCameraForRecording() throws PrepareCameraException {
        try {
            this.storeCameraParametersBeforeUnlocking();
            this.unlockCameraFromSystem();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new PrepareCameraException();
        }
    }

    public void releaseCamera() {
        if (this.getCamera() == null) {
            return;
        }
        this.releaseCameraFromSystem();
    }

    public void startPreview(SurfaceHolder holder) throws IOException {
        this.mCamera.setPreviewDisplay(holder);
        this.mCamera.startPreview();
    }

    public void stopPreview() throws Exception {
        this.mCamera.stopPreview();
        this.mCamera.setPreviewCallback(null);
    }

    public RecordingSize getSupportedRecordingSize(int width, int height) {
        Camera.Size recordingSize = this.getOptimalSize(this.getSupportedVideoSizes(), width, height);
        if (recordingSize == null) {
            CLog.e("VideoCapture_CameraWrapper", "Failed to find supported recording size - falling back to requested: " + width + "x" + height);
            return new RecordingSize(width, height);
        }
        CLog.d("VideoCapture_CameraWrapper", "Recording size: " + recordingSize.width + "x" + recordingSize.height);
        return new RecordingSize(recordingSize.width, recordingSize.height);
    }

    public CamcorderProfile getBaseRecordingProfile() {
        if (CamcorderProfile.hasProfile((int)5)) {
            return CamcorderProfile.get((int)5);
        }
        if (CamcorderProfile.hasProfile((int)4)) {
            return CamcorderProfile.get((int)4);
        }
        return CamcorderProfile.get((int)1);
    }

    public void configureForPreview(int viewWidth, int viewHeight) {
        Camera.Parameters params = this.getCameraParametersFromSystem();
        Camera.Size previewSize = this.getOptimalSize(params.getSupportedPreviewSizes(), viewWidth, viewHeight);
        params.setPreviewSize(previewSize.width, previewSize.height);
        params.setPreviewFormat(17);
        this.mCamera.setParameters(params);
        CLog.d("VideoCapture_CameraWrapper", "Preview size: " + previewSize.width + "x" + previewSize.height);
    }

    public void enableAutoFocus() {
        Camera.Parameters params = this.getCameraParametersFromSystem();
        params.setFocusMode("continuous-video");
        this.mCamera.setParameters(params);
    }

    protected Camera openCameraFromSystem() {
        isBackOrFront = true;
        return Camera.open((int)0);
    }

    protected void unlockCameraFromSystem() {
        this.mCamera.unlock();
    }

    protected void releaseCameraFromSystem() {
        this.mCamera.release();
    }

    protected Camera.Parameters getCameraParametersFromSystem() {
        return this.mCamera.getParameters();
    }

    protected List<Camera.Size> getSupportedVideoSizes() {
        Camera.Parameters params = this.getCameraParametersAfterUnlocking();
        if (Build.VERSION.SDK_INT >= 11) {
            return params.getSupportedVideoSizes();
        }
        CLog.e("VideoCapture_CameraWrapper", "Using supportedPreviewSizes iso supportedVideoSizes due to API restriction");
        return params.getSupportedPreviewSizes();
    }

    protected void storeCameraParametersBeforeUnlocking() {
        this.mParameters = this.getCameraParametersFromSystem();
    }

    public void openFindBackOrFrontCamera() {
        if (isBackOrFront) {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mCamera = Camera.open((int)1);
            isBackOrFront = false;
        } else {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mCamera = Camera.open((int)0);
            isBackOrFront = true;
        }
        this.mCamera.setDisplayOrientation(90);
    }

    private Camera.Parameters getCameraParametersAfterUnlocking() {
        return this.mParameters;
    }

    public Camera.Size getOptimalSize(List<Camera.Size> sizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }
}

