/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.camera;

import com.moments.landscapevideocapture.CLog;

public class OpenCameraException
extends Exception {
    private static final String LOG_PREFIX = "Unable to open camera - ";
    private static final long serialVersionUID = -7340415176385044242L;
    private final OpenType mType;

    public OpenCameraException(OpenType type) {
        super(type.getMessage());
        this.mType = type;
    }

    @Override
    public void printStackTrace() {
        CLog.e("VideoCapture_Exception", LOG_PREFIX + this.mType.getMessage());
        super.printStackTrace();
    }

    public static enum OpenType {
        INUSE("Camera disabled or in use by other process"),
        NOCAMERA("Device does not have camera");

        private String mMessage;

        private OpenType(String msg) {
            this.mMessage = msg;
        }

        public String getMessage() {
            return this.mMessage;
        }
    }
}

