/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.configuration;

import android.os.Parcel;
import android.os.Parcelable;
import com.moments.landscapevideocapture.configuration.PredefinedCaptureConfigurations;

public class CaptureConfiguration
implements Parcelable {
    private static final int MBYTE_TO_BYTE = 0x100000;
    private static final int MSEC_TO_SEC = 1000;
    public static final int NO_DURATION_LIMIT = -1;
    public static final int NO_FILESIZE_LIMIT = -1;
    private int mVideoWidth = 1280;
    private int mVideoHeight = 720;
    private int mBitrate = 5000000;
    private int mMaxDurationMs = -1;
    private int mMaxFilesizeBytes = -1;
    private int OUTPUT_FORMAT = 2;
    private int AUDIO_SOURCE = 0;
    private int AUDIO_ENCODER = 3;
    private int VIDEO_SOURCE = 1;
    private int VIDEO_ENCODER = 2;
    public static final Parcelable.Creator<CaptureConfiguration> CREATOR = new Parcelable.Creator<CaptureConfiguration>(){

        public CaptureConfiguration createFromParcel(Parcel in) {
            return new CaptureConfiguration(in);
        }

        public CaptureConfiguration[] newArray(int size) {
            return new CaptureConfiguration[size];
        }
    };

    public CaptureConfiguration() {
    }

    public CaptureConfiguration(PredefinedCaptureConfigurations.CaptureResolution resolution, PredefinedCaptureConfigurations.CaptureQuality quality) {
        this.mVideoWidth = resolution.width;
        this.mVideoHeight = resolution.height;
        this.mBitrate = resolution.getBitrate(quality);
    }

    public CaptureConfiguration(PredefinedCaptureConfigurations.CaptureResolution resolution, PredefinedCaptureConfigurations.CaptureQuality quality, int maxDurationSecs, int maxFilesizeMb) {
        this(resolution, quality);
        this.mMaxDurationMs = maxDurationSecs * 1000;
        this.mMaxFilesizeBytes = maxFilesizeMb * 0x100000;
    }

    public CaptureConfiguration(int videoWidth, int videoHeight, int bitrate) {
        this.mVideoWidth = videoWidth;
        this.mVideoHeight = videoHeight;
        this.mBitrate = bitrate;
    }

    public CaptureConfiguration(int videoWidth, int videoHeight, int bitrate, int maxDurationSecs, int maxFilesizeMb) {
        this(videoWidth, videoHeight, bitrate);
        this.mMaxDurationMs = maxDurationSecs * 1000;
        this.mMaxFilesizeBytes = maxFilesizeMb * 0x100000;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public int getVideoBitrate() {
        return this.mBitrate;
    }

    public int getMaxCaptureDuration() {
        return this.mMaxDurationMs;
    }

    public int getMaxCaptureFileSize() {
        return this.mMaxFilesizeBytes;
    }

    public int getOutputFormat() {
        return this.OUTPUT_FORMAT;
    }

    public int getAudioSource() {
        return this.AUDIO_SOURCE;
    }

    public int getAudioEncoder() {
        return this.AUDIO_ENCODER;
    }

    public int getVideoSource() {
        return this.VIDEO_SOURCE;
    }

    public int getVideoEncoder() {
        return this.VIDEO_ENCODER;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mVideoWidth);
        dest.writeInt(this.mVideoHeight);
        dest.writeInt(this.mBitrate);
        dest.writeInt(this.mMaxDurationMs);
        dest.writeInt(this.mMaxFilesizeBytes);
        dest.writeInt(this.OUTPUT_FORMAT);
        dest.writeInt(this.AUDIO_SOURCE);
        dest.writeInt(this.AUDIO_ENCODER);
        dest.writeInt(this.VIDEO_SOURCE);
        dest.writeInt(this.VIDEO_ENCODER);
    }

    private CaptureConfiguration(Parcel in) {
        this.mVideoWidth = in.readInt();
        this.mVideoHeight = in.readInt();
        this.mBitrate = in.readInt();
        this.mMaxDurationMs = in.readInt();
        this.mMaxFilesizeBytes = in.readInt();
        this.OUTPUT_FORMAT = in.readInt();
        this.AUDIO_SOURCE = in.readInt();
        this.AUDIO_ENCODER = in.readInt();
        this.VIDEO_SOURCE = in.readInt();
        this.VIDEO_ENCODER = in.readInt();
    }
}

