/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.preview;

import android.util.Log;
import android.view.SurfaceHolder;
import com.moments.landscapevideocapture.CLog;
import com.moments.landscapevideocapture.camera.CameraWrapper;
import com.moments.landscapevideocapture.preview.CapturePreviewInterface;
import java.io.IOException;

public class CapturePreview
implements SurfaceHolder.Callback {
    private boolean mPreviewRunning = false;
    private final CapturePreviewInterface mInterface;
    public final CameraWrapper mCameraWrapper;

    public CapturePreview(CapturePreviewInterface capturePreviewInterface, CameraWrapper cameraWrapper, SurfaceHolder holder) {
        this.mInterface = capturePreviewInterface;
        this.mCameraWrapper = cameraWrapper;
        this.initalizeSurfaceHolder(holder);
    }

    private void initalizeSurfaceHolder(SurfaceHolder surfaceHolder) {
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        surfaceHolder.setType(3);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.e((String)"surfaceCreated", (String)"surfaceCreated");
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mPreviewRunning) {
            try {
                this.mCameraWrapper.stopPreview();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.mCameraWrapper.configureForPreview(height, width);
            CLog.d("VideoCapture_Preview", "Configured camera for preview in surface of " + width + " by " + height);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CLog.d("VideoCapture_Preview", "Failed to show preview - invalid parameters set to camera preview");
            this.mInterface.onCapturePreviewFailed();
            return;
        }
        try {
            this.mCameraWrapper.enableAutoFocus();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CLog.d("VideoCapture_Preview", "AutoFocus not available for preview");
        }
        try {
            this.mCameraWrapper.startPreview(holder);
            this.setPreviewRunning(true);
        }
        catch (IOException e) {
            e.printStackTrace();
            CLog.d("VideoCapture_Preview", "Failed to show preview - unable to connect camera to preview (IOException)");
            this.mInterface.onCapturePreviewFailed();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CLog.d("VideoCapture_Preview", "Failed to show preview - unable to start camera preview (RuntimeException)");
            this.mInterface.onCapturePreviewFailed();
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.e((String)"surfaceCreated", (String)"surfaceCreated");
    }

    public void releasePreviewResources() {
        if (this.mPreviewRunning) {
            try {
                this.mCameraWrapper.stopPreview();
                this.setPreviewRunning(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                CLog.e("VideoCapture_Preview", "Failed to clean up preview resources");
            }
        }
    }

    public void setPreviewRunning(boolean running) {
        this.mPreviewRunning = running;
    }
}

