/*
 * Decompiled with CFR 0.152.
 */
package com.moments.landscapevideocapture.recorder;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.moments.landscapevideocapture.CLog;
import com.moments.landscapevideocapture.VideoFile;
import com.moments.landscapevideocapture.camera.CameraWrapper;
import com.moments.landscapevideocapture.camera.OpenCameraException;
import com.moments.landscapevideocapture.camera.PrepareCameraException;
import com.moments.landscapevideocapture.camera.RecordingSize;
import com.moments.landscapevideocapture.configuration.CaptureConfiguration;
import com.moments.landscapevideocapture.preview.CapturePreview;
import com.moments.landscapevideocapture.preview.CapturePreviewInterface;
import com.moments.landscapevideocapture.recorder.VideoRecorderInterface;
import java.io.IOException;

public class VideoRecorder
implements MediaRecorder.OnInfoListener,
CapturePreviewInterface {
    private CameraWrapper mCameraWrapper;
    private final Surface mPreviewSurface;
    private CapturePreview mVideoCapturePreview;
    private final CaptureConfiguration mCaptureConfiguration;
    private final VideoFile mVideoFile;
    private SurfaceHolder mPreviewHolder;
    private MediaRecorder mRecorder;
    private boolean mRecording = false;
    private final VideoRecorderInterface mRecorderInterface;
    private int mOrientation = -1;

    public void setmOrientation(int mOrientation) {
        this.mOrientation = mOrientation;
    }

    public VideoRecorder(VideoRecorderInterface recorderInterface, CaptureConfiguration captureConfiguration, VideoFile videoFile, CameraWrapper cameraWrapper, SurfaceHolder previewHolder) {
        this.mCaptureConfiguration = captureConfiguration;
        this.mRecorderInterface = recorderInterface;
        this.mVideoFile = videoFile;
        this.mCameraWrapper = cameraWrapper;
        this.mPreviewSurface = previewHolder.getSurface();
        this.mPreviewHolder = previewHolder;
        this.initializeCameraAndPreview(previewHolder);
    }

    protected void initializeCameraAndPreview(SurfaceHolder previewHolder) {
        try {
            this.mCameraWrapper.openCamera();
        }
        catch (OpenCameraException e) {
            e.printStackTrace();
            this.mRecorderInterface.onRecordingFailed("\u76f8\u673a\u542f\u52a8\u5931\u8d25");
            return;
        }
        this.mVideoCapturePreview = new CapturePreview(this, this.mCameraWrapper, previewHolder);
    }

    public void toggleRecording() {
        if (this.isRecording()) {
            this.stopRecording(null);
        } else {
            this.startRecording();
        }
    }

    protected void startRecording() {
        this.mRecording = false;
        if (!this.initRecorder()) {
            return;
        }
        if (!this.prepareRecorder()) {
            return;
        }
        if (!this.startRecorder()) {
            return;
        }
        this.mRecording = true;
        this.mRecorderInterface.onRecordingStarted();
        CLog.d("VideoCapture_VideoRecorder", "Successfully started recording - outputfile: " + this.mVideoFile.getFullPath());
    }

    public void stopRecording(String message) {
        if (!this.isRecording()) {
            return;
        }
        try {
            this.getMediaRecorder().stop();
            this.mRecorderInterface.onRecordingSuccess();
            CLog.d("VideoCapture_VideoRecorder", "Successfully stopped recording - outputfile: " + this.mVideoFile.getFullPath());
        }
        catch (RuntimeException e) {
            CLog.e("VideoCapture_VideoRecorder", "Failed to stop recording");
        }
        this.mRecording = false;
        this.mRecorderInterface.onRecordingStopped(message);
    }

    public void openFindBackOrFrontCamera() {
        this.mCameraWrapper.openFindBackOrFrontCamera();
        try {
            this.mCameraWrapper.startPreview(this.mPreviewHolder);
            this.mVideoCapturePreview.setPreviewRunning(true);
        }
        catch (IOException e) {
            e.printStackTrace();
            CLog.d("VideoCapture_Preview", "Failed to show preview - unable to connect camera to preview (IOException)");
            this.onCapturePreviewFailed();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            CLog.d("VideoCapture_Preview", "Failed to show preview - unable to start camera preview (RuntimeException)");
            this.onCapturePreviewFailed();
        }
    }

    private boolean initRecorder() {
        try {
            this.mCameraWrapper.prepareCameraForRecording();
        }
        catch (PrepareCameraException e) {
            e.printStackTrace();
            this.mRecorderInterface.onRecordingFailed("\u65e0\u6cd5\u5f55\u5236\u89c6\u9891");
            CLog.e("VideoCapture_VideoRecorder", "Failed to initialize recorder - " + e.toString());
            return false;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            CLog.e("VideoCapture_VideoRecorder", "\u7a7a\u6307\u9488\u5f15\u7528 - " + e1.toString());
        }
        this.mRecorder = new MediaRecorder();
        if (this.mCameraWrapper != null) {
            this.configureMediaRecorder(this.getMediaRecorder(), this.mCameraWrapper.getCamera());
        } else {
            CLog.e("VideoCapture_VideoRecorder", "\u9519\u8bef===\u300berr null==\u300b" + this.mCameraWrapper);
        }
        CLog.d("VideoCapture_VideoRecorder", "MediaRecorder successfully initialized");
        return true;
    }

    protected void configureMediaRecorder(MediaRecorder recorder, Camera camera) throws IllegalStateException, IllegalArgumentException {
        recorder.setCamera(camera);
        Log.e((String)"configureMediaRecorder", (String)"configureMediaRecorder=======>");
        recorder.setAudioSource(this.mCaptureConfiguration.getAudioSource());
        recorder.setVideoSource(this.mCaptureConfiguration.getVideoSource());
        CamcorderProfile baseProfile = this.mCameraWrapper.getBaseRecordingProfile();
        baseProfile.fileFormat = this.mCaptureConfiguration.getOutputFormat();
        RecordingSize size = this.mCameraWrapper.getSupportedRecordingSize(this.mCaptureConfiguration.getVideoWidth(), this.mCaptureConfiguration.getVideoHeight());
        baseProfile.videoFrameWidth = size.width;
        baseProfile.videoFrameHeight = size.height;
        baseProfile.videoBitRate = this.mCaptureConfiguration.getVideoBitrate();
        baseProfile.audioCodec = this.mCaptureConfiguration.getAudioEncoder();
        baseProfile.videoCodec = this.mCaptureConfiguration.getVideoEncoder();
        recorder.setProfile(baseProfile);
        recorder.setVideoFrameRate(baseProfile.videoFrameRate);
        recorder.setMaxDuration(this.mCaptureConfiguration.getMaxCaptureDuration());
        recorder.setOutputFile(this.mVideoFile.getFullPath());
        if (CameraWrapper.getBackOrFront()) {
            recorder.setOrientationHint(90);
        } else {
            recorder.setOrientationHint(270);
        }
        try {
            recorder.setMaxFileSize((long)this.mCaptureConfiguration.getMaxCaptureFileSize());
        }
        catch (IllegalArgumentException e) {
            CLog.e("VideoCapture_VideoRecorder", "Failed to set max filesize - illegal argument: " + this.mCaptureConfiguration.getMaxCaptureFileSize());
        }
        catch (RuntimeException e2) {
            CLog.e("VideoCapture_VideoRecorder", "Failed to set max filesize - runtime exception");
        }
        recorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
    }

    private boolean prepareRecorder() {
        try {
            this.getMediaRecorder().prepare();
            CLog.d("VideoCapture_VideoRecorder", "MediaRecorder successfully prepared");
            return true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            CLog.e("VideoCapture_VideoRecorder", "MediaRecorder preparation failed - " + e.toString());
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            CLog.e("VideoCapture_VideoRecorder", "MediaRecorder preparation failed - " + e.toString());
            return false;
        }
    }

    private boolean startRecorder() {
        try {
            this.getMediaRecorder().start();
            CLog.d("VideoCapture_VideoRecorder", "MediaRecorder successfully started");
            return true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            CLog.e("VideoCapture_VideoRecorder", "MediaRecorder start failed - " + e.toString());
            return false;
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            CLog.e("VideoCapture_VideoRecorder", "MediaRecorder start failed - " + e2.toString());
            this.mRecorderInterface.onRecordingFailed("\u89c6\u9891\u5f55\u5236\u53c2\u6570\u4e0d\u6b63\u786e");
            return false;
        }
    }

    public boolean isRecording() {
        return this.mRecording;
    }

    protected MediaRecorder getMediaRecorder() {
        return this.mRecorder;
    }

    private void releaseRecorderResources() {
        MediaRecorder recorder = this.getMediaRecorder();
        if (recorder != null) {
            recorder.release();
            recorder = null;
        }
    }

    public void releaseAllResources() {
        if (this.mVideoCapturePreview != null) {
            this.mVideoCapturePreview.releasePreviewResources();
        }
        if (this.mPreviewHolder != null) {
            this.mPreviewHolder.removeCallback((SurfaceHolder.Callback)this.mVideoCapturePreview);
        }
        if (this.mCameraWrapper != null) {
            this.mCameraWrapper.releaseCamera();
            this.mCameraWrapper = null;
        }
        this.releaseRecorderResources();
        CLog.d("VideoCapture_VideoRecorder", "Released all resources");
    }

    @Override
    public void onCapturePreviewFailed() {
        this.mRecorderInterface.onRecordingFailed("\u65e0\u6cd5\u663e\u793a\u76f8\u673a\u9884\u89c8!");
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
        switch (what) {
            case 1: {
                break;
            }
            case 800: {
                CLog.d("VideoCapture_VideoRecorder", "MediaRecorder max duration reached");
                this.stopRecording("\u505c\u6b62\u62cd\u6444-\u8fbe\u5230\u6700\u5927\u6301\u7eed\u65f6\u95f4");
                break;
            }
            case 801: {
                CLog.d("VideoCapture_VideoRecorder", "MediaRecorder max filesize reached");
                this.stopRecording("\u505c\u6b62\u62cd\u6444-\u6587\u4ef6\u8fc7\u5927");
                break;
            }
        }
    }
}

